/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.MimeHeader;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValues;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.util.Pair;

public final class MimeTransfer {
    private static final String TRANSFER_TASK_NAME = "Transfer MIME body";

    private MimeTransfer() {
    }

    public static IAsync<IOException> transfer(MimeHeaders headers, IO.Readable body, Supplier<List<MimeHeader>> trailerSupplier, AsyncConsumer<ByteBuffer, IOException> sender) {
        long bodySize;
        if (body == null) {
            bodySize = 0L;
        } else if (body instanceof IO.KnownSize) {
            try {
                bodySize = ((IO.KnownSize)body).getSizeSync();
            }
            catch (IOException e) {
                return new Async((Exception)e);
            }
        } else {
            bodySize = -1L;
        }
        AsyncConsumer<ByteBuffer, IOException> transfer = MimeTransfer.createTransfer(headers, bodySize, trailerSupplier, sender);
        IAsync sendHeaders = sender.push(Arrays.asList(headers.generateString(4096).asByteBuffers()));
        Task.Priority prio = Task.getCurrentPriority();
        if (bodySize == 0L) {
            return sendHeaders;
        }
        if (sendHeaders.isSuccessful()) {
            return body.createProducer(false).toConsumer(transfer, TRANSFER_TASK_NAME, prio);
        }
        Async result = new Async();
        sendHeaders.thenStart(TRANSFER_TASK_NAME, prio, () -> body.createProducer(false).toConsumer(transfer, TRANSFER_TASK_NAME, prio).onDone(result), (IAsync)result);
        return result;
    }

    public static IAsync<IOException> transfer(MimeEntity entity, Supplier<List<MimeHeader>> trailerSupplier, AsyncConsumer<ByteBuffer, IOException> sender) {
        AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> body = entity.createBodyProducer();
        Async result = new Async();
        Task.Priority prio = Task.getCurrentPriority();
        body.thenStart("Transfer MIME headers", prio, () -> {
            Long size = (Long)((Pair)body.getResult()).getValue1();
            AsyncConsumer<ByteBuffer, IOException> transfer = MimeTransfer.createTransfer(entity.getHeaders(), size == null ? -1L : size, trailerSupplier, sender);
            IAsync sendHeaders = sender.push(Arrays.asList(entity.getHeaders().generateString(4096).asByteBuffers()));
            sendHeaders.thenStart(TRANSFER_TASK_NAME, prio, () -> ((AsyncProducer)((Pair)body.getResult()).getValue2()).toConsumer(transfer, TRANSFER_TASK_NAME, prio).onDone(result), (IAsync)result);
        }, (IAsync)result);
        return result;
    }

    public static AsyncConsumer<ByteBuffer, IOException> createTransfer(MimeHeaders headers, long bodySize, Supplier<List<MimeHeader>> trailerSupplier, AsyncConsumer<ByteBuffer, IOException> sender) {
        if (bodySize == 0L) {
            List<MimeHeader> trailers;
            headers.setContentLength(0L);
            if (trailerSupplier != null && (trailers = trailerSupplier.get()) != null) {
                for (MimeHeader header : trailers) {
                    headers.add(header);
                }
            }
            headers.remove("Trailer");
            return sender;
        }
        if (trailerSupplier == null) {
            ParameterizedHeaderValues transferEncoding;
            try {
                transferEncoding = headers.getFirstValue("Transfer-Encoding", ParameterizedHeaderValues.class);
            }
            catch (Exception e) {
                transferEncoding = null;
            }
            if (!(bodySize <= 0L || transferEncoding != null && transferEncoding.hasMainValue("chunked"))) {
                headers.setRawValue("Content-Length", Long.toString(bodySize));
                return sender;
            }
        }
        headers.setRawValue("Transfer-Encoding", "chunked");
        headers.remove("Content-Length");
        return new ChunkedTransfer.Sender(sender, trailerSupplier);
    }
}

