/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.PartialAsyncConsumer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.mime.header.MimeHeaders;

public final class IdentityTransfer {
    public static final String TRANSFER_NAME = "identity";

    private IdentityTransfer() {
    }

    public static class Receiver
    implements PartialAsyncConsumer<ByteBuffer, IOException> {
        private long pos = 0L;
        private long size;
        private boolean eot;
        private AsyncConsumer<ByteBuffer, IOException> consumer;
        private Logger logger;

        public Receiver(MimeHeaders headers, AsyncConsumer<ByteBuffer, IOException> consumer) throws IOException {
            this.consumer = consumer;
            Long s = headers.getContentLength();
            if (s == null) {
                throw new IOException("No content length for identity transfer: impossible to transfer data");
            }
            this.size = s;
            this.eot = this.size == 0L;
            this.logger = LCCore.getApplication().getLoggerFactory().getLogger(IdentityTransfer.class);
        }

        public boolean isExpectingData() {
            return this.size > 0L;
        }

        public AsyncSupplier<Boolean, IOException> consume(ByteBuffer buf) {
            ByteBuffer subBuffer;
            AsyncSupplier result = new AsyncSupplier();
            if (this.eot) {
                if (this.logger.trace()) {
                    this.logger.trace("End of identity transfer");
                }
                this.consumer.end().onDone(() -> result.unblockSuccess((Object)Boolean.TRUE), (IAsync)result);
                return result;
            }
            int l = buf.remaining();
            if (this.pos + (long)l > this.size) {
                int l2 = (int)(this.size - this.pos);
                subBuffer = buf.duplicate();
                subBuffer.limit(buf.limit() - (l - l2));
                l = l2;
            } else {
                subBuffer = buf.duplicate();
            }
            if (this.logger.trace()) {
                this.logger.trace("Received bytes: " + l + " at " + this.pos + "/" + this.size);
            }
            this.pos += (long)l;
            buf.position(buf.position() + l);
            this.eot = this.pos == this.size;
            IAsync decode = this.consumer.consume((Object)subBuffer.asReadOnlyBuffer());
            decode.onDone(() -> {
                if (decode.isSuccessful()) {
                    if (!this.eot) {
                        result.unblockSuccess((Object)Boolean.FALSE);
                    } else {
                        if (this.logger.trace()) {
                            this.logger.trace("End of identity transfer");
                        }
                        this.consumer.end().onDone(() -> result.unblockSuccess((Object)Boolean.TRUE), (IAsync)result);
                    }
                } else if (decode.hasError()) {
                    result.unblockError((Exception)IO.error((Throwable)decode.getError()));
                } else {
                    result.cancel(decode.getCancelEvent());
                }
            });
            return result;
        }
    }
}

