/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.lecousin.compression.gzip.GZipConsumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.BufferedAsyncConsumer;
import net.lecousin.framework.encoding.Base64Encoding;
import net.lecousin.framework.encoding.QuotedPrintable;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.transfer.TransferEncodingFactory;

public final class ContentDecoderFactory {
    private static Map<String, UnaryOperator<AsyncConsumer<ByteBuffer, IOException>>> decoders = new HashMap<String, UnaryOperator<AsyncConsumer<ByteBuffer, IOException>>>();

    private ContentDecoderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoder(String encoding, UnaryOperator<AsyncConsumer<ByteBuffer, IOException>> decoderSupplier) {
        encoding = encoding.toLowerCase();
        Map<String, UnaryOperator<AsyncConsumer<ByteBuffer, IOException>>> map = decoders;
        synchronized (map) {
            decoders.put(encoding, decoderSupplier);
        }
    }

    public static List<String> getSupportedEncoding() {
        return new ArrayList<String>(decoders.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncConsumer<ByteBuffer, IOException> createDecoder(AsyncConsumer<ByteBuffer, IOException> next, String encoding) {
        Logger logger;
        UnaryOperator<AsyncConsumer<ByteBuffer, IOException>> supplier = null;
        boolean hasDecoder = false;
        String elc = encoding.toLowerCase();
        Map<String, UnaryOperator<AsyncConsumer<ByteBuffer, IOException>>> map = decoders;
        synchronized (map) {
            if (decoders.containsKey(elc)) {
                hasDecoder = true;
                supplier = decoders.get(elc);
            }
        }
        if (!hasDecoder && (logger = LCCore.getApplication().getLoggerFactory().getLogger(ContentDecoderFactory.class)).error()) {
            logger.error("Content encoding '" + encoding + "' not supported, data may not be readable.");
        }
        if (supplier == null) {
            return next;
        }
        return (AsyncConsumer)supplier.apply(next);
    }

    public static AsyncConsumer<ByteBuffer, IOException> createDecoder(AsyncConsumer<ByteBuffer, IOException> consumer, MimeHeaders headers) {
        LinkedList<String> encoding = new LinkedList<String>();
        TransferEncodingFactory.encodingAndTransferFromHeader(headers, "Content-Transfer-Encoding", encoding, null);
        TransferEncodingFactory.addEncodingFromHeader(headers, "Content-Encoding", encoding);
        for (String coding : encoding) {
            consumer = ContentDecoderFactory.createDecoder(consumer, coding);
        }
        return consumer;
    }

    static {
        ContentDecoderFactory.registerDecoder("7bit", null);
        ContentDecoderFactory.registerDecoder("8bit", null);
        ContentDecoderFactory.registerDecoder("identity", null);
        ContentDecoderFactory.registerDecoder("binary", null);
        ContentDecoderFactory.registerDecoder("base64", next -> {
            Base64Encoding base64Encoding = Base64Encoding.instance;
            base64Encoding.getClass();
            return new Base64Encoding.DecoderConsumer(base64Encoding, next.convert(Bytes::toByteBuffer), err -> new IOException("Error decoding base 64 MIME content", (Throwable)err)).convert(ByteArray::fromByteBuffer);
        });
        ContentDecoderFactory.registerDecoder("quoted-printable", next -> new QuotedPrintable.DecoderConsumer(next.convert(Bytes::toByteBuffer), 8192, err -> new IOException("Error decoding quoted-printable MIME content", (Throwable)err)).convert(ByteArray::fromByteBuffer));
        ContentDecoderFactory.registerDecoder("gzip", next -> new GZipConsumer(8192, (AsyncConsumer)new BufferedAsyncConsumer(3, next)));
    }
}

