/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.PartialAsyncConsumer;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.HexaDecimalEncoding;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.mime.header.MimeHeader;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.DebugUtil;

public final class ChunkedTransfer {
    public static final String TRANSFER_NAME = "chunked";
    private static final byte[] FINAL_CHUNK = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private static final byte[] CRLF = new byte[]{13, 10};

    private ChunkedTransfer() {
    }

    public static class Sender
    implements AsyncConsumer<ByteBuffer, IOException> {
        private AsyncConsumer<ByteBuffer, IOException> sender;
        private Supplier<List<MimeHeader>> trailerSupplier;
        private boolean needEndOfPreviousChunk = false;
        private Logger logger;

        public Sender(AsyncConsumer<ByteBuffer, IOException> sender, Supplier<List<MimeHeader>> trailerSupplier) {
            this.sender = sender;
            this.trailerSupplier = trailerSupplier;
            this.logger = LCCore.getApplication().getLoggerFactory().getLogger(ChunkedTransfer.class);
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            int val;
            byte[] chunkHeader = new byte[12];
            chunkHeader[10] = 13;
            chunkHeader[11] = 10;
            int i = 9;
            if (val == 0) {
                chunkHeader[i--] = 48;
            } else {
                for (val = data.remaining(); i >= 0 && val > 0; val >>= 4) {
                    chunkHeader[i--] = (byte)HexaDecimalEncoding.encodeDigit((int)(val & 0xF));
                }
            }
            if (this.needEndOfPreviousChunk) {
                chunkHeader[i--] = 10;
                chunkHeader[i--] = 13;
            }
            if (this.logger.trace()) {
                this.logger.trace("Sending chunk size: " + new String(chunkHeader, i + 1, 12 - (i + 1), StandardCharsets.US_ASCII));
            }
            IAsync sendHeader = this.sender.consume((Object)ByteBuffer.wrap(chunkHeader, i + 1, 12 - (i + 1)));
            this.needEndOfPreviousChunk = true;
            Async result = new Async();
            sendHeader.thenDoOrStart("Send chunk of data", Task.getCurrentPriority(), () -> {
                if (this.logger.trace()) {
                    this.logger.trace("Sending chunk data: " + data.remaining());
                }
                IAsync sendData = this.sender.consume((Object)data);
                sendData.onDone(result);
            }, (IAsync)result);
            return result;
        }

        public IAsync<IOException> end() {
            int start;
            Async result = new Async();
            if (this.logger.trace()) {
                this.logger.trace("Sending final chunk of 0");
            }
            List<MimeHeader> trailers = this.trailerSupplier == null ? null : this.trailerSupplier.get();
            int n = start = this.needEndOfPreviousChunk ? 0 : 2;
            if (trailers == null || trailers.isEmpty()) {
                this.sender.consume((Object)ByteBuffer.wrap(FINAL_CHUNK, start, FINAL_CHUNK.length - start).asReadOnlyBuffer()).thenDoOrStart("Send final chunk", Task.getCurrentPriority(), () -> this.sender.end().onDone(result), (IAsync)result);
                return result;
            }
            this.sender.consume((Object)ByteBuffer.wrap(FINAL_CHUNK, start, FINAL_CHUNK.length - start - 2).asReadOnlyBuffer()).thenDoOrStart("Send end of chunk transfer", Task.getCurrentPriority(), () -> {
                ByteArrayStringIso8859 s = new ByteArrayStringIso8859(512);
                for (MimeHeader h : trailers) {
                    h.appendTo((IString)s);
                }
                if (this.logger.trace()) {
                    this.logger.trace("Sending trailer after last chunk (" + s.length() + ")");
                }
                this.sender.consume((Object)s.asByteBuffer()).onDone(() -> this.sendFinalCRLF((Async<IOException>)result), (IAsync)result);
            }, (IAsync)result);
            return result;
        }

        private void sendFinalCRLF(Async<IOException> result) {
            if (this.logger.trace()) {
                this.logger.trace("Sending final CRLF after last chunk and trailer");
            }
            this.sender.consume((Object)ByteBuffer.wrap(CRLF).asReadOnlyBuffer()).thenDoOrStart("Send final chunk", Task.getCurrentPriority(), () -> this.sender.end().onDone(result), result);
        }

        public void error(IOException error) {
            this.sender.error((Exception)error);
        }
    }

    public static class Receiver
    implements PartialAsyncConsumer<ByteBuffer, IOException> {
        private Logger logger;
        private boolean needSize = true;
        private boolean chunkSizeDone = false;
        private boolean chunkExtension = false;
        private long chunkSize = -1L;
        private long chunkUsed = 0L;
        private int chunkSizeChars = 0;
        private CharArrayString trailerLine = new CharArrayString(64);
        private MimeHeaders headers;
        private AsyncConsumer<ByteBuffer, IOException> consumer;

        public Receiver(MimeHeaders headers, AsyncConsumer<ByteBuffer, IOException> consumer) {
            this.headers = headers;
            this.consumer = consumer;
            this.logger = LCCore.getApplication().getLoggerFactory().getLogger(ChunkedTransfer.class);
        }

        public AsyncSupplier<Boolean, IOException> consume(ByteBuffer buf) {
            AsyncSupplier result = new AsyncSupplier();
            this.consumeChunkTask(buf, (AsyncSupplier<Boolean, IOException>)result).start();
            return result;
        }

        public boolean isExpectingData() {
            return true;
        }

        private Task<Void, NoException> consumeChunkTask(ByteBuffer buf, AsyncSupplier<Boolean, IOException> ondone) {
            return Task.cpu((String)"Read chunk of data", (Task.Priority)Task.getCurrentPriority(), (Executable)new ChunkConsumer(buf, ondone));
        }

        private class ChunkConsumer
        implements Executable<Void, NoException> {
            private ByteBuffer buf;
            private AsyncSupplier<Boolean, IOException> onDone;

            private ChunkConsumer(ByteBuffer buf, AsyncSupplier<Boolean, IOException> ondone) {
                this.buf = buf;
                this.onDone = ondone;
            }

            public Void execute(Task<Void, NoException> t) {
                block4: {
                    do {
                        if (!this.buf.hasRemaining()) {
                            if (Receiver.this.logger.trace()) {
                                Receiver.this.logger.trace("End of chunck data consumed, wait for more data");
                            }
                            this.onDone.unblockSuccess((Object)Boolean.FALSE);
                            return null;
                        }
                        if (!Receiver.this.needSize) break block4;
                    } while (this.needSize());
                    return null;
                }
                if (Receiver.this.chunkSize == 0L) {
                    this.consumeTrailer();
                    return null;
                }
                this.consumeChunk();
                return null;
            }

            private boolean needSize() {
                int isize;
                int i = this.buf.get() & 0xFF;
                if (Receiver.this.chunkSizeChars == 8 && i == 10) {
                    Receiver.this.needSize = false;
                    Receiver.this.chunkSizeDone = false;
                    Receiver.this.chunkExtension = false;
                    return true;
                }
                if (Receiver.this.chunkSize < 0L && (i == 13 || i == 10)) {
                    return true;
                }
                if (i == 59) {
                    if (Receiver.this.chunkSize < 0L) {
                        IOException error = new IOException("No chunk size before extension");
                        Receiver.this.logger.error("Invalid chunked data", (Throwable)error);
                        this.onDone.unblockError((Exception)error);
                        return false;
                    }
                    if (Receiver.this.logger.trace()) {
                        Receiver.this.logger.trace("Start chunk extension");
                    }
                    Receiver.this.chunkSizeDone = true;
                    Receiver.this.chunkExtension = true;
                    return true;
                }
                if (i == 10) {
                    if (Receiver.this.logger.trace()) {
                        Receiver.this.logger.trace("End of chunk line, chunk size is " + Receiver.this.chunkSize);
                    }
                    Receiver.this.needSize = false;
                    Receiver.this.chunkSizeDone = false;
                    Receiver.this.chunkExtension = false;
                    return true;
                }
                if (Receiver.this.chunkExtension) {
                    return true;
                }
                if (Receiver.this.chunkSizeDone) {
                    return true;
                }
                if (i == 13 || i == 32) {
                    if (Receiver.this.logger.trace()) {
                        Receiver.this.logger.trace("end of chunk size: " + Receiver.this.chunkSize + ", wait for end of line");
                    }
                    Receiver.this.chunkSizeDone = true;
                    return true;
                }
                try {
                    isize = HexaDecimalEncoding.decodeChar((char)((char)i));
                }
                catch (EncodingException e) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Invalid chunk size: character '").append((char)i).append("' is not a valid hexadecimal character. It was found at position 0x").append(Integer.toHexString(this.buf.position() - 1));
                    if (this.buf.hasArray()) {
                        msg.append(" in the following buffer:\r\n");
                        DebugUtil.dumpHex((StringBuilder)msg, (byte[])this.buf.array(), (int)this.buf.arrayOffset(), (int)this.buf.limit());
                    }
                    IOException error = new IOException(msg.toString());
                    Receiver.this.logger.error("Invalid chunked data", (Throwable)error);
                    this.onDone.unblockError((Exception)error);
                    return false;
                }
                if (Receiver.this.chunkSize < 0L) {
                    Receiver.this.chunkSize = isize;
                } else {
                    Receiver.this.chunkSize = (Receiver.this.chunkSize << 4) + (long)isize;
                }
                Receiver.this.chunkSizeChars++;
                return true;
            }

            private void consumeChunk() {
                int l = this.buf.remaining();
                if ((long)l > Receiver.this.chunkSize - Receiver.this.chunkUsed) {
                    int nb = (int)(Receiver.this.chunkSize - Receiver.this.chunkUsed);
                    ByteBuffer subBuffer = this.buf.duplicate();
                    subBuffer.limit(this.buf.position() + nb);
                    this.buf.position(this.buf.position() + nb);
                    Receiver.this.chunkUsed = Receiver.this.chunkUsed + (long)nb;
                    if (Receiver.this.chunkUsed == Receiver.this.chunkSize) {
                        Receiver.this.needSize = true;
                        Receiver.this.chunkSize = -1L;
                        Receiver.this.chunkSizeChars = 0;
                        Receiver.this.chunkUsed = 0L;
                    }
                    if (Receiver.this.logger.trace()) {
                        Receiver.this.logger.trace("Consume end of chunk: " + nb + " bytes, data still available after");
                    }
                    IAsync decode = Receiver.this.consumer.consume((Object)subBuffer.asReadOnlyBuffer());
                    decode.onDone(() -> {
                        if (decode.isSuccessful()) {
                            if (Receiver.this.logger.trace()) {
                                Receiver.this.logger.trace("Chunk consumed successfully, start a new consumer for the " + this.buf.remaining() + " remaining bytes");
                            }
                            Receiver.this.consumeChunkTask(this.buf, (AsyncSupplier<Boolean, IOException>)this.onDone).start();
                        } else if (decode.hasError()) {
                            this.onDone.unblockError((Exception)IO.error((Throwable)decode.getError()));
                        } else {
                            this.onDone.unblockCancel(decode.getCancelEvent());
                        }
                    });
                } else {
                    Receiver.this.chunkUsed = Receiver.this.chunkUsed + (long)l;
                    if (Receiver.this.chunkUsed == Receiver.this.chunkSize) {
                        if (Receiver.this.logger.trace()) {
                            Receiver.this.logger.trace("Consume end of chunk: " + l + " bytes, no more data available");
                        }
                        Receiver.this.needSize = true;
                        Receiver.this.chunkSize = -1L;
                        Receiver.this.chunkSizeChars = 0;
                        Receiver.this.chunkUsed = 0L;
                    } else if (Receiver.this.logger.trace()) {
                        Receiver.this.logger.trace("Consume part of chunk: " + l + " bytes, " + Receiver.this.chunkUsed + "/" + Receiver.this.chunkSize + " consumed so far, no more data available");
                    }
                    IAsync decode = Receiver.this.consumer.consume((Object)this.buf.duplicate().asReadOnlyBuffer());
                    this.buf.position(this.buf.limit());
                    decode.onDone(() -> this.onDone.unblockSuccess((Object)Boolean.FALSE), this.onDone, IO::error);
                }
            }

            private void consumeTrailer() {
                do {
                    char c;
                    if ((c = (char)(this.buf.get() & 0xFF)) == '\n') {
                        String value;
                        String name;
                        Receiver.this.trailerLine.trim();
                        if (Receiver.this.trailerLine.length() == 0) {
                            if (Receiver.this.logger.trace()) {
                                Receiver.this.logger.trace("End of trailers");
                            }
                            Receiver.this.consumer.end().onDone(() -> this.onDone.unblockSuccess((Object)Boolean.TRUE), this.onDone);
                            return;
                        }
                        int i = Receiver.this.trailerLine.indexOf(':');
                        if (i < 0) {
                            name = Receiver.this.trailerLine.toString();
                            value = "";
                        } else {
                            name = Receiver.this.trailerLine.substring(0, i).trim().toString();
                            value = Receiver.this.trailerLine.substring(i + 1).trim().toString();
                        }
                        Receiver.this.headers.addRawValue(name, value);
                        if (Receiver.this.logger.trace()) {
                            Receiver.this.logger.trace("Trailer header received: " + name + ": " + value);
                        }
                        Receiver.this.trailerLine = new CharArrayString(64);
                        continue;
                    }
                    Receiver.this.trailerLine.append(c);
                } while (this.buf.hasRemaining());
                this.onDone.unblockSuccess((Object)Boolean.FALSE);
            }
        }
    }
}

