/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.header.parser.Comment;
import net.lecousin.framework.network.mime.header.parser.Space;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.IString;

public interface Token {
    public int textLength();

    public static int textLength(List<Token> tokens) {
        int total = 0;
        for (Token token : tokens) {
            total += token.textLength();
        }
        return total;
    }

    public void asText(IString var1);

    public static void asText(List<Token> tokens, IString s) {
        for (Token token : tokens) {
            token.asText(s);
        }
    }

    default public String asString() {
        CharArrayString s = new CharArrayString(this.textLength());
        this.asText((IString)s);
        return s.toString();
    }

    public static String toString(List<Token> tokens) {
        CharArrayString s = new CharArrayString(Token.textLength(tokens));
        Token.asText(tokens, (IString)s);
        return s.asString();
    }

    public static void trim(List<Token> tokens) {
        while (!tokens.isEmpty() && tokens.get(0) instanceof Space) {
            tokens.remove(0);
        }
        while (!tokens.isEmpty() && tokens.get(tokens.size() - 1) instanceof Space) {
            tokens.remove(tokens.size() - 1);
        }
    }

    public static void removeComments(List<Token> tokens) {
        Iterator<Token> it = tokens.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof Comment)) continue;
            it.remove();
        }
    }

    public static List<List<Token>> splitBySpecialCharacter(List<Token> tokens, char sc) {
        LinkedList<List<Token>> list = new LinkedList<List<Token>>();
        LinkedList<Token> current = new LinkedList<Token>();
        for (Token token : tokens) {
            if (token instanceof SpecialCharacter && ((SpecialCharacter)token).getChar() == sc) {
                if (!current.isEmpty()) {
                    list.add(current);
                }
                current = new LinkedList();
                continue;
            }
            current.add(token);
        }
        if (!current.isEmpty()) {
            list.add(current);
        }
        return list;
    }
}

