/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header.parser;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.header.parser.Address;
import net.lecousin.framework.network.mime.header.parser.Comment;
import net.lecousin.framework.network.mime.header.parser.DomainLiteral;
import net.lecousin.framework.network.mime.header.parser.Space;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.network.mime.header.parser.Token;
import net.lecousin.framework.network.mime.header.parser.Word;
import net.lecousin.framework.util.Pair;

public final class MimeHeaderValueParser {
    private MimeHeaderValueParser() {
    }

    public static List<Token> parse(String value) {
        Pair<List<Token>, Integer> p = MimeHeaderValueParser.parse(value, 0, '\u0000');
        return (List)p.getValue1();
    }

    private static Pair<List<Token>, Integer> parse(String value, int i, char end) {
        int l = value.length();
        LinkedList<Token> tokens = new LinkedList<Token>();
        boolean escape = false;
        StringBuilder currentWord = null;
        while (i < l) {
            char c = value.charAt(i);
            if (c == end) {
                MimeHeaderValueParser.appendWord(tokens, currentWord);
                return new Pair(tokens, (Object)i);
            }
            if (escape) {
                if (currentWord == null) {
                    currentWord = new StringBuilder();
                }
                currentWord.append(c);
                escape = false;
            } else {
                switch (c) {
                    case '\"': {
                        if (currentWord == null) {
                            currentWord = new StringBuilder();
                        }
                        i = MimeHeaderValueParser.eatString(currentWord, value, i, l);
                        break;
                    }
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        currentWord = MimeHeaderValueParser.appendWord(tokens, currentWord);
                        if (!tokens.isEmpty() && tokens.getLast() instanceof Space) break;
                        tokens.add(new Space());
                        break;
                    }
                    case '(': {
                        currentWord = MimeHeaderValueParser.appendWord(tokens, currentWord);
                        Pair<List<Token>, Integer> p = MimeHeaderValueParser.parse(value, i + 1, ')');
                        tokens.add(new Comment((List)p.getValue1()));
                        i = (Integer)p.getValue2();
                        break;
                    }
                    case '[': {
                        currentWord = MimeHeaderValueParser.appendWord(tokens, currentWord);
                        Pair<List<Token>, Integer> p = MimeHeaderValueParser.parse(value, i + 1, ']');
                        tokens.add(new DomainLiteral((List)p.getValue1()));
                        i = (Integer)p.getValue2();
                        break;
                    }
                    case '<': {
                        currentWord = MimeHeaderValueParser.appendWord(tokens, currentWord);
                        Pair<List<Token>, Integer> p = MimeHeaderValueParser.parse(value, i + 1, '>');
                        tokens.add(new Address((List)p.getValue1()));
                        i = (Integer)p.getValue2();
                        break;
                    }
                    case ',': 
                    case '.': 
                    case ':': 
                    case ';': 
                    case '@': {
                        currentWord = MimeHeaderValueParser.appendWord(tokens, currentWord);
                        tokens.add(new SpecialCharacter(c));
                        break;
                    }
                    default: {
                        if (currentWord == null) {
                            currentWord = new StringBuilder();
                        }
                        currentWord.append(c);
                    }
                }
            }
            ++i;
        }
        if (currentWord != null) {
            tokens.add(new Word(currentWord.toString()));
        }
        return new Pair(tokens, (Object)i);
    }

    private static StringBuilder appendWord(LinkedList<Token> tokens, StringBuilder currentWord) {
        if (currentWord != null) {
            tokens.add(new Word(currentWord.toString()));
        }
        return null;
    }

    private static int eatString(StringBuilder currentWord, String value, int i, int l) {
        boolean escape = false;
        for (int j = i + 1; j < l; ++j) {
            char c = value.charAt(j);
            if (escape) {
                currentWord.append(c);
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                return j;
            }
            currentWord.append(c);
        }
        return l;
    }
}

