/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.MimeUtil;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.network.mime.header.parser.Token;
import net.lecousin.framework.network.mime.header.parser.Word;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.Pair;

public class ParameterizedHeaderValue
implements HeaderValueFormat {
    private String mainValue;
    private List<Pair<String, String>> parameters = new LinkedList<Pair<String, String>>();

    public ParameterizedHeaderValue() {
    }

    public ParameterizedHeaderValue(String mainValue, String ... parameters) {
        this.mainValue = mainValue;
        for (int i = 0; i < parameters.length - 1; i += 2) {
            this.parameters.add((Pair<String, String>)new Pair((Object)parameters[i], (Object)parameters[i + 1]));
        }
    }

    public String getMainValue() {
        return this.mainValue;
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public String getParameter(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!name.equals(p.getValue1())) continue;
            return (String)p.getValue2();
        }
        return null;
    }

    public String getParameterIgnoreCase(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!name.equalsIgnoreCase((String)p.getValue1())) continue;
            return (String)p.getValue2();
        }
        return null;
    }

    public void setMainValue(String value) {
        this.mainValue = value;
    }

    public void addParameter(String name, String value) {
        this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public void setParameter(String name, String value) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equals(name)) continue;
            p.setValue2((Object)value);
            return;
        }
        this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public void setParameterIgnoreCase(String name, String value) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equalsIgnoreCase(name)) continue;
            p.setValue2((Object)value);
            return;
        }
        this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    @Override
    public void parseTokens(List<Token> tokens) throws MimeException {
        this.mainValue = null;
        this.parameters.clear();
        List<List<Token>> params = Token.splitBySpecialCharacter(tokens, ';');
        for (List<Token> param : params) {
            Token.trim(param);
            Token.removeComments(param);
            CharArrayString s = new CharArrayString(Token.textLength(param));
            Token.asText(param, (IString)s);
            int i = s.indexOf('=');
            try {
                if (i >= 0) {
                    String name = s.substring(0, i).trim().asString();
                    String value = MimeUtil.decodeRFC2047(s.substring(i + 1).asString());
                    this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
                    continue;
                }
                if (this.mainValue == null) {
                    this.mainValue = MimeUtil.decodeRFC2047(s.asString());
                    continue;
                }
                this.parameters.add((Pair<String, String>)new Pair((Object)s.asString(), (Object)""));
            }
            catch (Exception e) {
                throw new MimeException("Error decoding RFC2047 value", e);
            }
        }
    }

    @Override
    public List<Token> generateTokens() {
        LinkedList<Token> list = new LinkedList<Token>();
        if (this.mainValue != null) {
            list.add(new Word(MimeUtil.encodeHeaderValueWithUTF8(this.mainValue)));
        }
        for (Pair<String, String> param : this.parameters) {
            if (!list.isEmpty()) {
                list.add(new SpecialCharacter(';'));
            }
            list.add(new Word((String)param.getValue1()));
            list.add(new Word("="));
            list.add(new Word(MimeUtil.encodeHeaderValueWithUTF8((String)param.getValue2())));
        }
        return list;
    }
}

