/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.util.PartialAsyncConsumer;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.MimeHeader;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.ByteArrayStringIso8859Buffer;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.Runnables;

public class MimeHeaders {
    private LinkedArrayList<MimeHeader> headers = new LinkedArrayList(10);
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ERROR_TOO_LONG = "Maximum header length reached";

    public MimeHeaders() {
    }

    public MimeHeaders(List<MimeHeader> headers) {
        this.headers.addAll(headers);
    }

    public MimeHeaders(MimeHeader ... headers) {
        for (MimeHeader h : headers) {
            this.headers.add((Object)h);
        }
    }

    public List<MimeHeader> getHeaders() {
        return this.headers;
    }

    public List<MimeHeader> getList(String name) {
        name = name.toLowerCase();
        ArrayList<MimeHeader> list = new ArrayList<MimeHeader>();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            list.add(h);
        }
        return list;
    }

    public <T extends HeaderValueFormat> List<T> getValues(String name, Class<T> format) throws MimeException {
        LinkedList<T> list = new LinkedList<T>();
        name = name.toLowerCase();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            list.add(h.getValue(format));
        }
        return list;
    }

    public MimeHeader getFirst(String name) {
        name = name.toLowerCase();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            return h;
        }
        return null;
    }

    public <T extends HeaderValueFormat> T getFirstValue(String name, Class<T> format) throws MimeException {
        MimeHeader h = this.getFirst(name);
        if (h == null) {
            return null;
        }
        return h.getValue(format);
    }

    public String getFirstRawValue(String name) {
        MimeHeader h = this.getFirst(name);
        if (h == null) {
            return null;
        }
        return h.getRawValue();
    }

    public Long getFirstLongValue(String name) {
        MimeHeader h = this.getFirst(name);
        if (h == null) {
            return null;
        }
        try {
            return Long.valueOf(h.getRawValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean has(String name) {
        return this.getFirst(name) != null;
    }

    public MimeHeaders addRawValue(String name, String rawValue) {
        this.headers.add((Object)new MimeHeader(name, rawValue));
        return this;
    }

    public MimeHeaders add(String name, HeaderValueFormat value) {
        this.headers.add((Object)new MimeHeader(name, value));
        return this;
    }

    public MimeHeaders add(MimeHeader header) {
        this.headers.add((Object)header);
        return this;
    }

    public MimeHeaders setRawValue(String name, String rawValue) {
        this.remove(name);
        this.addRawValue(name, rawValue);
        return this;
    }

    public MimeHeaders set(String name, HeaderValueFormat value) {
        this.remove(name);
        this.add(name, value);
        return this;
    }

    public MimeHeaders set(MimeHeader header) {
        this.remove(header.getName());
        this.add(header);
        return this;
    }

    public MimeHeaders remove(String name) {
        name = name.toLowerCase();
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            if (!((MimeHeader)it.next()).getNameLowerCase().equals(name)) continue;
            it.remove();
        }
        return this;
    }

    public void appendTo(IString s) {
        for (MimeHeader h : this.headers) {
            h.appendTo(s);
        }
    }

    public Long getContentLength() {
        return this.getFirstLongValue(CONTENT_LENGTH);
    }

    public MimeHeaders setContentLength(long size) {
        this.setRawValue(CONTENT_LENGTH, Long.toString(size));
        return this;
    }

    public ParameterizedHeaderValue getContentType() throws MimeException {
        return this.getFirstValue(CONTENT_TYPE, ParameterizedHeaderValue.class);
    }

    public String getContentTypeValue() {
        try {
            ParameterizedHeaderValue h = this.getContentType();
            if (h == null) {
                return null;
            }
            return h.getMainValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteArrayStringIso8859Buffer generateString(int bufferSize) {
        ByteArrayStringIso8859Buffer s = new ByteArrayStringIso8859Buffer(new ByteArrayStringIso8859(bufferSize));
        s.setNewArrayStringCapacity(bufferSize);
        this.generateString(s);
        return s;
    }

    public void generateString(ByteArrayStringIso8859Buffer s) {
        this.appendTo((IString)s);
        s.append((CharSequence)"\r\n");
    }

    public HeadersConsumer createConsumer() {
        return new HeadersConsumer();
    }

    public HeadersConsumer createConsumer(int maximumLength) {
        return new HeadersConsumer(maximumLength);
    }

    public class HeadersConsumer
    implements PartialAsyncConsumer<Bytes.Readable, MimeException> {
        private int length = 0;
        private CharArrayString name;
        private CharArrayString value;
        private boolean end = false;
        private Runnables.ConsumerThrows<Bytes.Readable, MimeException> consumer;
        private Runnables.ConsumerThrows<Bytes.Readable, MimeException> newLineConsumer;
        private Runnables.ConsumerThrows<Bytes.Readable, MimeException> nameConsumer;
        private Runnables.ConsumerThrows<Bytes.Readable, MimeException> valueConsumer;

        public HeadersConsumer() {
            this(-1);
        }

        public HeadersConsumer(int maximumLength) {
            Logger logger = LCCore.getApplication().getLoggerFactory().getLogger(this.getClass());
            this.newLineConsumer = data -> {
                block6: while (data.hasRemaining()) {
                    if (maximumLength != -1 && ++this.length > maximumLength) {
                        throw new MimeException(MimeHeaders.ERROR_TOO_LONG);
                    }
                    byte b = data.get();
                    switch (b) {
                        case 13: {
                            continue block6;
                        }
                        case 10: {
                            if (this.name != null) {
                                MimeHeader h = new MimeHeader(this.name.asString(), this.value.trim().asString());
                                MimeHeaders.this.headers.add((Object)h);
                                if (logger.debug()) {
                                    logger.debug("Header line found: " + h.getName() + ": " + h.getRawValue());
                                }
                            }
                            if (logger.debug()) {
                                logger.debug("End of headers");
                            }
                            this.end = true;
                            return;
                        }
                        case 58: {
                            throw new MimeException("Empty header name");
                        }
                        case 9: 
                        case 32: {
                            if (this.value == null) {
                                throw new MimeException("First header line cannot start with a space");
                            }
                            this.consumer = this.valueConsumer;
                            this.consumer.accept(data);
                            return;
                        }
                    }
                    if (this.name != null) {
                        MimeHeader h = new MimeHeader(this.name.asString(), this.value.trim().asString());
                        MimeHeaders.this.headers.add((Object)h);
                        if (logger.debug()) {
                            logger.debug("Header line found: " + h.getName() + ": " + h.getRawValue());
                        }
                    }
                    this.name = new CharArrayString(32);
                    this.name.append((char)(b & 0xFF));
                    this.consumer = this.nameConsumer;
                    this.consumer.accept(data);
                    return;
                }
            };
            this.nameConsumer = data -> {
                block5: while (data.hasRemaining()) {
                    if (maximumLength != -1 && ++this.length > maximumLength) {
                        throw new MimeException(MimeHeaders.ERROR_TOO_LONG);
                    }
                    byte b = data.get();
                    switch (b) {
                        case 58: {
                            this.value = new CharArrayString(64);
                            this.consumer = this.valueConsumer;
                            this.consumer.accept(data);
                            return;
                        }
                        case 13: {
                            continue block5;
                        }
                        case 10: {
                            throw new MimeException("Header line must contain a ':' <" + this.name.asString() + ">");
                        }
                    }
                    this.name.append((char)(b & 0xFF));
                }
            };
            this.valueConsumer = data -> {
                block4: while (data.hasRemaining()) {
                    if (maximumLength != -1 && ++this.length > maximumLength) {
                        throw new MimeException(MimeHeaders.ERROR_TOO_LONG);
                    }
                    byte b = data.get();
                    switch (b) {
                        case 13: {
                            continue block4;
                        }
                        case 10: {
                            this.consumer = this.newLineConsumer;
                            this.consumer.accept(data);
                            return;
                        }
                    }
                    this.value.append((char)(b & 0xFF));
                }
            };
            this.consumer = this.newLineConsumer;
        }

        public AsyncSupplier<Boolean, MimeException> consume(Bytes.Readable data) {
            try {
                this.consumer.accept((Object)data);
                return new AsyncSupplier((Object)this.end, null);
            }
            catch (MimeException e) {
                return new AsyncSupplier(null, (Exception)e);
            }
        }

        public boolean isExpectingData() {
            return !this.end;
        }
    }
}

