/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;

public class MimeHeader {
    private String name;
    private String nameLowerCase;
    private String rawValue;
    private Map<Class<? extends HeaderValueFormat>, HeaderValueFormat> parsed = null;

    public MimeHeader(String name, String rawValue) {
        this.name = name;
        this.nameLowerCase = name.toLowerCase();
        this.rawValue = rawValue;
    }

    public MimeHeader(String name, HeaderValueFormat value) {
        this.name = name;
        this.nameLowerCase = name.toLowerCase();
        this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        this.parsed.put(value.getClass(), value);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLowerCase() {
        return this.nameLowerCase;
    }

    public String getRawValue() {
        if (this.rawValue == null && this.parsed != null) {
            CharArrayStringBuffer s = new CharArrayStringBuffer();
            this.parsed.values().iterator().next().generate((IString)s, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.rawValue = s.toString();
        }
        return this.rawValue;
    }

    public <T extends HeaderValueFormat> T getValue(Class<T> format) throws MimeException {
        HeaderValueFormat t;
        if (this.parsed != null) {
            t = this.parsed.get(format);
            if (t != null) {
                return (T)t;
            }
        } else {
            if (this.rawValue == null) {
                return null;
            }
            this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        }
        try {
            t = (HeaderValueFormat)format.newInstance();
        }
        catch (Exception e) {
            LCCore.getApplication().getLoggerFactory().getLogger(MimeHeader.class).error("Unable to instantiate header format class", (Throwable)e);
            return null;
        }
        t.parseRawValue(this.rawValue);
        this.parsed.put(format, t);
        return (T)t;
    }

    public void setRawValue(String raw) {
        this.parsed = null;
        this.rawValue = raw;
    }

    public <T extends HeaderValueFormat> void setValue(T value) {
        this.rawValue = null;
        this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        this.parsed.put(value.getClass(), value);
    }

    public void appendTo(IString s) {
        s.append((CharSequence)this.name).append((CharSequence)": ");
        if (this.rawValue == null && this.parsed != null) {
            this.parsed.values().iterator().next().generate(s, 80 - this.name.length() - 2, 79);
        } else {
            s.append((CharSequence)this.rawValue);
        }
        s.append((CharSequence)"\r\n");
    }
}

