/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.parser.Address;
import net.lecousin.framework.network.mime.header.parser.Space;
import net.lecousin.framework.network.mime.header.parser.Token;
import net.lecousin.framework.network.mime.header.parser.Word;

public class InternetAddressHeaderValue
implements HeaderValueFormat {
    protected String displayName;
    protected String address;

    public InternetAddressHeaderValue() {
    }

    public InternetAddressHeaderValue(String displayName, String address) {
        this.displayName = displayName;
        this.address = address;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public void parseTokens(List<Token> tokens) {
        int i;
        Token.removeComments(tokens);
        for (i = 0; i < tokens.size() && !(tokens.get(i) instanceof Address); ++i) {
        }
        if (i == tokens.size()) {
            this.displayName = null;
            this.address = Token.toString(tokens);
            return;
        }
        List<Token> addrTokens = ((Address)tokens.get(i)).getContent();
        Token.trim(addrTokens);
        this.address = Token.toString(addrTokens);
        while (tokens.size() > i) {
            tokens.remove(i);
        }
        Token.trim(tokens);
        this.displayName = !tokens.isEmpty() ? Token.toString(tokens) : null;
    }

    @Override
    public List<Token> generateTokens() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        if (this.displayName != null) {
            tokens.add(new Word(this.displayName));
            tokens.add(new Space());
        }
        tokens.add(new Address(Collections.singletonList(new Word(this.address))));
        return tokens;
    }
}

