/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.network.mime.header.parser.Token;

public abstract class HeaderValues<V extends HeaderValueFormat>
implements HeaderValueFormat {
    private List<V> values = new LinkedList<V>();

    public List<V> getValues() {
        return this.values;
    }

    protected abstract V newValue();

    @Override
    public void parseTokens(List<Token> tokens) throws MimeException {
        this.values.clear();
        List<List<Token>> list = Token.splitBySpecialCharacter(tokens, ',');
        for (List<Token> subList : list) {
            V value = this.newValue();
            value.parseTokens(subList);
            this.values.add(value);
        }
    }

    @Override
    public List<Token> generateTokens() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        for (HeaderValueFormat value : this.values) {
            if (!tokens.isEmpty()) {
                tokens.add(new SpecialCharacter(','));
            }
            tokens.addAll(value.generateTokens());
        }
        return tokens;
    }
}

