/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.List;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.header.parser.MimeHeaderValueParser;
import net.lecousin.framework.network.mime.header.parser.Token;
import net.lecousin.framework.text.IString;

public interface HeaderValueFormat {
    default public void parseRawValue(String raw) throws MimeException {
        this.parseTokens(MimeHeaderValueParser.parse(raw));
    }

    public void parseTokens(List<Token> var1) throws MimeException;

    public List<Token> generateTokens();

    default public void generate(IString s, int firstLineMaxLength, int maxSubLineLength) {
        List<Token> tokens = this.generateTokens();
        int lineLength = 0;
        boolean firstLine = true;
        for (Token token : tokens) {
            int tokenLength = token.textLength();
            if (firstLine && lineLength + tokenLength > firstLineMaxLength) {
                firstLine = false;
                s.append((CharSequence)"\r\n\t");
                lineLength = tokenLength;
                token.asText(s);
                continue;
            }
            if (!firstLine && lineLength + tokenLength > maxSubLineLength) {
                s.append((CharSequence)"\r\n\t");
                lineLength = tokenLength;
                token.asText(s);
                continue;
            }
            lineLength += tokenLength;
            token.asText(s);
        }
    }
}

