/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class TextEntity
extends MimeEntity {
    public static final String CHARSET_PARAMETER = "charset";
    private String text;
    private Charset charset;

    public TextEntity(String text, Charset charset, String textMimeType) {
        super(null);
        this.text = text;
        this.charset = charset;
        this.setHeader("Content-Type", textMimeType + ";" + CHARSET_PARAMETER + "=" + charset.name());
    }

    public TextEntity(MimeEntity parent, MimeHeaders from) throws MimeException {
        super(parent, from);
        this.text = "";
        ParameterizedHeaderValue type = this.headers.getContentType();
        this.charset = type == null || type.getParameter(CHARSET_PARAMETER) == null ? StandardCharsets.UTF_8 : Charset.forName(type.getParameter(CHARSET_PARAMETER));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) throws MimeException {
        ParameterizedHeaderValue type = this.headers.getContentType();
        if (type == null) {
            type = new ParameterizedHeaderValue("text/plain", CHARSET_PARAMETER, charset.name());
            this.headers.add("Content-Type", type);
        } else {
            if (charset.equals(this.charset)) {
                return;
            }
            type.setParameterIgnoreCase(CHARSET_PARAMETER, charset.name());
            this.headers.set("Content-Type", type);
        }
        this.charset = charset;
    }

    @Override
    public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
        byte[] body = this.text.getBytes(this.charset);
        return new AsyncSupplier((Object)new Pair((Object)body.length, (Object)new AsyncProducer.SingleData((Object)ByteBuffer.wrap(body))), null);
    }

    @Override
    public boolean canProduceBodyRange() {
        return true;
    }

    @Override
    public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
        byte[] subBody;
        byte[] body = this.text.getBytes(this.charset);
        RangeLong r = new RangeLong(range.min, range.max);
        if (r.min == -1L) {
            r.min = (long)body.length - r.max;
            r.max = (long)body.length - 1L;
        } else if (r.max == -1L || r.max > (long)(body.length - 1)) {
            r.max = (long)body.length - 1L;
        }
        if (r.min == 0L && r.max == (long)(body.length - 1)) {
            subBody = body;
        } else {
            subBody = new byte[(int)(r.max - r.min + 1L)];
            System.arraycopy(body, (int)r.min, subBody, 0, subBody.length);
        }
        BinaryEntity subEntity = new BinaryEntity(null, new MimeHeaders(this.getHeaders().getHeaders()));
        subEntity.setContent((IO.Readable)new ByteArrayIO(subBody, "range of text entity"));
        return new Triple((Object)r, (Object)body.length, (Object)subEntity);
    }

    @Override
    public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
        return new Consumer(size == null ? 1024 : (size < 65536L ? size.intValue() : 65536));
    }

    public class Consumer
    implements AsyncConsumer<ByteBuffer, IOException> {
        private CharacterDecoder decoder;
        private CharArrayStringBuffer string = new CharArrayStringBuffer();
        private IOException error;

        public Consumer(int bufferSize) {
            try {
                this.decoder = CharacterDecoder.get((Charset)TextEntity.this.charset, (int)bufferSize);
            }
            catch (Exception e) {
                this.error = IO.error((Throwable)e);
            }
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            if (this.error != null) {
                return new Async((Exception)this.error);
            }
            Chars.Readable chars = this.decoder.decode((Bytes.Readable)ByteArray.fromByteBuffer((ByteBuffer)data));
            chars.get((IString)this.string, chars.remaining());
            return new Async(true);
        }

        public IAsync<IOException> end() {
            if (this.error != null) {
                return new Async((Exception)this.error);
            }
            Chars.Readable chars = this.decoder.flush();
            if (chars != null) {
                chars.get((IString)this.string, chars.remaining());
            }
            TextEntity.this.text = this.string.toString();
            return new Async(true);
        }

        public void error(IOException error) {
        }
    }
}

