/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.DefaultMimeEntityFactory;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.entity.MimeEntityFactory;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class MultipartEntity
extends MimeEntity {
    public static final String MAIN_CONTENT_TYPE = "multipart";
    private static int counter = 0;
    private static final Random random = new Random();
    protected byte[] boundary;
    protected LinkedList<MimeEntity> parts = new LinkedList();
    protected MimeEntityFactory partFactory = null;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] SEP = new byte[]{45, 45};

    public MultipartEntity(byte[] boundary, String subType) {
        super(null);
        this.boundary = boundary;
        this.setHeader("Content-Type", new ParameterizedHeaderValue("multipart/" + subType, "boundary", new String(boundary, StandardCharsets.US_ASCII)));
    }

    public MultipartEntity(String subType) {
        this(MultipartEntity.generateBoundary(), subType);
    }

    public MultipartEntity(MimeEntity parent, MimeHeaders headers) throws MimeException {
        super(parent, headers);
        ParameterizedHeaderValue ct = headers.getContentType();
        if (ct == null) {
            throw new MimeException("Missing Content-Type header");
        }
        String s = ct.getParameterIgnoreCase("boundary");
        if (s == null) {
            throw new MimeException("No boundary specified in Content-Type header");
        }
        this.boundary = s.getBytes(StandardCharsets.US_ASCII);
        this.partFactory = parent instanceof MultipartEntity ? ((MultipartEntity)parent).partFactory : DefaultMimeEntityFactory.getInstance();
    }

    public MimeEntityFactory getPartFactory() {
        return this.partFactory;
    }

    public void setPartFactory(MimeEntityFactory partFactory) {
        this.partFactory = partFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] generateBoundary() {
        long rand;
        int count;
        Random random = MultipartEntity.random;
        synchronized (random) {
            count = counter++;
            rand = MultipartEntity.random.nextLong();
        }
        long timestamp = System.currentTimeMillis();
        byte[] boundary = new byte[]{108, 99, 109, 112, 61, 95, MultipartEntity.encodeBoundary((int)(timestamp & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 25 & 0x1FL)), 47, MultipartEntity.encodeBoundary(count & 0x1F), MultipartEntity.encodeBoundary(count >> 5 & 0x1F), MultipartEntity.encodeBoundary(count >> 10 & 0x1F), MultipartEntity.encodeBoundary(count >> 15 & 0x1F), 47, MultipartEntity.encodeBoundary((int)(rand & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 25 & 0x1FL)), 46};
        return boundary;
    }

    private static byte encodeBoundary(int value) {
        if (value < 26) {
            return (byte)(97 + value);
        }
        return (byte)(48 + (value - 26));
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    public void add(MimeEntity part) {
        this.parts.add(part);
        part.parent = this;
    }

    public List<MimeEntity> getParts() {
        return this.parts;
    }

    public <T extends MimeEntity> List<T> getPartsOfType(Class<T> type) {
        LinkedList<MimeEntity> list = new LinkedList<MimeEntity>();
        for (MimeEntity p : this.parts) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            list.add(p);
        }
        return list;
    }

    @Override
    public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
        return new AsyncSupplier((Object)new Pair(null, (Object)new BodyProducer()), null);
    }

    @Override
    public boolean canProduceBodyRange() {
        return false;
    }

    @Override
    public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
        return null;
    }

    @Override
    public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
        return new Parser(this.partFactory);
    }

    public class Parser
    implements AsyncConsumer<ByteBuffer, IOException> {
        private MimeEntityFactory entityFactory;
        private boolean firstBoundary = true;
        private int boundaryPos = 2;
        private boolean isFinalBoundary = false;
        private MimeEntity.Parser entityParser;
        private boolean eof = false;

        public Parser(MimeEntityFactory entityFactory) {
            if (entityFactory == null) {
                throw new IllegalArgumentException("entityFactory must not be null");
            }
            this.entityFactory = entityFactory;
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            if (this.eof) {
                ByteArrayCache.getInstance().free(data);
                return new Async(true);
            }
            Async result = new Async();
            this.consumeData(data, (Async<IOException>)result);
            return result;
        }

        public IAsync<IOException> end() {
            if (!this.eof) {
                EOFException error = new EOFException("Unexpected end in multi-part before final boundary");
                if (this.entityParser != null) {
                    this.entityParser.error(error);
                }
                return new Async((Exception)error);
            }
            return new Async(true);
        }

        public void error(IOException error) {
            if (this.entityParser != null) {
                this.entityParser.error(error);
            }
        }

        private void consumeData(ByteBuffer data, Async<IOException> onDone) {
            if (this.firstBoundary) {
                if (!this.consumeFirstBoundary(data, onDone)) {
                    return;
                }
            } else if (this.eof) {
                data.position(data.position() + data.remaining());
                onDone.unblock();
                return;
            }
            do {
                IAsync push;
                Boolean found;
                int boundPos = this.boundaryPos;
                boolean wasFinal = this.isFinalBoundary;
                int start = data.position();
                while ((found = this.searchBoundary(data)) == null && boundPos == 0 && data.hasRemaining()) {
                }
                if (found != null) {
                    this.boundaryFound(data, onDone, start, found);
                    return;
                }
                LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
                if (boundPos > 0 && this.boundaryPos <= boundPos) {
                    this.addMissedBuffers(boundPos, wasFinal, buffers);
                }
                int end = data.position() - this.boundaryPos;
                if (!data.hasRemaining()) {
                    if (end - start > 0) {
                        ByteBuffer subBuffer = data.duplicate();
                        subBuffer.position(start);
                        subBuffer.limit(end);
                        buffers.add(subBuffer.asReadOnlyBuffer());
                    }
                    push = this.entityParser.push(buffers);
                    push.onDone(onDone);
                    return;
                }
                if (end - start > 0) {
                    if (data.hasArray()) {
                        buffers.add(ByteBuffer.wrap(data.array(), data.arrayOffset() + start, end - start).asReadOnlyBuffer());
                    } else {
                        byte[] b = new byte[end - start];
                        data.position(start);
                        data.get(b);
                        data.position(end + this.boundaryPos);
                        buffers.add(ByteBuffer.wrap(b));
                    }
                }
                if ((push = this.entityParser.push(buffers)).isSuccessful()) continue;
                push.onDone(() -> this.consumeData(data, onDone), onDone);
                return;
            } while (data.hasRemaining());
            onDone.unblock();
        }

        private boolean consumeFirstBoundary(ByteBuffer data, Async<IOException> onDone) {
            Boolean found;
            while ((found = this.searchBoundary(data)) == null) {
                if (data.hasRemaining()) continue;
                onDone.unblock();
                return false;
            }
            if (found.booleanValue()) {
                this.firstBoundary = false;
                this.eof = true;
                data.position(data.position() + data.remaining());
                onDone.unblock();
                return false;
            }
            this.firstBoundary = false;
            this.entityParser = new MimeEntity.Parser(this.entityFactory);
            return true;
        }

        private void boundaryFound(ByteBuffer data, Async<IOException> onDone, int start, boolean isLast) {
            int end = data.position() - (4 + MultipartEntity.this.boundary.length + 2);
            if (isLast) {
                end -= 2;
            }
            if (end - start > 0) {
                ByteBuffer subBuffer;
                if (!data.hasRemaining()) {
                    ByteBuffer copy = data.duplicate();
                    copy.position(start);
                    copy.limit(end);
                    this.entityParser.consume(copy.asReadOnlyBuffer()).onDone(() -> this.endOfBody(isLast, data, onDone), onDone);
                    return;
                }
                if (data.hasArray()) {
                    subBuffer = ByteBuffer.wrap(data.array(), data.arrayOffset() + start, end - start).asReadOnlyBuffer();
                } else {
                    byte[] b = new byte[end - start];
                    int p = data.position();
                    data.position(start);
                    data.get(b);
                    subBuffer = ByteBuffer.wrap(b);
                    data.position(p);
                }
                this.entityParser.consume(subBuffer).onDone(() -> this.endOfBody(isLast, data, onDone), onDone);
                return;
            }
            this.endOfBody(isLast, data, onDone);
        }

        private void endOfBody(boolean isLast, ByteBuffer data, Async<IOException> onDone) {
            this.entityParser.end().onDone(() -> {
                MultipartEntity.this.parts.add((MimeEntity)this.entityParser.getOutput().getResult());
                if (isLast) {
                    this.eof = true;
                    data.position(data.position() + data.remaining());
                    onDone.unblock();
                    return;
                }
                this.entityParser = new MimeEntity.Parser(this.entityFactory);
                if (!data.hasRemaining()) {
                    onDone.unblock();
                } else {
                    Task.cpu((String)"Parse multi-part entity", (Executable)new Executable.FromRunnable(() -> this.consumeData(data, onDone))).start();
                }
            }, onDone);
        }

        private Boolean searchBoundary(ByteBuffer buffer) {
            block10: while (buffer.hasRemaining()) {
                if (this.boundaryPos == 0) {
                    do {
                        if (buffer.get() != 13) continue;
                        this.boundaryPos = 1;
                        continue block10;
                    } while (buffer.hasRemaining());
                    continue;
                }
                if (this.boundaryPos == 1) {
                    if (buffer.get() != 10) {
                        buffer.position(buffer.position() - 1);
                        this.boundaryPos = 0;
                        return null;
                    }
                    ++this.boundaryPos;
                    continue;
                }
                if (this.boundaryPos < 4) {
                    if (buffer.get() != 45) {
                        buffer.position(buffer.position() - 1);
                        this.boundaryPos = 0;
                        return null;
                    }
                    ++this.boundaryPos;
                    continue;
                }
                if (this.boundaryPos < 4 + MultipartEntity.this.boundary.length) {
                    int len = Math.min(MultipartEntity.this.boundary.length - this.boundaryPos + 4, buffer.remaining());
                    boolean valid = true;
                    int p = buffer.position();
                    for (int i = 0; i < len; ++i) {
                        if (buffer.get(p + i) == MultipartEntity.this.boundary[i + this.boundaryPos - 4]) continue;
                        valid = false;
                        break;
                    }
                    if (!valid) {
                        this.boundaryPos = 0;
                        return null;
                    }
                    buffer.position(buffer.position() + len);
                    this.boundaryPos += len;
                    continue;
                }
                switch (this.boundaryPos - 4 - MultipartEntity.this.boundary.length) {
                    case 0: {
                        switch (buffer.get()) {
                            case 13: {
                                this.isFinalBoundary = false;
                                ++this.boundaryPos;
                                continue block10;
                            }
                            case 45: {
                                this.isFinalBoundary = true;
                                ++this.boundaryPos;
                                continue block10;
                            }
                        }
                        this.boundaryPos = 0;
                        return null;
                    }
                    case 1: {
                        if (this.isFinalBoundary) {
                            if (buffer.get() == 45) {
                                ++this.boundaryPos;
                                continue block10;
                            }
                            buffer.position(buffer.position() - 1);
                            this.boundaryPos = 0;
                            return null;
                        }
                        this.boundaryPos = 0;
                        if (buffer.get() == 10) {
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                    case 2: {
                        if (buffer.get() != 13) {
                            this.boundaryPos = 0;
                            return null;
                        }
                        ++this.boundaryPos;
                        continue block10;
                    }
                    case 3: {
                        this.boundaryPos = 0;
                        if (buffer.get() == 10) {
                            return Boolean.TRUE;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        private void addMissedBuffers(int pos, boolean wasFinal, List<ByteBuffer> buffers) {
            buffers.add(ByteBuffer.wrap(CRLF, 0, pos >= 2 ? 2 : 1).asReadOnlyBuffer());
            if (pos > 2) {
                buffers.add(ByteBuffer.wrap(SEP, 0, pos >= 4 ? 2 : 1).asReadOnlyBuffer());
                if (pos > 4) {
                    buffers.add(ByteBuffer.wrap(MultipartEntity.this.boundary, 0, pos >= 4 + MultipartEntity.this.boundary.length ? MultipartEntity.this.boundary.length : pos - 4).asReadOnlyBuffer());
                    if (pos > 4 + MultipartEntity.this.boundary.length) {
                        if (!wasFinal) {
                            buffers.add(ByteBuffer.wrap(CRLF, 0, 1).asReadOnlyBuffer());
                        } else {
                            buffers.add(ByteBuffer.wrap(SEP, 0, pos >= 4 + MultipartEntity.this.boundary.length + 2 ? 2 : 1).asReadOnlyBuffer());
                            if (pos > 4 + MultipartEntity.this.boundary.length + 2) {
                                buffers.add(ByteBuffer.wrap(CRLF, 0, 1).asReadOnlyBuffer());
                            }
                        }
                    }
                }
            }
        }
    }

    public class BodyProducer
    implements AsyncProducer<ByteBuffer, IOException> {
        private boolean boundSent = false;
        private Iterator<MimeEntity> itPart;
        private MimeEntity currentEntity;
        private boolean headersSent;
        private AsyncProducer<ByteBuffer, IOException> bodyProducer;
        private byte[] bound;

        public BodyProducer() {
            this.itPart = MultipartEntity.this.parts.iterator();
            this.headersSent = false;
            this.bound = new byte[6 + MultipartEntity.this.boundary.length];
            this.bound[MultipartEntity.this.boundary.length + 4] = 13;
            this.bound[0] = 13;
            this.bound[MultipartEntity.this.boundary.length + 5] = 10;
            this.bound[1] = 10;
            this.bound[2] = 45;
            this.bound[3] = 45;
            System.arraycopy(MultipartEntity.this.boundary, 0, this.bound, 4, MultipartEntity.this.boundary.length);
        }

        public AsyncSupplier<ByteBuffer, IOException> produce() {
            if (this.currentEntity == null && !this.itPart.hasNext()) {
                if (this.boundSent) {
                    return new AsyncSupplier(null, null);
                }
                this.boundSent = true;
                byte[] finalBoundary = new byte[this.bound.length + 2];
                System.arraycopy(this.bound, 0, finalBoundary, 0, this.bound.length - 2);
                finalBoundary[MultipartEntity.this.boundary.length + 4] = 45;
                finalBoundary[MultipartEntity.this.boundary.length + 5] = 45;
                finalBoundary[MultipartEntity.this.boundary.length + 6] = 13;
                finalBoundary[MultipartEntity.this.boundary.length + 7] = 10;
                return new AsyncSupplier((Object)ByteBuffer.wrap(finalBoundary), null);
            }
            if (this.currentEntity == null) {
                this.currentEntity = this.itPart.next();
                return new AsyncSupplier((Object)ByteBuffer.wrap(this.bound).asReadOnlyBuffer(), null);
            }
            if (!this.headersSent) {
                this.headersSent = true;
                return new AsyncSupplier((Object)this.currentEntity.getHeaders().generateString(4096).asByteBuffer(), null);
            }
            if (this.bodyProducer == null) {
                AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> body = this.currentEntity.createBodyProducer();
                AsyncSupplier result = new AsyncSupplier();
                body.onDone(pair -> {
                    this.bodyProducer = (AsyncProducer)pair.getValue2();
                    this.produceBody((AsyncSupplier<ByteBuffer, IOException>)result);
                }, (IAsync)result);
                return result;
            }
            AsyncSupplier result = new AsyncSupplier();
            this.produceBody((AsyncSupplier<ByteBuffer, IOException>)result);
            return result;
        }

        private void produceBody(AsyncSupplier<ByteBuffer, IOException> result) {
            this.bodyProducer.produce().onDone(data -> {
                if (data != null) {
                    result.unblockSuccess(data);
                    return;
                }
                this.currentEntity = null;
                this.headersSent = false;
                this.boundSent = false;
                this.bodyProducer = null;
                this.produce().forward(result);
            }, result);
        }
    }
}

