/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncConsumerOutput;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.concurrent.util.LinkedAsyncProducer;
import net.lecousin.framework.concurrent.util.PartialAsyncConsumer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.data.ByteBufferAsBytes;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.out2in.OutputToInput;
import net.lecousin.framework.io.out2in.OutputToInputBuffers;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.MimeEntityFactory;
import net.lecousin.framework.network.mime.entity.MultipartEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.MimeHeadersContainer;
import net.lecousin.framework.network.mime.transfer.ContentDecoderFactory;
import net.lecousin.framework.network.mime.transfer.TransferEncodingFactory;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public abstract class MimeEntity
implements MimeHeadersContainer<MimeEntity> {
    protected MimeEntity parent;
    protected MimeHeaders headers;

    public MimeEntity(MimeEntity parent, MimeHeaders headers) {
        this.parent = parent;
        this.headers = headers;
    }

    public MimeEntity(MimeEntity parent) {
        this(parent, new MimeHeaders());
    }

    public MimeEntity getParent() {
        return this.parent;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public abstract AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer();

    public abstract boolean canProduceBodyRange();

    public abstract Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong var1);

    public AsyncSupplier<IO.OutputToInput, IOException> writeEntity() {
        AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> body = this.createBodyProducer();
        ByteBuffer headersBytes = this.headers.generateString(4096).asByteBuffer();
        AsyncSupplier result = new AsyncSupplier();
        Task.Priority prio = Task.getCurrentPriority();
        body.onDone(pair -> {
            Long size = (Long)pair.getValue1();
            Object io = size != null && size < 131072L ? new OutputToInputBuffers(false, 16, prio) : new OutputToInput((IO.Writable.Seekable)new IOInMemoryOrFile(headersBytes.remaining() + 131072, prio, "MIME entity"), "MIME entity");
            new LinkedAsyncProducer(new AsyncProducer[]{new AsyncProducer.SingleData((Object)headersBytes), (AsyncProducer)pair.getValue2()}).toConsumer(io.createConsumer(), "Write MIME entity", prio);
            result.unblockSuccess(io);
        }, (IAsync)result);
        return result;
    }

    public abstract AsyncConsumer<ByteBuffer, IOException> createConsumer(Long var1);

    public static AsyncSupplier<MimeEntity, IOException> parse(IO.Readable input, MimeEntityFactory entityFactory) {
        Parser parser = new Parser(entityFactory);
        input.createProducer(false).toConsumer((AsyncConsumer)parser, "Parse MIME entity", Task.getCurrentPriority());
        return parser.getOutput();
    }

    public static class Transfer
    extends ParserTransfer
    implements PartialAsyncConsumer<ByteBuffer, IOException> {
        private PartialAsyncConsumer<ByteBuffer, IOException> transfer;

        public Transfer(MimeEntityFactory entityFactory) {
            super(entityFactory);
        }

        public AsyncSupplier<Boolean, IOException> consume(ByteBuffer data) {
            return this.consumeData(data);
        }

        @Override
        protected void endOfHeaders() throws IOException {
            super.endOfHeaders();
            this.transfer = TransferEncodingFactory.create(this.entity.getHeaders(), (AsyncConsumer<ByteBuffer, IOException>)this.bodyConsumer);
        }

        @Override
        protected AsyncSupplier<Boolean, IOException> consumeBody(ByteBuffer data) {
            return this.transfer.consume((Object)data);
        }

        public boolean isExpectingData() {
            return this.headersConsumer != null || this.transfer == null || this.transfer.isExpectingData();
        }

        public MimeEntity getEntity() {
            return this.entity;
        }
    }

    public static class Parser
    extends ParserTransfer
    implements AsyncConsumerOutput<ByteBuffer, MimeEntity, IOException> {
        private AsyncSupplier<MimeEntity, IOException> output = new AsyncSupplier();

        public Parser(MimeEntityFactory entityFactory) {
            super(entityFactory);
        }

        public AsyncSupplier<MimeEntity, IOException> getOutput() {
            return this.output;
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            return this.consumeData(data);
        }

        @Override
        protected void endOfHeaders() throws IOException {
            super.endOfHeaders();
            this.bodyConsumer = ContentDecoderFactory.createDecoder((AsyncConsumer<ByteBuffer, IOException>)this.bodyConsumer, this.entity.getHeaders());
        }

        @Override
        protected AsyncSupplier<Boolean, IOException> consumeBody(ByteBuffer data) {
            AsyncSupplier result = new AsyncSupplier();
            this.bodyConsumer.consume((Object)data).onDone(() -> result.unblockSuccess((Object)Boolean.FALSE), (IAsync)result);
            return result;
        }

        public IAsync<IOException> end() {
            if (this.headersConsumer == null) {
                this.bodyConsumer.end().onDone(() -> this.output.unblockSuccess((Object)this.entity), this.output);
                return this.output;
            }
            this.output.error((Exception)new EOFException("Unexpected end of MIME message while reading headers. Read so far:\r\n" + this.headers.generateString(1024).asString()));
            return this.output;
        }

        public void error(IOException error) {
            if (this.bodyConsumer != null) {
                this.bodyConsumer.error((Exception)error);
            }
            this.output.error((Exception)error);
        }
    }

    private static abstract class ParserTransfer {
        protected MimeEntityFactory entityFactory;
        protected MimeHeaders headers;
        protected MimeHeaders.HeadersConsumer headersConsumer;
        protected MimeEntity entity;
        protected AsyncConsumer<ByteBuffer, IOException> bodyConsumer;

        private ParserTransfer(MimeEntityFactory entityFactory) {
            this.entityFactory = entityFactory;
            this.headers = new MimeHeaders();
            this.headersConsumer = this.headers.new MimeHeaders.HeadersConsumer();
        }

        protected AsyncSupplier<Boolean, IOException> consumeData(ByteBuffer data) {
            if (this.headersConsumer != null) {
                AsyncSupplier<Boolean, MimeException> consume = this.headersConsumer.consume((Bytes.Readable)ByteBufferAsBytes.create((ByteBuffer)data, (boolean)false));
                if (consume.hasError()) {
                    return new AsyncSupplier(null, (Exception)IO.error((Throwable)consume.getError()));
                }
                if (!((Boolean)consume.getResult()).booleanValue()) {
                    return new AsyncSupplier((Object)Boolean.FALSE, null);
                }
                try {
                    this.endOfHeaders();
                }
                catch (IOException e) {
                    return new AsyncSupplier(null, (Exception)e);
                }
            }
            return this.consumeBody(data);
        }

        protected abstract AsyncSupplier<Boolean, IOException> consumeBody(ByteBuffer var1);

        protected void endOfHeaders() throws IOException {
            try {
                this.entity = this.entityFactory.create(null, this.headers);
            }
            catch (MimeException e) {
                throw IO.error((Throwable)e);
            }
            if (this.entity instanceof MultipartEntity) {
                ((MultipartEntity)this.entity).setPartFactory(this.entityFactory);
            }
            this.bodyConsumer = this.entity.createConsumer(this.headers.getContentLength());
            this.headers = null;
            this.headersConsumer = null;
        }
    }
}

