/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.encoding.URLEncoding;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.BytesFromIso8859String;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.data.CharsFromString;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class FormUrlEncodedEntity
extends MimeEntity {
    protected List<Pair<String, String>> parameters = new LinkedList<Pair<String, String>>();

    public FormUrlEncodedEntity() {
        super(null);
        this.headers.addRawValue("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
    }

    public FormUrlEncodedEntity(MimeEntity parent, MimeHeaders headers) {
        super(parent, headers);
    }

    public void add(String name, String value) {
        this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getParameter(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equals(name)) continue;
            return (String)p.getValue2();
        }
        return null;
    }

    @Override
    public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
        if (this.parameters.isEmpty()) {
            return new AsyncSupplier((Object)new Pair((Object)0L, (Object)new AsyncProducer.Empty()), null);
        }
        AsyncSupplier result = new AsyncSupplier();
        BodyProducer producer = new BodyProducer();
        Task.cpu((String)"Produce form-url-encoded", (Task.Priority)Task.getCurrentPriority(), t -> {
            ByteArray first = producer.nextBuffer();
            if (producer.isDone()) {
                result.unblockSuccess((Object)new Pair((Object)first.remaining(), (Object)new AsyncProducer.SingleData((Object)first.toByteBuffer())));
                return null;
            }
            producer.back(first);
            result.unblockSuccess((Object)new Pair(null, (Object)producer));
            return null;
        }).start();
        return result;
    }

    @Override
    public boolean canProduceBodyRange() {
        return false;
    }

    @Override
    public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
        return null;
    }

    @Override
    public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
        return new Parser(size == null ? 1024 : (size < 65536L ? size.intValue() : 65536));
    }

    public class Parser
    implements AsyncConsumer<ByteBuffer, IOException> {
        private CharacterDecoder decoder;
        private IOException error;
        private StringBuilder name = new StringBuilder();
        private StringBuilder value = new StringBuilder();
        private boolean inValue = false;

        public Parser(int bufferSize) {
            Charset charset = null;
            try {
                ParameterizedHeaderValue type = FormUrlEncodedEntity.this.headers.getContentType();
                String cs = type.getParameter("charset");
                if (cs != null) {
                    charset = Charset.forName(cs);
                }
            }
            catch (Exception type) {
                // empty catch block
            }
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            try {
                this.decoder = CharacterDecoder.get((Charset)charset, (int)bufferSize);
            }
            catch (Exception e) {
                this.error = IO.error((Throwable)e);
            }
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            if (this.error != null) {
                return new Async((Exception)this.error);
            }
            Chars.Readable chars = this.decoder.decode((Bytes.Readable)ByteArray.fromByteBuffer((ByteBuffer)data));
            this.decode(chars);
            return new Async(true);
        }

        public IAsync<IOException> end() {
            if (this.error != null) {
                return new Async((Exception)this.error);
            }
            Chars.Readable chars = this.decoder.flush();
            if (chars != null) {
                this.decode(chars);
            }
            if (this.name.length() > 0 || this.value.length() > 0) {
                this.addEncodedParameter(this.name, this.value);
            }
            return new Async(true);
        }

        private void decode(Chars.Readable chars) {
            while (chars.hasRemaining()) {
                char c = chars.get();
                if (c == '&') {
                    if (this.name.length() > 0 || this.value.length() > 0) {
                        this.addEncodedParameter(this.name, this.value);
                    }
                    this.name = new StringBuilder();
                    this.value = new StringBuilder();
                    this.inValue = false;
                    continue;
                }
                if (!this.inValue && c == '=') {
                    this.inValue = true;
                    continue;
                }
                if (this.inValue) {
                    this.value.append(c);
                    continue;
                }
                this.name.append(c);
            }
        }

        private void addEncodedParameter(StringBuilder name, StringBuilder value) {
            FormUrlEncodedEntity.this.parameters.add((Pair<String, String>)new Pair((Object)URLEncoding.decode((Bytes.Readable)new BytesFromIso8859String((CharSequence)name)).asString(), (Object)URLEncoding.decode((Bytes.Readable)new BytesFromIso8859String((CharSequence)value)).asString()));
        }

        public void error(IOException error) {
            this.error = error;
        }
    }

    private class BodyProducer
    implements AsyncProducer<ByteBuffer, IOException> {
        private ByteArray back;
        private Iterator<Pair<String, String>> itParam;
        private boolean firstParam;
        private Pair<String, String> param;
        private int namePos;
        private int valuePos;
        private boolean equalsDone;

        public BodyProducer() {
            this.itParam = FormUrlEncodedEntity.this.parameters.iterator();
            this.firstParam = true;
            this.namePos = 0;
            this.valuePos = 0;
            this.equalsDone = false;
            this.param = this.itParam.next();
        }

        public void back(ByteArray b) {
            this.back = b;
        }

        public ByteArray nextBuffer() {
            ByteArray.Writable b = new ByteArray.Writable((byte[])ByteArrayCache.getInstance().get(2048, true), true);
            do {
                CharsFromString chars;
                if (!this.equalsDone) {
                    String name = (String)this.param.getValue1();
                    if (this.namePos < name.length()) {
                        chars = new CharsFromString((CharSequence)name);
                        chars.setPosition(this.namePos);
                        URLEncoding.encode((Chars.Readable)chars, (Bytes.Writable)b, (boolean)false, (boolean)true);
                        this.namePos = chars.position();
                        if (this.namePos < name.length()) break;
                    }
                    if (!b.hasRemaining()) continue;
                    b.put((byte)61);
                    this.equalsDone = true;
                    continue;
                }
                String value = (String)this.param.getValue2();
                if (this.valuePos < value.length()) {
                    chars = new CharsFromString((CharSequence)value);
                    chars.setPosition(this.valuePos);
                    URLEncoding.encode((Chars.Readable)chars, (Bytes.Writable)b, (boolean)false, (boolean)true);
                    this.valuePos = chars.position();
                    if (this.valuePos < value.length()) break;
                }
                if (!this.itParam.hasNext()) {
                    this.firstParam = false;
                    break;
                }
                if (!b.hasRemaining()) continue;
                b.put((byte)38);
                this.firstParam = false;
                this.param = this.itParam.next();
                this.namePos = 0;
                this.valuePos = 0;
                this.equalsDone = false;
            } while (b.hasRemaining());
            b.flip();
            return b;
        }

        public boolean isDone() {
            return !this.firstParam && !this.itParam.hasNext() && this.equalsDone && this.valuePos == ((String)this.param.getValue2()).length();
        }

        public AsyncSupplier<ByteBuffer, IOException> produce() {
            if (this.back != null) {
                ByteArray b = this.back;
                this.back = null;
                return new AsyncSupplier((Object)b.toByteBuffer(), null);
            }
            if (this.isDone()) {
                return new AsyncSupplier(null, null);
            }
            AsyncSupplier result = new AsyncSupplier();
            Task.cpu((String)"Produce form-url-encoded", (Task.Priority)Task.getCurrentPriority(), t -> {
                ByteArray b = this.nextBuffer();
                result.unblockSuccess((Object)b.toByteBuffer());
                return null;
            }).start();
            return result;
        }
    }
}

