/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.concurrent.util.LinkedAsyncProducer;
import net.lecousin.framework.encoding.QuotedPrintable;
import net.lecousin.framework.encoding.charset.CharacterDecoder;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.entity.MimeEntityFactory;
import net.lecousin.framework.network.mime.entity.MultipartEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.transfer.ContentDecoderFactory;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class FormDataEntity
extends MultipartEntity
implements AutoCloseable,
AsyncCloseable<IOException> {
    public static final String MULTIPART_SUB_TYPE = "form-data";

    public FormDataEntity() {
        super(MULTIPART_SUB_TYPE);
        this.partFactory = new FormDataPartFactory();
    }

    public FormDataEntity(byte[] boundary) {
        super(boundary, MULTIPART_SUB_TYPE);
        this.partFactory = new FormDataPartFactory();
    }

    public FormDataEntity(MimeEntity parent, MimeHeaders headers) throws MimeException {
        super(parent, headers);
        this.partFactory = new FormDataPartFactory();
    }

    @Override
    public void setPartFactory(MimeEntityFactory partFactory) {
    }

    public PartField addField(String name, String value, Charset charset) {
        PartField f = new PartField(this, name, value, charset);
        this.add(f);
        return f;
    }

    public PartFile addFile(String fieldName, String filename, ParameterizedHeaderValue contentType, IO.Readable content) {
        PartFile f = new PartFile(this, fieldName, filename, contentType, content);
        this.add(f);
        return f;
    }

    public List<Pair<String, String>> getFields() {
        LinkedList<Pair<String, String>> list = new LinkedList<Pair<String, String>>();
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartField)) continue;
            list.add((Pair<String, String>)new Pair((Object)((PartField)p).getName(), (Object)((PartField)p).getValue()));
        }
        return list;
    }

    public String getFieldValue(String name) {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartField) || !((PartField)p).getName().equals(name)) continue;
            return ((PartField)p).getValue();
        }
        return null;
    }

    public PartFile getFile(String name) {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile) || !((PartFile)p).getName().equals(name)) continue;
            return (PartFile)p;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            try {
                ((PartFile)p).close();
            }
            catch (Exception e) {
                throw IO.error((Throwable)e);
            }
        }
    }

    public IAsync<IOException> closeAsync() {
        JoinPoint jp = new JoinPoint();
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            jp.addToJoin(((PartFile)p).closeAsync());
        }
        jp.start();
        Async result = new Async();
        jp.onDone(result, IO::error);
        return result;
    }

    public static class PartFile
    extends BinaryEntity {
        protected String fieldName;
        protected String filename;

        public PartFile(FormDataEntity parent, String fieldName, String filename, ParameterizedHeaderValue contentType, IO.Readable content) {
            super(parent, contentType, content);
            this.fieldName = fieldName;
            this.filename = filename;
            ParameterizedHeaderValue dispo = new ParameterizedHeaderValue(FormDataEntity.MULTIPART_SUB_TYPE, "name", fieldName);
            if (filename != null) {
                dispo.addParameter("filename", filename);
            }
            this.headers.add("Content-Disposition", dispo);
        }

        public PartFile(FormDataEntity parent, MimeHeaders headers, String fieldName, String filename) {
            super(parent, headers);
            this.fieldName = fieldName;
            this.filename = filename;
        }

        public String getName() {
            return this.fieldName;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class PartField
    extends MimeEntity {
        protected String name;
        protected String value;
        protected Charset charset;

        public PartField(FormDataEntity parent, String name, String value, Charset charset) {
            super(parent);
            this.name = name;
            this.value = value;
            this.charset = charset;
            this.headers.add("Content-Disposition", new ParameterizedHeaderValue(FormDataEntity.MULTIPART_SUB_TYPE, "name", name));
            this.headers.addRawValue("Content-Transfer-Encoding", "quoted-printable");
            this.headers.add("Content-Type", new ParameterizedHeaderValue("text/plain", "charset", charset.name()));
        }

        public PartField(FormDataEntity parent, MimeHeaders headers, String name, Charset charset) {
            super(parent, headers);
            this.name = name;
            this.charset = charset;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean canProduceBodyRange() {
            return false;
        }

        @Override
        public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
            return null;
        }

        @Override
        public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
            ByteArray input = new ByteArray(this.value.getBytes(this.charset));
            ByteArrayCache cache = ByteArrayCache.getInstance();
            QuotedPrintable.Encoder encoder = new QuotedPrintable.Encoder();
            ByteArray.Writable output = new ByteArray.Writable((byte[])cache.get(input.remaining() + 64, true), true);
            encoder.encode((Bytes.Readable)input, (Bytes.Writable)output, true);
            if (!input.hasRemaining() && output.hasRemaining()) {
                return new AsyncSupplier((Object)new Pair((Object)output.position(), (Object)new AsyncProducer.SingleData((Object)ByteBuffer.wrap((byte[])output.getArray(), 0, output.position()))), null);
            }
            return new AsyncSupplier((Object)new Pair(null, (Object)new LinkedAsyncProducer(new AsyncProducer[]{new AsyncProducer.SingleData((Object)ByteBuffer.wrap((byte[])output.getArray(), 0, output.position())), new ContinueEncodingProducer(input, cache, encoder)})), null);
        }

        @Override
        public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
            return ContentDecoderFactory.createDecoder((AsyncConsumer<ByteBuffer, IOException>)CharacterDecoder.get((Charset)this.charset, (int)1024).decodeConsumerToString(str -> {
                this.value = str;
            }).convert(ByteArray::fromByteBuffer), this.headers);
        }

        private static class ContinueEncodingProducer
        implements AsyncProducer<ByteBuffer, IOException> {
            private ByteArray input;
            private ByteArrayCache cache;
            private QuotedPrintable.Encoder encoder;

            private ContinueEncodingProducer(ByteArray input, ByteArrayCache cache, QuotedPrintable.Encoder encoder) {
                this.input = input;
                this.cache = cache;
                this.encoder = encoder;
            }

            public AsyncSupplier<ByteBuffer, IOException> produce() {
                ByteArray.Writable output = new ByteArray.Writable((byte[])this.cache.get(this.input.remaining() + 64, true), true);
                this.encoder.encode((Bytes.Readable)this.input, (Bytes.Writable)output, true);
                if (output.position() == 0) {
                    output.free();
                    return new AsyncSupplier(null, null);
                }
                return new AsyncSupplier((Object)ByteBuffer.wrap((byte[])output.getArray(), 0, output.position()), null);
            }
        }
    }

    public static class FormDataPartFactory
    implements MimeEntityFactory {
        @Override
        public MimeEntity create(MimeEntity parent, MimeHeaders headers) throws MimeException {
            ParameterizedHeaderValue dispo = headers.getFirstValue("Content-Disposition", ParameterizedHeaderValue.class);
            if (dispo == null) {
                throw new MimeException("Missing header Content-Disposition for a form-data entity, received headers:\r\n" + headers.generateString(512).asString());
            }
            if (!FormDataEntity.MULTIPART_SUB_TYPE.equals(dispo.getMainValue())) {
                throw new MimeException("Invalid Content-Disposition: " + dispo.getMainValue() + ", expected is form-data");
            }
            String fieldName = dispo.getParameter("name");
            if (fieldName == null) {
                throw new MimeException("Missing parameter 'name' in Content-Disposition");
            }
            String filename = dispo.getParameter("filename");
            ParameterizedHeaderValue type = headers.getContentType();
            if ((type == null || "text/plain".equals(type.getMainValue())) && filename == null) {
                String s;
                Charset charset = type == null ? StandardCharsets.US_ASCII : ((s = type.getParameter("charset")) == null ? StandardCharsets.US_ASCII : Charset.forName(s));
                return new PartField((FormDataEntity)parent, headers, fieldName, charset);
            }
            return new PartFile((FormDataEntity)parent, headers, fieldName, filename);
        }
    }
}

