/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.network.mime.MimeException;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.FormDataEntity;
import net.lecousin.framework.network.mime.entity.FormUrlEncodedEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.entity.MimeEntityFactory;
import net.lecousin.framework.network.mime.entity.MultipartEntity;
import net.lecousin.framework.network.mime.entity.TextEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;

public final class DefaultMimeEntityFactory
implements MimeEntityFactory {
    private static final DefaultMimeEntityFactory instance = new DefaultMimeEntityFactory();
    private Map<String, Map<String, Class<? extends MimeEntity>>> registry = new HashMap<String, Map<String, Class<? extends MimeEntity>>>();

    public static DefaultMimeEntityFactory getInstance() {
        return instance;
    }

    private DefaultMimeEntityFactory() {
        this.register(null, null, BinaryEntity.class);
        this.register("text", null, TextEntity.class);
        this.register("multipart", "form-data", FormDataEntity.class);
        this.register("multipart", null, MultipartEntity.class);
        this.register("application", "x-www-form-urlencoded", FormUrlEncodedEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String mainType, String subType, Class<? extends MimeEntity> clazz) {
        Map<String, Map<String, Class<? extends MimeEntity>>> map = this.registry;
        synchronized (map) {
            Map<String, Class<? extends MimeEntity>> subMap = this.registry.get(mainType);
            if (subMap == null) {
                subMap = new HashMap<String, Class<? extends MimeEntity>>();
                this.registry.put(mainType, subMap);
            }
            subMap.put(subType, clazz);
        }
    }

    @Override
    public MimeEntity create(MimeEntity parent, MimeHeaders headers) {
        Map<String, Class<? extends MimeEntity>> subMap;
        String s;
        int i;
        ParameterizedHeaderValue ct;
        try {
            ct = headers.getContentType();
        }
        catch (MimeException e) {
            ct = null;
        }
        String main = null;
        String sub = null;
        if (ct != null && (i = (s = ct.getMainValue()).indexOf(47)) > 0) {
            main = s.substring(0, i);
            sub = s.substring(i + 1);
        }
        if ((subMap = this.registry.get(main)) == null) {
            subMap = this.registry.get(null);
        }
        if (subMap == null) {
            return new BinaryEntity(parent, headers);
        }
        Class<? extends MimeEntity> type = subMap.get(sub);
        if (type == null) {
            type = subMap.get(null);
        }
        if (type == null) {
            return new BinaryEntity(parent, headers);
        }
        try {
            return type.getConstructor(MimeEntity.class, MimeHeaders.class).newInstance(parent, headers);
        }
        catch (Exception e) {
            return null;
        }
    }
}

