/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.SubIO;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.network.mime.entity.BinaryEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class BinaryFileEntity
extends MimeEntity
implements AutoCloseable,
AsyncCloseable<IOException> {
    protected File file;

    public BinaryFileEntity(ParameterizedHeaderValue contentType, File file) {
        this(null, contentType, file);
    }

    public BinaryFileEntity(String contentType, File file) {
        this(new ParameterizedHeaderValue(contentType, new String[0]), file);
    }

    public BinaryFileEntity(File file) {
        this("application/octet-stream", file);
    }

    public BinaryFileEntity(MimeEntity parent, ParameterizedHeaderValue contentType, File file) {
        super(parent);
        this.headers.add("Content-Type", contentType);
        this.file = file;
    }

    public BinaryFileEntity(MimeEntity parent, MimeHeaders headers) {
        super(parent, headers);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
        FileIO.ReadOnly io = new FileIO.ReadOnly(this.file, Task.getCurrentPriority());
        return new AsyncSupplier((Object)new Pair((Object)this.file.length(), (Object)io.createProducer(true)), null);
    }

    @Override
    public boolean canProduceBodyRange() {
        return true;
    }

    @Override
    public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
        long size = this.file.length();
        RangeLong r = new RangeLong(range.min, range.max);
        if (r.min == -1L) {
            r.min = size - r.max;
            r.max = size - 1L;
        } else if (r.max == -1L || r.max > size - 1L) {
            r.max = size - 1L;
        }
        SubIO.Readable.Seekable subIO = new SubIO.Readable.Seekable((IO.Readable.Seekable)new FileIO.ReadOnly(this.file, Task.getCurrentPriority()), r.min, r.max - r.min + 1L, "Range of " + this.file.getAbsolutePath(), true);
        BinaryEntity subEntity = new BinaryEntity(null, new MimeHeaders(this.getHeaders().getHeaders()));
        subEntity.setContent((IO.Readable)subIO);
        return new Triple((Object)r, (Object)size, (Object)subEntity);
    }

    @Override
    public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
        return new Consumer();
    }

    public IAsync<IOException> closeAsync() {
        return new Async(true);
    }

    @Override
    public void close() {
    }

    public class Consumer
    implements AsyncConsumer<ByteBuffer, IOException> {
        private FileIO.WriteOnly io;

        public Consumer() {
            this.io = new FileIO.WriteOnly(BinaryFileEntity.this.file, Task.getCurrentPriority());
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            AsyncSupplier result = this.io.writeAsync(data);
            if (!data.isReadOnly() && data.hasArray()) {
                result.onDone(() -> ByteArrayCache.getInstance().free(data));
            }
            return result;
        }

        public IAsync<IOException> end() {
            return this.io.closeAsync();
        }

        public void error(IOException error) {
            this.io.closeAsync();
        }
    }
}

