/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.AsyncProducer;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.SubIO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.out2in.OutputToInput;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class BinaryEntity
extends MimeEntity
implements AutoCloseable,
AsyncCloseable<IOException> {
    protected IO.Readable content;

    public BinaryEntity(ParameterizedHeaderValue contentType, IO.Readable content) {
        this(null, contentType, content);
    }

    public BinaryEntity(String contentType, IO.Readable content) {
        this(new ParameterizedHeaderValue(contentType, new String[0]), content);
    }

    public BinaryEntity(IO.Readable content) {
        this("application/octet-stream", content);
    }

    public BinaryEntity(MimeEntity parent, ParameterizedHeaderValue contentType, IO.Readable content) {
        super(parent);
        this.headers.add("Content-Type", contentType);
        this.content = content;
    }

    public BinaryEntity(MimeEntity parent, MimeHeaders headers) {
        super(parent, headers);
    }

    public IO.Readable getContent() {
        return this.content;
    }

    public void setContent(IO.Readable content) {
        this.content = content;
    }

    public void setContentType(ParameterizedHeaderValue contentType) {
        this.getHeaders().set("Content-Type", contentType);
    }

    public void setContentType(String contentType) {
        this.getHeaders().setRawValue("Content-Type", contentType);
    }

    @Override
    public AsyncSupplier<Pair<Long, AsyncProducer<ByteBuffer, IOException>>, IOException> createBodyProducer() {
        AsyncSupplier result = new AsyncSupplier();
        if (this.content instanceof IO.KnownSize) {
            ((IO.KnownSize)this.content).getSizeAsync().onDone(size -> result.unblockSuccess((Object)new Pair(size, (Object)this.content.createProducer(false))), (IAsync)result);
        } else {
            result.unblockSuccess((Object)new Pair(null, (Object)this.content.createProducer(false)));
        }
        return result;
    }

    @Override
    public boolean canProduceBodyRange() {
        return this.content instanceof IO.KnownSize && this.content instanceof IO.Readable.Seekable;
    }

    @Override
    public Triple<RangeLong, Long, BinaryEntity> createBodyRange(RangeLong range) {
        long size;
        try {
            size = ((IO.KnownSize)this.content).getSizeSync();
        }
        catch (IOException e) {
            return null;
        }
        RangeLong r = new RangeLong(range.min, range.max);
        if (r.min == -1L) {
            r.min = size - r.max;
            r.max = size - 1L;
        } else if (r.max == -1L || r.max > size - 1L) {
            r.max = size - 1L;
        }
        SubIO.Readable.Seekable subIO = new SubIO.Readable.Seekable((IO.Readable.Seekable)this.content, r.min, r.max - r.min + 1L, "Range of " + this.content.getSourceDescription(), false);
        BinaryEntity subEntity = new BinaryEntity(null, new MimeHeaders(this.getHeaders().getHeaders()));
        subEntity.setContent((IO.Readable)subIO);
        return new Triple((Object)r, (Object)size, (Object)subEntity);
    }

    @Override
    public AsyncConsumer<ByteBuffer, IOException> createConsumer(Long size) {
        return new Consumer(this, size);
    }

    public IAsync<IOException> closeAsync() {
        return this.content.closeAsync();
    }

    @Override
    public void close() throws Exception {
        this.content.close();
    }

    public static BinaryEntity fromString(String content, Charset charset, String contentType) {
        return new BinaryEntity(new ParameterizedHeaderValue(contentType, "charset", charset.name()), (IO.Readable)new ByteArrayIO(content.getBytes(charset), "BinaryEntity from string"));
    }

    public static class Consumer
    implements AsyncConsumer<ByteBuffer, IOException> {
        final /* synthetic */ BinaryEntity this$0;

        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> Consumer(T io) {
            this.this$0 = this$0;
            this$0.content = new OutputToInput((IO.Writable.Seekable)io, io.getSourceDescription());
        }

        public Consumer(BinaryEntity this$0, Long size) {
            this.this$0 = this$0;
            if (!(this$0.content instanceof IO.OutputToInput)) {
                if (size == null || size >= 131072L) {
                    IOInMemoryOrFile io = new IOInMemoryOrFile(131072, Task.Priority.NORMAL, "BinaryEntity");
                    this$0.content = new OutputToInput((IO.Writable.Seekable)io, io.getSourceDescription());
                } else {
                    ByteArrayIO io = new ByteArrayIO((byte[])ByteArrayCache.getInstance().get(size.intValue(), true), "BinaryEntity");
                    this$0.content = new OutputToInput((IO.Writable.Seekable)io, io.getSourceDescription());
                }
            }
        }

        public IAsync<IOException> consume(ByteBuffer data) {
            AsyncSupplier result = ((IO.OutputToInput)this.this$0.content).writeAsync(data);
            if (!data.isReadOnly() && data.hasArray()) {
                result.onDone(() -> ByteArrayCache.getInstance().free(data));
            }
            return result;
        }

        public IAsync<IOException> end() {
            ((IO.OutputToInput)this.this$0.content).endOfData();
            return new Async(true);
        }

        public void error(IOException error) {
            ((IO.OutputToInput)this.this$0.content).signalErrorBeforeEndOfData(error);
        }
    }
}

