/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.encoding.Base64Encoding;
import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.QuotedPrintable;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.CharArrayStringBuffer;

public final class MimeUtil {
    private MimeUtil() {
    }

    public static String decodeRFC2047(String value) throws EncodingException, UnsupportedEncodingException {
        int pos = 0;
        while (pos < value.length()) {
            int j;
            int i = value.indexOf("=?", pos);
            int i2 = value.indexOf(34, pos);
            if (i2 >= 0 && (i < 0 || i > i2) && (j = value.indexOf(34, i2 + 1)) > 0) {
                value = value.substring(0, i2) + value.substring(i2 + 1, j) + value.substring(j + 1);
                pos = j - 1;
                continue;
            }
            if (i < 0 || (j = value.indexOf("?=", i + 2)) < 0) break;
            String decoded = MimeUtil.decodeRFC2047Word(value.substring(i + 2, j));
            value = value.substring(0, i) + decoded + value.substring(j + 2);
            pos = i + decoded.length();
        }
        return value;
    }

    public static String decodeRFC2047Word(String encodedWord) throws EncodingException, UnsupportedEncodingException {
        int i = encodedWord.indexOf(63);
        if (i < 0) {
            return encodedWord;
        }
        String charsetName = encodedWord.substring(0, i);
        if ((i = (encodedWord = encodedWord.substring(i + 1)).indexOf(63)) < 0) {
            return encodedWord;
        }
        String encoding = encodedWord.substring(0, i);
        encodedWord = encodedWord.substring(i + 1);
        if ("B".equals(encoding = encoding.trim().toUpperCase())) {
            byte[] decoded = Base64Encoding.instance.decode(encodedWord.getBytes(StandardCharsets.US_ASCII));
            return new String(decoded, charsetName);
        }
        if ("Q".equals(encoding)) {
            QuotedPrintable.Decoder decoder = new QuotedPrintable.Decoder();
            ByteArray.Writable input = new ByteArray.Writable(encodedWord.getBytes(StandardCharsets.US_ASCII), true);
            ByteArray.Writable output = new ByteArray.Writable((byte[])ByteArrayCache.getInstance().get(input.remaining() + 1, true), true);
            decoder.decode((Bytes.Readable)input, (Bytes.Writable)output, true);
            String decoded = new String((byte[])output.getArray(), 0, output.position(), charsetName);
            input.free();
            output.free();
            return decoded;
        }
        throw new UnsupportedEncodingException("RFC 2047 encoding " + encoding);
    }

    public static boolean isValidTokenCharacter(byte c) {
        if (c < 33) {
            return false;
        }
        if (c > 93) {
            if (c < 123) {
                return true;
            }
            return c == 124 || c == 126;
        }
        if (c > 64) {
            return c < 91;
        }
        if (c > 47) {
            return c < 58;
        }
        if (c < 40) {
            return c != 34;
        }
        return c == 42 || c == 43 || c == 45 || c == 46;
    }

    public static String encodeToken(String value) {
        for (int i = value.length() - 1; i >= 0; --i) {
            if (MimeUtil.isValidTokenCharacter((byte)value.charAt(i))) continue;
            return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    public static String encodeHeaderValue(String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        boolean hasSpecialChars = false;
        boolean needsQuote = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (!(needsQuote || bytes[i] != 32 && bytes[i] != 9 && bytes[i] != 34 && bytes[i] != 61)) {
                needsQuote = true;
            }
            if ((bytes[i] >= 32 || bytes[i] == 9) && bytes[i] <= 126) continue;
            hasSpecialChars = true;
            break;
        }
        if (!hasSpecialChars) {
            if (!needsQuote) {
                return value;
            }
            return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        CharArrayStringBuffer s = new CharArrayStringBuffer(new CharArrayString(value.length() + 64));
        s.append((CharSequence)"=?");
        s.append((CharSequence)charset.name());
        s.append((CharSequence)"?B?");
        s.append((CharSequence)new ByteArrayStringIso8859(Base64Encoding.instance.encode(bytes)));
        s.append((CharSequence)"?=");
        return s.toString();
    }

    public static String encodeHeaderValueWithUTF8(String value) {
        return MimeUtil.encodeHeaderValue(value, StandardCharsets.UTF_8);
    }
}

