/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.encoding.QuotedPrintable;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;

public class QuotedPrintableDecoder
implements ContentDecoder {
    private ContentDecoder next;
    private byte[] previousRemainingData = null;
    private SynchronizationPoint<IOException> lastDecode = null;

    public QuotedPrintableDecoder(ContentDecoder next) {
        this.next = next;
    }

    @Override
    public ISynchronizationPoint<IOException> decode(final ByteBuffer data) {
        final SynchronizationPoint decode = new SynchronizationPoint();
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Decoding QuotedPrintable data", 4){

            public Void run() {
                ByteBuffer decoded;
                ByteBuffer input;
                if (QuotedPrintableDecoder.this.previousRemainingData != null) {
                    byte[] b = new byte[QuotedPrintableDecoder.this.previousRemainingData.length + data.remaining()];
                    System.arraycopy(QuotedPrintableDecoder.this.previousRemainingData, 0, b, 0, QuotedPrintableDecoder.this.previousRemainingData.length);
                    data.get(b, QuotedPrintableDecoder.this.previousRemainingData.length, b.length - QuotedPrintableDecoder.this.previousRemainingData.length);
                    input = ByteBuffer.wrap(b);
                } else {
                    input = data;
                }
                try {
                    decoded = QuotedPrintable.decode((ByteBuffer)input);
                }
                catch (IOException e) {
                    decode.error((Exception)e);
                    return null;
                }
                if (input.hasRemaining()) {
                    QuotedPrintableDecoder.access$002(QuotedPrintableDecoder.this, new byte[input.remaining()]);
                    input.get(QuotedPrintableDecoder.this.previousRemainingData, 0, input.remaining());
                } else {
                    QuotedPrintableDecoder.access$002(QuotedPrintableDecoder.this, null);
                }
                ISynchronizationPoint<IOException> write = QuotedPrintableDecoder.this.next.decode(decoded);
                write.listenInline(() -> {
                    if (write.hasError()) {
                        decode.error(write.getError());
                    } else if (write.isCancelled()) {
                        decode.cancel(write.getCancelEvent());
                    } else {
                        decode.unblock();
                    }
                });
                return null;
            }
        };
        if (this.lastDecode == null) {
            this.lastDecode = decode;
            task.start();
            return decode;
        }
        SynchronizationPoint<IOException> previous = this.lastDecode;
        this.lastDecode = decode;
        previous.listenInline(() -> QuotedPrintableDecoder.lambda$decode$0(previous, decode, (Task)task));
        return decode;
    }

    @Override
    public ISynchronizationPoint<IOException> endOfData() {
        return this.next.endOfData();
    }

    private static /* synthetic */ void lambda$decode$0(SynchronizationPoint previous, SynchronizationPoint decode, Task task) {
        if (previous.hasError()) {
            decode.error(decode.getError());
        } else if (previous.isCancelled()) {
            decode.cancel(decode.getCancelEvent());
        } else {
            task.start();
        }
    }

    static /* synthetic */ byte[] access$002(QuotedPrintableDecoder x0, byte[] x1) {
        x0.previousRemainingData = x1;
        return x1;
    }
}

