/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.util.LinkedList;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValues;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.network.mime.transfer.IdentityTransfer;
import net.lecousin.framework.network.mime.transfer.TransferReceiver;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoderFactory;
import net.lecousin.framework.network.mime.transfer.encoding.IdentityDecoder;

public final class TransferEncodingFactory {
    private TransferEncodingFactory() {
    }

    public static TransferReceiver create(MimeMessage mime, IO.Writable out) throws IOException {
        String s;
        String e;
        ParameterizedHeaderValues values;
        String transfer = "identity";
        LinkedList<String> encoding = new LinkedList<String>();
        try {
            values = mime.getFirstHeaderValue("Transfer-Encoding", ParameterizedHeaderValues.class);
        }
        catch (Exception e2) {
            values = null;
        }
        if (values != null) {
            for (ParameterizedHeaderValue value : values.getValues()) {
                e = value.getMainValue();
                if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
            if (!encoding.isEmpty()) {
                s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    transfer = s;
                    encoding.removeLast();
                }
            }
        }
        try {
            values = mime.getFirstHeaderValue("Content-Transfer-Encoding", ParameterizedHeaderValues.class);
        }
        catch (Exception e3) {
            values = null;
        }
        if (values != null) {
            for (ParameterizedHeaderValue value : values.getValues()) {
                e = value.getMainValue();
                if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
            if (!encoding.isEmpty()) {
                s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    transfer = s;
                    encoding.removeLast();
                }
            }
        }
        try {
            values = mime.getFirstHeaderValue("Content-Encoding", ParameterizedHeaderValues.class);
        }
        catch (Exception e4) {
            values = null;
        }
        if (values != null) {
            for (ParameterizedHeaderValue value : values.getValues()) {
                e = value.getMainValue();
                if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
        }
        ContentDecoder decoder = new IdentityDecoder(out);
        for (String coding : encoding) {
            decoder = ContentDecoderFactory.createDecoder(decoder, coding);
        }
        if ("chunked".equals(transfer)) {
            return new ChunkedTransfer(mime, decoder);
        }
        return new IdentityTransfer(mime, decoder);
    }
}

