/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.network.mime.header.parser.Token;

public class ParameterizedHeaderValues
implements HeaderValueFormat {
    private List<ParameterizedHeaderValue> values = new LinkedList<ParameterizedHeaderValue>();

    public List<ParameterizedHeaderValue> getValues() {
        return this.values;
    }

    public ParameterizedHeaderValue getMainValue(String value) {
        for (ParameterizedHeaderValue v : this.values) {
            if (!value.equals(v.getMainValue())) continue;
            return v;
        }
        return null;
    }

    public boolean hasMainValue(String value) {
        return this.getMainValue(value) != null;
    }

    @Override
    public void parseTokens(List<Token> tokens) throws Exception {
        this.values.clear();
        List<List<Token>> list = Token.splitBySpecialCharacter(tokens, ',');
        for (List<Token> subList : list) {
            ParameterizedHeaderValue value = new ParameterizedHeaderValue();
            value.parseTokens(subList);
            this.values.add(value);
        }
    }

    @Override
    public List<Token> generateTokens() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        for (ParameterizedHeaderValue value : this.values) {
            if (!tokens.isEmpty()) {
                tokens.add(new SpecialCharacter(','));
            }
            tokens.addAll(value.generateTokens());
        }
        return tokens;
    }
}

