/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.InternetAddressHeaderValue;
import net.lecousin.framework.network.mime.header.parser.SpecialCharacter;
import net.lecousin.framework.network.mime.header.parser.Token;

public class InternetAddressListHeaderValue
implements HeaderValueFormat {
    protected List<InternetAddressHeaderValue> addresses = new LinkedList<InternetAddressHeaderValue>();

    public List<InternetAddressHeaderValue> getAddresses() {
        return this.addresses;
    }

    public void addAddress(InternetAddressHeaderValue address) {
        this.addresses.add(address);
    }

    public void addAddress(String displayName, String address) {
        this.addAddress(new InternetAddressHeaderValue(displayName, address));
    }

    @Override
    public void parseTokens(List<Token> tokens) {
        List<List<Token>> list = Token.splitBySpecialCharacter(tokens, ',');
        for (List<Token> addrTokens : list) {
            Token.trim(addrTokens);
            if (addrTokens.isEmpty()) continue;
            InternetAddressHeaderValue addr = new InternetAddressHeaderValue();
            addr.parseTokens(addrTokens);
            this.addresses.add(addr);
        }
    }

    @Override
    public List<Token> generateTokens() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        for (InternetAddressHeaderValue addr : this.addresses) {
            if (!tokens.isEmpty()) {
                tokens.add(new SpecialCharacter(','));
            }
            tokens.addAll(addr.generateTokens());
        }
        return tokens;
    }
}

