/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;

public class TextEntity
extends MimeEntity {
    private String text;
    private Charset charset;

    public TextEntity(String text, Charset charset, String textMimeType) {
        this.text = text;
        this.charset = charset;
        this.setHeaderRaw("Content-Type", textMimeType + ";charset=" + charset.name());
    }

    protected TextEntity(MimeMessage from) throws Exception {
        super(from);
        this.text = "";
        ParameterizedHeaderValue type = this.getFirstHeaderValue("Content-Type", ParameterizedHeaderValue.class);
        this.charset = type == null || type.getParameter("charset") == null ? StandardCharsets.UTF_8 : Charset.forName(type.getParameter("charset"));
    }

    public static AsyncWork<TextEntity, IOException> from(MimeMessage mime, boolean fromReceived) {
        IO.Readable body;
        TextEntity entity;
        try {
            entity = new TextEntity(mime);
        }
        catch (Exception e) {
            return new AsyncWork(null, (Exception)IO.error((Throwable)e));
        }
        IO.Readable readable = body = fromReceived ? mime.getBodyReceivedAsInput() : mime.getBodyToSend();
        if (body == null) {
            return new AsyncWork((Object)entity, null);
        }
        AsyncWork task = IOUtil.readFullyAsString((IO.Readable)body, (Charset)entity.charset, (byte)body.getPriority());
        AsyncWork result = new AsyncWork();
        task.listenInline(str -> {
            entity.text = str.asString();
            result.unblockSuccess((Object)entity);
        }, (ISynchronizationPoint)result);
        result.listenInline(() -> body.closeAsync());
        return result;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) throws Exception {
        if (charset.equals(this.charset)) {
            return;
        }
        this.charset = charset;
        ParameterizedHeaderValue type = this.getFirstHeaderValue("Content-Type", ParameterizedHeaderValue.class);
        if (type == null) {
            type = new ParameterizedHeaderValue("text/plain", "charset", charset.name());
            this.addHeader("Content-Type", type);
        } else {
            type.setParameterIgnoreCase("charset", charset.name());
            this.setHeader("Content-Type", type);
        }
    }

    @Override
    public IO.Readable getBodyToSend() {
        return new ByteArrayIO(this.text.getBytes(this.charset), "TextEntity");
    }
}

