/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.LinkedIO;
import net.lecousin.framework.io.SubIO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.network.mime.MimeHeader;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.MimeUtil;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;

public class MultipartEntity
extends MimeEntity {
    private static int counter = 0;
    private static final Random random = new Random();
    protected byte[] boundary;
    protected LinkedList<MimeMessage> parts = new LinkedList();

    public MultipartEntity(byte[] boundary, String subType) {
        this.boundary = boundary;
        this.setHeader("Content-Type", new ParameterizedHeaderValue("multipart/" + subType, "boundary", new String(boundary, StandardCharsets.US_ASCII)));
    }

    public MultipartEntity(String subType) {
        this(MultipartEntity.generateBoundary(), subType);
    }

    protected MultipartEntity(MimeMessage mime) throws Exception {
        super(mime);
        ParameterizedHeaderValue ct = mime.getContentType();
        if (ct == null) {
            throw new Exception("Missing Content-Type header");
        }
        String s = ct.getParameterIgnoreCase("boundary");
        if (s == null) {
            throw new Exception("No boundary specified in Content-Type header");
        }
        this.boundary = s.getBytes(StandardCharsets.US_ASCII);
    }

    public static AsyncWork<MultipartEntity, Exception> from(MimeMessage mime, boolean fromReceived) {
        IO.Readable body;
        MultipartEntity entity;
        try {
            entity = new MultipartEntity(mime);
        }
        catch (Exception e) {
            return new AsyncWork(null, e);
        }
        IO.Readable readable = body = fromReceived ? mime.getBodyReceivedAsInput() : mime.getBodyToSend();
        if (body == null) {
            return new AsyncWork((Object)entity, null);
        }
        SynchronizationPoint<IOException> parse = entity.parse(body, fromReceived);
        AsyncWork result = new AsyncWork();
        parse.listenInlineSP(() -> result.unblockSuccess((Object)entity), (ISynchronizationPoint)result);
        parse.listenInline(() -> body.closeAsync());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] generateBoundary() {
        long rand;
        int count;
        Random random = MultipartEntity.random;
        synchronized (random) {
            count = counter++;
            rand = MultipartEntity.random.nextLong();
        }
        long timestamp = System.currentTimeMillis();
        byte[] boundary = new byte[]{45, 45, MultipartEntity.encodeBoundary((int)(timestamp & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 25 & 0x1FL)), MultipartEntity.encodeBoundary(count & 0x1F), MultipartEntity.encodeBoundary(count >> 5 & 0x1F), MultipartEntity.encodeBoundary(count >> 10 & 0x1F), MultipartEntity.encodeBoundary(count >> 15 & 0x1F), MultipartEntity.encodeBoundary((int)(rand & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 25 & 0x1FL))};
        return boundary;
    }

    private static byte encodeBoundary(int value) {
        if (value < 26) {
            return (byte)(97 + value);
        }
        return (byte)(48 + (value - 26));
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    public void add(MimeMessage part) {
        this.parts.add(part);
    }

    public List<MimeMessage> getParts() {
        return this.parts;
    }

    public <T extends MimeMessage> List<T> getPartsOfType(Class<T> type) {
        LinkedList<MimeMessage> list = new LinkedList<MimeMessage>();
        for (MimeMessage p : this.parts) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            list.add(p);
        }
        return list;
    }

    @Override
    public IO.Readable getBodyToSend() {
        byte[] bound = new byte[6 + this.boundary.length];
        bound[this.boundary.length + 4] = 13;
        bound[0] = 13;
        bound[this.boundary.length + 5] = 10;
        bound[1] = 10;
        bound[2] = 45;
        bound[3] = 45;
        System.arraycopy(this.boundary, 0, bound, 4, this.boundary.length);
        ByteArrayIO boundaryIO = new ByteArrayIO(bound, "multipart boundary");
        IO.Readable[] ios = new IO.Readable[this.parts.size() * 2 + 1];
        int i = 0;
        boolean allKnownSize = true;
        for (MimeMessage p : this.parts) {
            ios[i++] = new SubIO.Readable.Seekable((IO.Readable.Seekable)boundaryIO, 0L, (long)bound.length, "Multipart boundary", false);
            IO.Readable io = p.getReadableStream();
            ios[i++] = io;
            if (io instanceof IO.KnownSize) continue;
            allKnownSize = false;
        }
        byte[] finalBoundary = new byte[6 + this.boundary.length];
        finalBoundary[0] = 13;
        finalBoundary[1] = 10;
        finalBoundary[this.boundary.length + 4] = 45;
        finalBoundary[2] = 45;
        finalBoundary[this.boundary.length + 5] = 45;
        finalBoundary[3] = 45;
        System.arraycopy(this.boundary, 0, finalBoundary, 4, this.boundary.length);
        ios[i] = new ByteArrayIO(finalBoundary, finalBoundary.length, "multipart ending boundary");
        if (allKnownSize) {
            return new LinkedIO.Readable.DeterminedSize("MIME form-data", ios);
        }
        return new LinkedIO.Readable("MIME form-data", ios);
    }

    public SynchronizationPoint<IOException> parse(IO.Readable content, boolean asReceived) {
        Object bio = content instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)content : new SimpleBufferedReadable(content, 8192);
        SynchronizationPoint sp = new SynchronizationPoint();
        Parser parser = new Parser((IO.Readable.Buffered)bio, (SynchronizationPoint<IOException>)sp, asReceived);
        parser.nextBuffer();
        return sp;
    }

    protected AsyncWork<MimeMessage, IOException> createPart(List<MimeHeader> headers, IOInMemoryOrFile body, boolean asReceived) {
        MimeMessage mime = new MimeMessage();
        mime.getHeaders().addAll(headers);
        if (asReceived) {
            mime.setBodyReceived(body);
        } else {
            mime.setBodyToSend((IO.Readable)body);
        }
        return new AsyncWork((Object)mime, null);
    }

    private class Parser {
        private IO.Readable.Buffered io;
        private SynchronizationPoint<IOException> sp;
        private boolean asReceived;
        private byte[] boundaryRead = null;
        private int boundaryPos = 0;
        private boolean firstBoundary = true;
        private MimeUtil.HeadersLinesReceiver header = null;
        private StringBuilder headerLine = null;
        private IOInMemoryOrFile body = null;
        private byte[] bodyBuffer = new byte[1024];
        private int bodyBufferPos = 0;

        public Parser(IO.Readable.Buffered io, SynchronizationPoint<IOException> sp, boolean asReceived) {
            this.io = io;
            this.sp = sp;
            this.asReceived = asReceived;
        }

        public void nextBuffer() {
            this.io.readNextBufferAsync().listenInline(buffer -> this.parse((ByteBuffer)buffer), this.sp);
        }

        private void parse(final ByteBuffer buffer) {
            if (buffer == null) {
                this.sp.error((Exception)new EOFException("Unexpected end of multipart content"));
                return;
            }
            new Task.Cpu<Void, NoException>("Parsing multipart content", this.io.getPriority()){

                public Void run() {
                    while (buffer.hasRemaining()) {
                        byte b = buffer.get();
                        if (Parser.this.header != null && Parser.this.body == null) {
                            if (b == 10) {
                                String line = Parser.this.headerLine.length() > 0 && Parser.this.headerLine.charAt(Parser.this.headerLine.length() - 1) == '\r' ? Parser.this.headerLine.substring(0, Parser.this.headerLine.length() - 1) : Parser.this.headerLine.toString();
                                try {
                                    Parser.this.header.newLine(line);
                                }
                                catch (Exception e) {
                                    Parser.this.sp.error((Exception)IO.error((Throwable)e));
                                    return null;
                                }
                                if (line.length() == 0) {
                                    Parser.this.headerLine = null;
                                    Parser.this.body = new IOInMemoryOrFile(8192, Parser.this.io.getPriority(), "Multipart body");
                                    continue;
                                }
                                Parser.this.headerLine = new StringBuilder(128);
                                continue;
                            }
                            Parser.this.headerLine.append((char)b);
                            continue;
                        }
                        if (Parser.this.boundaryPos == 0) {
                            if (b == 13) {
                                if (Parser.this.boundaryRead == null) {
                                    Parser.access$602(Parser.this, new byte[4 + MultipartEntity.this.boundary.length + 2]);
                                }
                                ((Parser)Parser.this).boundaryRead[0] = b;
                                Parser.this.boundaryPos = 1;
                                Parser.this.firstBoundary = false;
                                continue;
                            }
                            if (Parser.this.body != null) {
                                ((Parser)Parser.this).bodyBuffer[((Parser)Parser.this).bodyBufferPos++] = b;
                                if (Parser.this.bodyBufferPos != Parser.this.bodyBuffer.length) continue;
                                Parser.this.body.writeAsync(ByteBuffer.wrap(Parser.this.bodyBuffer)).listenInline(written -> {
                                    Parser.this.bodyBufferPos = 0;
                                    Parser.this.parse(buffer);
                                }, (ISynchronizationPoint)Parser.this.sp);
                                return null;
                            }
                            if (!Parser.this.firstBoundary || b != 45) continue;
                            Parser.access$602(Parser.this, new byte[4 + MultipartEntity.this.boundary.length + 2]);
                            ((Parser)Parser.this).boundaryRead[2] = 45;
                            Parser.this.boundaryPos = 3;
                            continue;
                        }
                        if (Parser.this.boundaryPos == 1) {
                            if (b == 10) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos < 4) {
                            if (b == 45) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos < 4 + MultipartEntity.this.boundary.length) {
                            if (b == MultipartEntity.this.boundary[Parser.this.boundaryPos - 4]) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos == 4 + MultipartEntity.this.boundary.length) {
                            if (b == 13 || b == 45) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryRead[Parser.this.boundaryPos - 1] == 13) {
                            if (b == 10) {
                                Parser.this.firstBoundary = false;
                                if (Parser.this.body != null) {
                                    Parser.this.createPart(buffer);
                                    return null;
                                }
                                Parser.this.header = new MimeUtil.HeadersLinesReceiver(new LinkedList<MimeHeader>());
                                Parser.this.headerLine = new StringBuilder(128);
                                Parser.this.body = null;
                                Parser.this.bodyBufferPos = 0;
                                Parser.access$602(Parser.this, null);
                                Parser.this.boundaryPos = 0;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (b == 45) {
                            if (Parser.this.body != null) {
                                Parser.this.createPart(null);
                                return null;
                            }
                            Parser.this.sp.unblock();
                            return null;
                        }
                        if (Parser.this.notBoundary(buffer)) continue;
                        return null;
                    }
                    Parser.this.nextBuffer();
                    return null;
                }
            }.start();
        }

        private boolean notBoundary(ByteBuffer buffer) {
            this.firstBoundary = false;
            buffer.position(buffer.position() - 1);
            if (this.body == null) {
                this.boundaryPos = 0;
                return true;
            }
            for (int i = 0; i < this.boundaryPos; ++i) {
                this.bodyBuffer[this.bodyBufferPos++] = this.boundaryRead[i];
                if (this.bodyBufferPos != this.bodyBuffer.length) continue;
                int j = i + 1;
                this.body.writeAsync(ByteBuffer.wrap(this.bodyBuffer)).listenInline(written -> {
                    if (j < this.boundaryPos) {
                        System.arraycopy(this.boundaryRead, j, this.bodyBuffer, 0, this.boundaryPos - j);
                        this.bodyBufferPos = this.boundaryPos - j;
                    } else {
                        this.bodyBufferPos = 0;
                    }
                    this.boundaryPos = 0;
                    this.parse(buffer);
                }, this.sp);
                return false;
            }
            this.boundaryPos = 0;
            return true;
        }

        private void createPart(ByteBuffer buffer) {
            if (this.bodyBufferPos > 0) {
                this.body.writeAsync(ByteBuffer.wrap(this.bodyBuffer, 0, this.bodyBufferPos)).listenInline(written -> {
                    this.bodyBufferPos = 0;
                    this.createPart(buffer);
                }, this.sp);
                return;
            }
            this.body.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
            MultipartEntity.this.createPart(this.header.getHeaders(), this.body, this.asReceived).listenInline(part -> {
                MultipartEntity.this.parts.add((MimeMessage)part);
                if (buffer != null) {
                    this.header = new MimeUtil.HeadersLinesReceiver(new LinkedList<MimeHeader>());
                    this.headerLine = new StringBuilder(128);
                    this.body = null;
                    this.bodyBufferPos = 0;
                    this.boundaryRead = null;
                    this.boundaryPos = 0;
                    this.parse(buffer);
                    return;
                }
                this.sp.unblock();
            }, this.sp);
        }

        static /* synthetic */ byte[] access$602(Parser x0, byte[] x1) {
            x0.boundaryRead = x1;
            return x1;
        }
    }
}

