/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.util.IString;

public class MimeHeader {
    private String name;
    private String nameLowerCase;
    private String rawValue;
    private Map<Class<? extends HeaderValueFormat>, HeaderValueFormat> parsed = null;

    public MimeHeader(String name, String rawValue) {
        this.name = name;
        this.nameLowerCase = name.toLowerCase();
        this.rawValue = rawValue;
    }

    public MimeHeader(String name, HeaderValueFormat value) {
        this.name = name;
        this.nameLowerCase = name.toLowerCase();
        this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        this.parsed.put(value.getClass(), value);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLowerCase() {
        return this.nameLowerCase;
    }

    public String getRawValue() {
        if (this.rawValue == null && this.parsed != null) {
            StringBuilder s = new StringBuilder();
            this.parsed.values().iterator().next().generate(s, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.rawValue = s.toString();
        }
        return this.rawValue;
    }

    public <T extends HeaderValueFormat> T getValue(Class<T> format) throws Exception {
        HeaderValueFormat t;
        if (this.parsed != null) {
            t = this.parsed.get(format);
            if (t != null) {
                return (T)t;
            }
        } else {
            if (this.rawValue == null) {
                return null;
            }
            this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        }
        t = (HeaderValueFormat)format.newInstance();
        t.parseRawValue(this.rawValue);
        this.parsed.put(format, t);
        return (T)t;
    }

    public void setRawValue(String raw) {
        this.parsed = null;
        this.rawValue = raw;
    }

    public <T extends HeaderValueFormat> void setValue(T value) {
        this.rawValue = null;
        this.parsed = new HashMap<Class<? extends HeaderValueFormat>, HeaderValueFormat>(5);
        this.parsed.put(value.getClass(), value);
    }

    public void appendTo(StringBuilder s) {
        s.append(this.name).append(": ");
        if (this.rawValue == null && this.parsed != null) {
            this.parsed.values().iterator().next().generate(s, 80 - this.name.length() - 2, 79);
        } else {
            s.append(this.rawValue);
        }
        s.append("\r\n");
    }

    public void appendTo(IString s) {
        s.append((CharSequence)this.name).append((CharSequence)": ");
        if (this.rawValue == null && this.parsed != null) {
            this.parsed.values().iterator().next().generate(s, 80 - this.name.length() - 2, 79);
        } else {
            s.append((CharSequence)this.rawValue);
        }
        s.append(MimeMessage.CRLF);
    }
}

