/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer.encoding;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValues;
import net.lecousin.framework.network.mime.transfer.encoding.Base64Decoder;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.GZipDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.IdentityDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.QuotedPrintableDecoder;

public final class ContentDecoderFactory {
    private static Map<String, Constructor<? extends ContentDecoder>> decoders = new HashMap<String, Constructor<? extends ContentDecoder>>();

    private ContentDecoderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoder(String encoding, Class<? extends ContentDecoder> decoderClass) throws NoSuchMethodException {
        encoding = encoding.toLowerCase();
        Constructor<? extends ContentDecoder> ctor = decoderClass == null ? null : decoderClass.getConstructor(ContentDecoder.class);
        Map<String, Constructor<? extends ContentDecoder>> map = decoders;
        synchronized (map) {
            decoders.put(encoding, ctor);
        }
    }

    public static List<String> getSupportedEncoding() {
        return new ArrayList<String>(decoders.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentDecoder createDecoder(ContentDecoder next, String encoding) {
        Logger logger;
        Constructor<? extends ContentDecoder> ctor = null;
        boolean hasDecoder = false;
        String elc = encoding.toLowerCase();
        Map<String, Constructor<? extends ContentDecoder>> map = decoders;
        synchronized (map) {
            if (decoders.containsKey(elc)) {
                hasDecoder = true;
                ctor = decoders.get(elc);
            }
        }
        if (!hasDecoder && (logger = LCCore.getApplication().getLoggerFactory().getLogger(ContentDecoderFactory.class)).error()) {
            logger.error("Content encoding '" + encoding + "' not supported, data may not be readable.");
        }
        if (ctor == null) {
            return next;
        }
        try {
            return ctor.newInstance(next);
        }
        catch (Exception e) {
            Logger logger2 = LCCore.getApplication().getLoggerFactory().getLogger(ContentDecoderFactory.class);
            if (logger2.error()) {
                logger2.error("Content decoder " + ctor.getName() + " cannot be instantiated for encoding '" + encoding + "', data may not be readable.");
            }
            return next;
        }
    }

    public static ContentDecoder createDecoder(IO.Writable out, MimeMessage mime) {
        return ContentDecoderFactory.createDecoder((ContentDecoder)new IdentityDecoder(out), mime);
    }

    public static ContentDecoder createDecoder(ContentDecoder next, MimeMessage mime) {
        String e;
        ParameterizedHeaderValues values;
        LinkedList<String> encoding = new LinkedList<String>();
        try {
            values = mime.getFirstHeaderValue("Content-Transfer-Encoding", ParameterizedHeaderValues.class);
        }
        catch (Exception e2) {
            values = null;
        }
        if (values != null) {
            for (ParameterizedHeaderValue value : values.getValues()) {
                e = value.getMainValue();
                if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
            if (!encoding.isEmpty()) {
                String s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    encoding.removeLast();
                }
            }
        }
        try {
            values = mime.getFirstHeaderValue("Content-Encoding", ParameterizedHeaderValues.class);
        }
        catch (Exception e3) {
            values = null;
        }
        if (values != null) {
            for (ParameterizedHeaderValue value : values.getValues()) {
                e = value.getMainValue();
                if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
        }
        for (String coding : encoding) {
            next = ContentDecoderFactory.createDecoder(next, coding);
        }
        return next;
    }

    static {
        try {
            ContentDecoderFactory.registerDecoder("7bit", null);
            ContentDecoderFactory.registerDecoder("8bit", null);
            ContentDecoderFactory.registerDecoder("identity", null);
            ContentDecoderFactory.registerDecoder("base64", Base64Decoder.class);
            ContentDecoderFactory.registerDecoder("quoted-printable", QuotedPrintableDecoder.class);
            ContentDecoderFactory.registerDecoder("gzip", GZipDecoder.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

