/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.header;

import java.util.List;
import net.lecousin.framework.network.mime.header.parser.MimeHeaderValueParser;
import net.lecousin.framework.network.mime.header.parser.Token;
import net.lecousin.framework.util.IString;

public interface HeaderValueFormat {
    default public void parseRawValue(String raw) throws Exception {
        this.parseTokens(MimeHeaderValueParser.parse(raw));
    }

    public void parseTokens(List<Token> var1) throws Exception;

    public List<Token> generateTokens();

    default public void generate(StringBuilder s, int firstLineMaxLength, int maxSubLineLength) {
        List<Token> tokens = this.generateTokens();
        int lineLength = 0;
        boolean firstLine = true;
        for (Token token : tokens) {
            String ts = token.asText();
            if (firstLine && lineLength + ts.length() > firstLineMaxLength) {
                firstLine = false;
                s.append("\r\n\t");
                lineLength = ts.length();
                s.append(ts);
                continue;
            }
            if (!firstLine && lineLength + ts.length() > maxSubLineLength) {
                s.append("\r\n\t");
                lineLength = ts.length();
                s.append(ts);
                continue;
            }
            lineLength += ts.length();
            s.append(ts);
        }
    }

    default public void generate(IString s, int firstLineMaxLength, int maxSubLineLength) {
        List<Token> tokens = this.generateTokens();
        int lineLength = 0;
        boolean firstLine = true;
        for (Token token : tokens) {
            String ts = token.asText();
            if (firstLine && lineLength + ts.length() > firstLineMaxLength) {
                firstLine = false;
                s.append((CharSequence)"\r\n\t");
                lineLength = ts.length();
                s.append((CharSequence)ts);
                continue;
            }
            if (!firstLine && lineLength + ts.length() > maxSubLineLength) {
                s.append((CharSequence)"\r\n\t");
                lineLength = ts.length();
                s.append((CharSequence)ts);
                continue;
            }
            lineLength += ts.length();
            s.append((CharSequence)ts);
        }
    }
}

