/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFileTask;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.ByteBuffersIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.encoding.QuotedPrintable;
import net.lecousin.framework.network.mime.MimeHeader;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.entity.MultipartEntity;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoderFactory;
import net.lecousin.framework.network.mime.transfer.encoding.IdentityDecoder;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class FormDataEntity
extends MultipartEntity
implements Closeable,
AsyncCloseable<IOException> {
    public FormDataEntity() {
        super("form-data");
    }

    public FormDataEntity(byte[] boundary) {
        super(boundary, "form-data");
    }

    public PartField addField(String name, String value, Charset charset) {
        PartField f = new PartField(name, value, charset);
        this.add(f);
        return f;
    }

    public PartFile addFile(String fieldName, String filename, ParameterizedHeaderValue contentType, IO.Readable content) {
        PartFile f = new PartFile(fieldName, filename, contentType, content);
        this.add(f);
        return f;
    }

    public List<Pair<String, String>> getFields() {
        LinkedList<Pair<String, String>> list = new LinkedList<Pair<String, String>>();
        for (MimeMessage p : this.parts) {
            if (!(p instanceof PartField)) continue;
            list.add((Pair<String, String>)new Pair((Object)((PartField)p).getName(), (Object)((PartField)p).getValue()));
        }
        return list;
    }

    public String getFieldValue(String name) {
        for (MimeMessage p : this.parts) {
            if (!(p instanceof PartField) || !((PartField)p).getName().equals(name)) continue;
            return ((PartField)p).getValue();
        }
        return null;
    }

    public PartFile getFile(String name) {
        for (MimeMessage p : this.parts) {
            if (!(p instanceof PartFile) || !((PartFile)p).getName().equals(name)) continue;
            return (PartFile)p;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        for (MimeMessage p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            try {
                ((PartFile)p).getReadableStream().close();
            }
            catch (Exception e) {
                throw IO.error((Throwable)e);
            }
        }
    }

    public ISynchronizationPoint<IOException> closeAsync() {
        JoinPoint jp = new JoinPoint();
        for (MimeMessage p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            jp.addToJoin(((PartFile)p).getReadableStream().closeAsync());
        }
        jp.start();
        SynchronizationPoint result = new SynchronizationPoint();
        jp.listenInline(() -> {
            if (jp.hasError()) {
                result.error((Exception)IO.error((Throwable)jp.getError()));
            } else {
                result.unblock();
            }
        });
        return result;
    }

    @Override
    protected AsyncWork<MimeMessage, IOException> createPart(List<MimeHeader> headers, IOInMemoryOrFile body, boolean asReceived) {
        try {
            ParameterizedHeaderValue dispo = null;
            for (MimeHeader h : headers) {
                if (!"content-disposition".equals(h.getNameLowerCase())) continue;
                dispo = h.getValue(ParameterizedHeaderValue.class);
                break;
            }
            if (dispo == null) {
                throw new IOException("Missing header Content-Disposition for a form-data entity");
            }
            if (!"form-data".equals(dispo.getMainValue())) {
                throw new IOException("Invalid Content-Disposition: " + dispo.getMainValue() + ", expected is form-data");
            }
            String fieldName = dispo.getParameter("name");
            if (fieldName == null) {
                throw new IOException("Missing parameter 'name' in Content-Disposition");
            }
            String filename = dispo.getParameter("filename");
            ParameterizedHeaderValue type = null;
            for (MimeHeader h : headers) {
                if (!"content-type".equals(h.getNameLowerCase())) continue;
                type = h.getValue(ParameterizedHeaderValue.class);
                break;
            }
            if ((type == null || "text/plain".equals(type.getMainValue())) && body.getSizeSync() < 65536L && filename == null) {
                String s;
                Charset charset = type == null ? StandardCharsets.US_ASCII : ((s = type.getParameter("charset")) == null ? StandardCharsets.US_ASCII : Charset.forName(s));
                ByteBuffersIO out = new ByteBuffersIO(false, "form-data field value", 4);
                ContentDecoder decoder = ContentDecoderFactory.createDecoder((IO.Writable)out, new MimeMessage(headers));
                AsyncWork result = new AsyncWork();
                if (decoder instanceof IdentityDecoder) {
                    FormDataEntity.readField(fieldName, (IO.Readable)body, charset, (AsyncWork<MimeMessage, IOException>)result);
                    out.closeAsync();
                    return result;
                }
                FormDataEntity.decodeField(fieldName, decoder, body, out, charset, (AsyncWork<MimeMessage, IOException>)result);
                return result;
            }
            File tmp = File.createTempFile("formData", "file");
            tmp.deleteOnExit();
            FileIO.ReadWrite io = new FileIO.ReadWrite(tmp, 4);
            ContentDecoder decoder = ContentDecoderFactory.createDecoder((IO.Writable)io, new MimeMessage(headers));
            if (decoder instanceof IdentityDecoder) {
                io.closeAsync().listenInline(() -> new RemoveFileTask(tmp, 6).start());
                return new AsyncWork((Object)new PartFile(fieldName, filename, type, (IO.Readable)body), null);
            }
            AsyncWork result = new AsyncWork();
            FormDataEntity.decodeFile(fieldName, filename, type, (IO.Readable)body, decoder, io, (AsyncWork<MimeMessage, IOException>)result);
            io.addCloseListener(() -> new RemoveFileTask(tmp, 6).start());
            return result;
        }
        catch (Exception e) {
            return new AsyncWork(null, (Exception)IO.error((Throwable)e));
        }
    }

    private static void readField(String fieldName, IO.Readable content, Charset charset, AsyncWork<MimeMessage, IOException> result) {
        AsyncWork read = IOUtil.readFullyAsString((IO.Readable)content, (Charset)charset, (byte)4);
        read.listenInline(() -> {
            if (read.hasError()) {
                result.error(read.getError());
                return;
            }
            result.unblockSuccess((Object)new PartField(fieldName, ((UnprotectedStringBuffer)read.getResult()).asString(), charset));
        });
    }

    private static void decodeField(String fieldName, ContentDecoder decoder, IOInMemoryOrFile encoded, ByteBuffersIO decoded, Charset charset, AsyncWork<MimeMessage, IOException> result) {
        ByteBuffer buf = ByteBuffer.allocate((int)encoded.getSizeSync());
        AsyncWork read = encoded.readFullyAsync(buf);
        read.listenInline(() -> {
            if (read.hasError()) {
                result.error((Exception)new IOException("Error reading value of form-data field " + fieldName, read.getError()));
                return;
            }
            buf.flip();
            ISynchronizationPoint<IOException> decode = decoder.decode(buf);
            decode.listenInline(() -> {
                if (decode.hasError()) {
                    result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, decode.getError()));
                    return;
                }
                ISynchronizationPoint<IOException> end = decoder.endOfData();
                end.listenInline(() -> {
                    if (end.hasError()) {
                        result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, end.getError()));
                        return;
                    }
                    decoded.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
                    FormDataEntity.readField(fieldName, (IO.Readable)decoded, charset, result);
                });
            });
        });
    }

    private static void decodeFile(String fieldName, String filename, ParameterizedHeaderValue contentType, IO.Readable encoded, ContentDecoder decoder, FileIO.ReadWrite file, AsyncWork<MimeMessage, IOException> result) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        AsyncWork read = encoded.readFullyAsync(buf);
        read.listenAsync((Task)new Task.Cpu.FromRunnable("Reading form-data file", 4, () -> {
            if (read.hasError()) {
                result.error((Exception)new IOException("Error reading value of form-data field " + fieldName, read.getError()));
                file.closeAsync();
                return;
            }
            buf.flip();
            ISynchronizationPoint<IOException> decode = decoder.decode(buf);
            decode.listenInline(() -> {
                if (decode.hasError()) {
                    result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, decode.getError()));
                    file.closeAsync();
                    return;
                }
                if ((Integer)read.getResult() < 65536) {
                    ISynchronizationPoint<IOException> end = decoder.endOfData();
                    end.listenInline(() -> {
                        if (end.hasError()) {
                            result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, end.getError()));
                            file.closeAsync();
                            return;
                        }
                        AsyncWork seek = file.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
                        seek.listenInline(() -> {
                            if (seek.hasError()) {
                                result.error(seek.getError());
                                file.closeAsync();
                                return;
                            }
                            result.unblockSuccess((Object)new PartFile(fieldName, filename, contentType, (IO.Readable)file));
                        });
                    });
                    return;
                }
                FormDataEntity.decodeFile(fieldName, filename, contentType, encoded, decoder, file, result);
            });
        }), true);
    }

    public static class PartFile
    extends MimeEntity {
        protected String fieldName;
        protected String filename;

        public PartFile(String fieldName, String filename, ParameterizedHeaderValue contentType, IO.Readable content) {
            this.fieldName = fieldName;
            this.filename = filename;
            this.setBodyToSend(content);
            this.addHeader("Content-Type", contentType);
            ParameterizedHeaderValue dispo = new ParameterizedHeaderValue("form-data", "name", fieldName);
            if (filename != null) {
                dispo.addParameter("filename", filename);
            }
            this.addHeader("Content-Disposition", dispo);
        }

        public String getName() {
            return this.fieldName;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class PartField
    extends MimeEntity {
        protected String name;
        protected String value;
        protected Charset charset;

        public PartField(String name, String value, Charset charset) {
            this.name = name;
            this.value = value;
            this.charset = charset;
            this.addHeader("Content-Disposition", new ParameterizedHeaderValue("form-data", "name", name));
            this.addHeaderRaw("Content-Transfer-Encoding", "quoted-printable");
            this.addHeader("Content-Type", new ParameterizedHeaderValue("text/plain", "charset", charset.name()));
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public IO.Readable getBodyToSend() {
            ByteBuffer content = QuotedPrintable.encode((String)this.value, (Charset)this.charset);
            return new ByteArrayIO(content.array(), content.remaining(), "form-data field content");
        }
    }
}

