/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.encoding.Base64;
import net.lecousin.framework.io.encoding.QuotedPrintable;
import net.lecousin.framework.network.mime.MimeHeader;
import net.lecousin.framework.network.mime.MimeMessage;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoderFactory;

public final class MimeUtil {
    private MimeUtil() {
    }

    public static String decodeRFC2047(String value) throws IOException {
        int pos = 0;
        while (pos < value.length()) {
            int j;
            int i = value.indexOf("=?", pos);
            int i2 = value.indexOf(34, pos);
            if (i2 >= 0 && (i < 0 || i > i2) && (j = value.indexOf(34, i2 + 1)) > 0) {
                value = value.substring(0, i2) + value.substring(i2 + 1, j) + value.substring(j + 1);
                continue;
            }
            if (i < 0 || (j = value.indexOf("?=", i + 2)) < 0) break;
            String decoded = MimeUtil.decodeRFC2047Word(value.substring(i + 2, j));
            value = value.substring(0, i) + decoded + value.substring(j + 2);
            pos = i + decoded.length();
        }
        return value;
    }

    public static String decodeRFC2047Word(String encodedWord) throws UnsupportedEncodingException, IOException {
        int i = encodedWord.indexOf(63);
        if (i < 0) {
            return encodedWord;
        }
        String charsetName = encodedWord.substring(0, i);
        if ((i = (encodedWord = encodedWord.substring(i + 1)).indexOf(63)) < 0) {
            return encodedWord;
        }
        String encoding = encodedWord.substring(0, i);
        encodedWord = encodedWord.substring(i + 1);
        if ("B".equals(encoding = encoding.trim().toUpperCase())) {
            byte[] decoded = Base64.decode((String)encodedWord);
            return new String(decoded, charsetName);
        }
        if ("Q".equals(encoding)) {
            ByteBuffer decoded = QuotedPrintable.decode((String)encodedWord);
            return new String(decoded.array(), 0, decoded.remaining(), charsetName);
        }
        throw new UnsupportedEncodingException("RFC 2047 encoding " + encoding);
    }

    public static String encodeValue(String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        boolean hasSpecialChars = false;
        boolean needsQuote = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 32 || bytes[i] == 9 || bytes[i] == 34) {
                needsQuote = true;
            }
            if (bytes[i] >= 32 && bytes[i] <= 126) continue;
            hasSpecialChars = true;
            break;
        }
        if (!hasSpecialChars) {
            if (!needsQuote) {
                return value;
            }
            return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        StringBuilder s = new StringBuilder(value.length() + 64);
        s.append("=?UTF-8?B?");
        s.append(new String(Base64.encodeBase64((byte[])bytes)));
        s.append("?=");
        return s.toString();
    }

    public static String encodeUTF8Value(String value) {
        return MimeUtil.encodeValue(value, StandardCharsets.UTF_8);
    }

    public static MimeMessage mimeFromString(String content, Charset charset, String contentType) {
        MimeMessage mime = new MimeMessage();
        mime.setHeaderRaw("Content-Type", contentType + ";charset=" + charset.name());
        mime.setBodyToSend((IO.Readable)new ByteArrayIO(content.getBytes(charset), "Mime from string"));
        return mime;
    }

    public static AsyncWork<MimeMessage, IOException> parseMimeMessage(IO.Readable.Buffered input) {
        MessageParser parser = new MessageParser(input);
        return parser.sp;
    }

    private static class MessageParser {
        private IO.Readable.Buffered io;
        private AsyncWork<MimeMessage, IOException> sp = new AsyncWork();
        private MimeMessage mime;
        private HeadersLinesReceiver header;
        private StringBuilder headerLine = new StringBuilder(128);
        private ContentDecoder bodyDecoder = null;

        private MessageParser(IO.Readable.Buffered input) {
            this.io = input;
            this.mime = new MimeMessage();
            this.header = new HeadersLinesReceiver(this.mime.getHeaders());
            this.nextBuffer();
        }

        public void nextBuffer() {
            this.io.readNextBufferAsync().listenInline(buffer -> this.parse((ByteBuffer)buffer), this.sp);
        }

        private void parse(final ByteBuffer buffer) {
            if (this.header == null) {
                if (buffer == null) {
                    this.bodyDecoder.endOfData().listenInline(() -> ((IOInMemoryOrFile)this.mime.getBodyReceivedAsInput()).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L).listenInline(() -> this.sp.unblockSuccess((Object)this.mime), this.sp), this.sp);
                    return;
                }
                this.bodyDecoder.decode(buffer).listenInline(() -> this.nextBuffer(), this.sp);
                return;
            }
            if (buffer == null) {
                this.sp.error((Exception)new EOFException("Unexpected end of MIME message"));
                return;
            }
            new Task.Cpu<Void, NoException>("Parsing MIME Message", this.io.getPriority()){

                public Void run() {
                    while (buffer.hasRemaining()) {
                        byte b = buffer.get();
                        if (b == 10) {
                            String line = headerLine.length() > 0 && headerLine.charAt(headerLine.length() - 1) == '\r' ? headerLine.substring(0, headerLine.length() - 1) : headerLine.toString();
                            try {
                                header.newLine(line);
                            }
                            catch (Exception e) {
                                sp.error((Exception)IO.error((Throwable)e));
                                return null;
                            }
                            if (line.length() == 0) {
                                headerLine = null;
                                this.setBody(buffer);
                                return null;
                            }
                            headerLine = new StringBuilder(128);
                            continue;
                        }
                        headerLine.append((char)b);
                    }
                    this.nextBuffer();
                    return null;
                }
            }.start();
        }

        private void setBody(ByteBuffer buffer) {
            IOInMemoryOrFile body = new IOInMemoryOrFile(65536, this.io.getPriority(), "MIME body from " + this.io.getSourceDescription());
            this.bodyDecoder = ContentDecoderFactory.createDecoder((IO.Writable)body, this.mime);
            this.mime.setBodyReceived(body);
            this.header = null;
            this.parse(buffer);
        }
    }

    public static class HeadersLinesReceiver {
        private List<MimeHeader> headers;
        private String currentName;
        private StringBuilder currentValue;

        public HeadersLinesReceiver(List<MimeHeader> headers) {
            this.headers = headers;
        }

        public List<MimeHeader> getHeaders() {
            return this.headers;
        }

        public void newLine(CharSequence line) throws Exception {
            int i;
            if (line.length() == 0) {
                if (this.currentName != null) {
                    this.headers.add(new MimeHeader(this.currentName, this.currentValue.toString()));
                    this.currentName = null;
                    this.currentValue = null;
                }
                return;
            }
            char c = line.charAt(0);
            if (c == ' ' || c == '\t') {
                if (this.currentName == null) {
                    throw new Exception("Invalid Mime header first line: cannot start with a space");
                }
                this.currentValue.append(line.subSequence(1, line.length()));
                return;
            }
            if (c == ':') {
                throw new Exception("Invalid Mime header: no header name");
            }
            int l = line.length();
            for (i = 1; i < l && line.charAt(i) != ':'; ++i) {
            }
            if (i == l) {
                throw new Exception("Invalid Mime header line: <" + line + ">");
            }
            if (this.currentName != null) {
                this.headers.add(new MimeHeader(this.currentName, this.currentValue.toString()));
            }
            this.currentName = line.subSequence(0, i).toString().trim();
            while (++i < l && ((c = line.charAt(i)) == ' ' || c == '\t')) {
            }
            this.currentValue = i >= l ? new StringBuilder(128) : new StringBuilder(line.subSequence(i, l));
        }
    }
}

