/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.LinkedIO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.network.TCPRemote;
import net.lecousin.framework.network.client.TCPClient;
import net.lecousin.framework.network.mime.MimeHeader;
import net.lecousin.framework.network.mime.MimeUtil;
import net.lecousin.framework.network.mime.header.HeaderValueFormat;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValues;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.network.mime.transfer.IdentityTransfer;
import net.lecousin.framework.util.IString;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class MimeMessage {
    private Logger logger = LCCore.getApplication().getLoggerFactory().getLogger(MimeMessage.class);
    private LinkedArrayList<MimeHeader> headers = new LinkedArrayList(10);
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONNECTION = "Connection";
    private IO.Writable bodyReceived = null;
    private IO.Readable bodyToSend = null;

    public MimeMessage() {
    }

    public MimeMessage(List<MimeHeader> headers) {
        this.headers.addAll(headers);
    }

    public MimeMessage(MimeHeader ... headers) {
        for (MimeHeader h : headers) {
            this.headers.add((Object)h);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<MimeHeader> getHeaders() {
        return this.headers;
    }

    public List<MimeHeader> getHeaders(String name) {
        name = name.toLowerCase();
        ArrayList<MimeHeader> list = new ArrayList<MimeHeader>();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            list.add(h);
        }
        return list;
    }

    public <T extends HeaderValueFormat> List<T> getHeadersValues(String name, Class<T> format) throws Exception {
        LinkedList<T> list = new LinkedList<T>();
        name = name.toLowerCase();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            list.add(h.getValue(format));
        }
        return list;
    }

    public MimeHeader getFirstHeader(String name) {
        name = name.toLowerCase();
        for (MimeHeader h : this.headers) {
            if (!h.getNameLowerCase().equals(name)) continue;
            return h;
        }
        return null;
    }

    public <T extends HeaderValueFormat> T getFirstHeaderValue(String name, Class<T> format) throws Exception {
        MimeHeader h = this.getFirstHeader(name);
        if (h == null) {
            return null;
        }
        return h.getValue(format);
    }

    public String getFirstHeaderRawValue(String name) {
        MimeHeader h = this.getFirstHeader(name);
        if (h == null) {
            return null;
        }
        return h.getRawValue();
    }

    public Long getFirstHeaderLongValue(String name) {
        MimeHeader h = this.getFirstHeader(name);
        if (h == null) {
            return null;
        }
        try {
            return Long.valueOf(h.getRawValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasHeader(String name) {
        return this.getFirstHeader(name) != null;
    }

    public void addHeaderRaw(String name, String rawValue) {
        this.headers.add((Object)new MimeHeader(name, rawValue));
    }

    public void addHeader(String name, HeaderValueFormat value) {
        this.headers.add((Object)new MimeHeader(name, value));
    }

    public void addHeader(MimeHeader header) {
        this.headers.add((Object)header);
    }

    public void setHeaderRaw(String name, String rawValue) {
        this.removeHeaders(name);
        this.addHeaderRaw(name, rawValue);
    }

    public void setHeader(String name, HeaderValueFormat value) {
        this.removeHeaders(name);
        this.addHeader(name, value);
    }

    public void setHeader(MimeHeader header) {
        this.removeHeaders(header.getName());
        this.addHeader(header);
    }

    public void removeHeaders(String name) {
        name = name.toLowerCase();
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            if (!((MimeHeader)it.next()).getNameLowerCase().equals(name)) continue;
            it.remove();
        }
    }

    public void appendHeadersTo(StringBuilder s) {
        for (MimeHeader h : this.headers) {
            h.appendTo(s);
        }
    }

    public void appendHeadersTo(IString s) {
        for (MimeHeader h : this.headers) {
            h.appendTo(s);
        }
    }

    public Long getContentLength() {
        return this.getFirstHeaderLongValue(CONTENT_LENGTH);
    }

    public void setContentLength(long size) {
        this.setHeaderRaw(CONTENT_LENGTH, Long.toString(size));
    }

    public ParameterizedHeaderValue getContentType() throws Exception {
        return this.getFirstHeaderValue(CONTENT_TYPE, ParameterizedHeaderValue.class);
    }

    public String getContentTypeValue() {
        try {
            ParameterizedHeaderValue h = this.getContentType();
            if (h == null) {
                return null;
            }
            return h.getMainValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends IO.Writable & IO.Readable> void setBodyReceived(T output) {
        this.bodyReceived = output;
    }

    public IO.Writable getBodyReceivedAsOutput() {
        return this.bodyReceived;
    }

    public IO.Readable getBodyReceivedAsInput() {
        return (IO.Readable)this.bodyReceived;
    }

    public IO.Readable getBodyToSend() {
        return this.bodyToSend;
    }

    public void setBodyToSend(IO.Readable body) {
        this.bodyToSend = body;
    }

    public IO.Readable getReadableStream() {
        UnprotectedStringBuffer s = new UnprotectedStringBuffer(new UnprotectedString(512));
        this.appendHeadersTo((IString)s);
        s.append((CharSequence)"\r\n");
        ByteArrayIO headers = new ByteArrayIO(s.toUsAsciiBytes(), "Mime Headers");
        IO.Readable body = this.getBodyToSend();
        if (body == null) {
            return headers;
        }
        if (body instanceof IO.Readable.Buffered) {
            if (body instanceof IO.KnownSize) {
                return new LinkedIO.Readable.Buffered.DeterminedSize("Mime Message", new IO.Readable.Buffered[]{headers, (IO.Readable.Buffered)body});
            }
            return new LinkedIO.Readable.Buffered("Mime Message", new IO.Readable.Buffered[]{headers, (IO.Readable.Buffered)body});
        }
        if (body instanceof IO.KnownSize) {
            return new LinkedIO.Readable.DeterminedSize("Mime Message", new IO.Readable[]{headers, body});
        }
        return new LinkedIO.Readable("Mime Message", new IO.Readable[]{headers, body});
    }

    public SynchronizationPoint<IOException> readHeader(TCPClient client, int timeout) {
        SynchronizationPoint result = new SynchronizationPoint();
        if (this.logger.debug()) {
            this.logger.debug("Receiving header lines...");
        }
        MimeUtil.HeadersLinesReceiver linesReceiver = new MimeUtil.HeadersLinesReceiver((List<MimeHeader>)this.headers);
        AsyncWork readLine = client.getReceiver().readUntil((byte)10, 1024, timeout);
        readLine.listenInline((AsyncWork.AsyncWorkListener)new AsyncWork.AsyncWorkListenerReady((line, that) -> {
            int i;
            String s = line.getAsString(StandardCharsets.US_ASCII);
            if (this.logger.debug()) {
                this.logger.debug("Header line received: " + s);
            }
            if ((i = s.indexOf(13)) >= 0) {
                s = s.substring(0, i);
            }
            if ((i = s.indexOf(10)) >= 0) {
                s = s.substring(0, i);
            }
            try {
                linesReceiver.newLine(s);
            }
            catch (Exception e) {
                result.error((Exception)IO.error((Throwable)e));
                return;
            }
            if (s.length() == 0) {
                if (this.logger.debug()) {
                    this.logger.debug("End of header lines");
                }
                result.unblock();
                return;
            }
            client.getReceiver().readUntil((byte)10, 1024, timeout).listenInline((AsyncWork.AsyncWorkListener)that);
        }, (ISynchronizationPoint)result));
        return result;
    }

    public ISynchronizationPoint<IOException> send(TCPRemote remote) {
        ParameterizedHeaderValues transferEncoding;
        IO.Readable body = this.getBodyToSend();
        if (body == null) {
            if (this.logger.debug()) {
                this.logger.debug("Sending headers without body to " + remote);
            }
            this.setContentLength(0L);
            UnprotectedStringBuffer s = new UnprotectedStringBuffer(new UnprotectedString(512));
            this.appendHeadersTo((IString)s);
            s.append((CharSequence)"\r\n");
            byte[] headers = s.toUsAsciiBytes();
            return remote.send(ByteBuffer.wrap(headers));
        }
        try {
            transferEncoding = this.getFirstHeaderValue(TRANSFER_ENCODING, ParameterizedHeaderValues.class);
        }
        catch (Exception e) {
            transferEncoding = null;
        }
        if (body instanceof IO.KnownSize && (transferEncoding == null || !transferEncoding.hasMainValue("chunked"))) {
            SynchronizationPoint sp = new SynchronizationPoint();
            ((IO.KnownSize)body).getSizeAsync().listenInline(size -> new Task.Cpu.FromRunnable("Send MIME to " + remote, body.getPriority(), () -> {
                if (this.logger.debug()) {
                    this.logger.debug("Sending headers with body of " + size + " to " + remote);
                }
                this.setContentLength((long)size);
                UnprotectedStringBuffer s = new UnprotectedStringBuffer(new UnprotectedString(512));
                this.appendHeadersTo((IString)s);
                s.append((CharSequence)"\r\n");
                byte[] headers = s.toUsAsciiBytes();
                ISynchronizationPoint sendHeaders = remote.send(ByteBuffer.wrap(headers));
                sendHeaders.listenInline(() -> {
                    if (body instanceof IO.Readable.Buffered) {
                        IdentityTransfer.send(remote, (IO.Readable.Buffered)body).listenInline(sp);
                    } else {
                        IdentityTransfer.send(remote, body, 65536, 3).listenInline(sp);
                    }
                }, (ISynchronizationPoint)sp);
            }).start(), (ISynchronizationPoint)sp);
            return sp;
        }
        if (this.logger.debug()) {
            this.logger.debug("Sending headers with chunked body to " + remote);
        }
        this.setHeaderRaw(TRANSFER_ENCODING, "chunked");
        this.removeHeaders(CONTENT_LENGTH);
        UnprotectedStringBuffer s = new UnprotectedStringBuffer(new UnprotectedString(512));
        this.appendHeadersTo((IString)s);
        s.append((CharSequence)"\r\n");
        byte[] headers = s.toUsAsciiBytes();
        ISynchronizationPoint sendHeaders = remote.send(ByteBuffer.wrap(headers));
        SynchronizationPoint sp = new SynchronizationPoint();
        sendHeaders.listenInline(() -> {
            if (body instanceof IO.Readable.Buffered) {
                ChunkedTransfer.send(remote, (IO.Readable.Buffered)body).listenInline(sp);
            } else {
                ChunkedTransfer.send(remote, body, 65536, 3).listenInline(sp);
            }
        }, (ISynchronizationPoint)sp);
        return sp;
    }
}

