/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.compression.gzip.GZipReadable;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.out2in.OutputToInputBuffers;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;

public class GZipDecoder
implements ContentDecoder {
    private ContentDecoder next;
    private OutputToInputBuffers tmpIO;
    private GZipReadable gzip;
    private SynchronizationPoint<IOException> done = new SynchronizationPoint();

    public GZipDecoder(ContentDecoder next) {
        this.next = next;
        this.tmpIO = new OutputToInputBuffers(true, 4, 4);
        this.gzip = new GZipReadable((IO.Readable.Buffered)this.tmpIO, 4);
        this.unzip(null);
    }

    @Override
    public ISynchronizationPoint<IOException> decode(ByteBuffer data) {
        if (this.done.isUnblocked()) {
            return this.done;
        }
        return this.tmpIO.writeAsync(data);
    }

    @Override
    public ISynchronizationPoint<IOException> endOfData() {
        this.tmpIO.endOfData();
        this.done.listenInline(() -> {
            this.tmpIO.closeAsync();
            this.gzip.closeAsync();
        });
        return this.done;
    }

    private void unzip(ISynchronizationPoint<IOException> previous) {
        final ByteBuffer buffer = ByteBuffer.allocate(8192);
        final AsyncWork unzip = this.gzip.readAsync(buffer);
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Transfer unzipped data to next content decoder", 4){

            public Void run() {
                if (unzip.hasError()) {
                    GZipDecoder.this.done.error(unzip.getError());
                } else if (unzip.isCancelled()) {
                    GZipDecoder.this.done.cancel(unzip.getCancelEvent());
                } else {
                    int nb = (Integer)unzip.getResult();
                    if (nb <= 0) {
                        GZipDecoder.this.next.endOfData().listenInline(GZipDecoder.this.done);
                    } else {
                        buffer.flip();
                        GZipDecoder.this.unzip((ISynchronizationPoint<IOException>)GZipDecoder.this.next.decode(buffer));
                    }
                }
                return null;
            }
        };
        if (previous == null) {
            unzip.listenAsync((Task)task, true);
        } else {
            previous.listenInline(() -> GZipDecoder.lambda$unzip$1(unzip, (Task.Cpu)task));
        }
    }

    private static /* synthetic */ void lambda$unzip$1(AsyncWork unzip, Task.Cpu task) {
        unzip.listenAsync((Task)task, true);
    }
}

