/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.encoding.Base64;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;

public class Base64Decoder
implements ContentDecoder {
    private ContentDecoder next;
    private byte[] bufIn = new byte[4];
    private int inPos = 0;
    private SynchronizationPoint<IOException> lastDecode = null;

    public Base64Decoder(ContentDecoder next) {
        this.next = next;
    }

    @Override
    public ISynchronizationPoint<IOException> decode(final ByteBuffer data) {
        final SynchronizationPoint decode = new SynchronizationPoint();
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Decoding Base64 data", 4){

            public Void run() throws IOException {
                byte[] decoded = new byte[data.remaining() * 3 / 4 + 3];
                int decodedPos = 0;
                try {
                    while (data.hasRemaining()) {
                        int l = 4 - Base64Decoder.this.inPos;
                        if (l > data.remaining()) {
                            l = data.remaining();
                        }
                        data.get(Base64Decoder.this.bufIn, Base64Decoder.this.inPos, l);
                        Base64Decoder.this.inPos = Base64Decoder.this.inPos + l;
                        if (Base64Decoder.this.inPos != 4) continue;
                        int nb = Base64.decode4BytesBase64((byte[])Base64Decoder.this.bufIn, (byte[])decoded, (int)decodedPos);
                        decodedPos += nb;
                        Base64Decoder.this.inPos = 0;
                    }
                }
                catch (Exception e) {
                    throw IO.error((Throwable)e);
                }
                ISynchronizationPoint<IOException> write = Base64Decoder.this.next.decode(ByteBuffer.wrap(decoded, 0, decodedPos));
                write.listenInline(() -> {
                    if (write.hasError()) {
                        decode.error(write.getError());
                    } else if (write.isCancelled()) {
                        decode.cancel(write.getCancelEvent());
                    } else {
                        decode.unblock();
                    }
                });
                return null;
            }
        };
        if (this.lastDecode == null) {
            this.lastDecode = decode;
            task.start();
            return decode;
        }
        SynchronizationPoint<IOException> previous = this.lastDecode;
        this.lastDecode = decode;
        previous.listenInline(() -> Base64Decoder.lambda$decode$0(previous, decode, (Task.Cpu)task));
        return decode;
    }

    @Override
    public ISynchronizationPoint<IOException> endOfData() {
        return this.next.endOfData();
    }

    private static /* synthetic */ void lambda$decode$0(SynchronizationPoint previous, SynchronizationPoint decode, Task.Cpu task) {
        if (previous.hasError()) {
            decode.error(decode.getError());
        } else if (previous.isCancelled()) {
            decode.cancel(decode.getCancelEvent());
        } else {
            task.start();
        }
    }
}

