/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.network.mime.MIME;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.network.mime.transfer.IdentityTransfer;
import net.lecousin.framework.network.mime.transfer.TransferReceiver;
import net.lecousin.framework.network.mime.transfer.encoding.Base64Decoder;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.GZipDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.IdentityDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.QuotedPrintableDecoder;

public final class TransferEncodingFactory {
    private static Map<String, Constructor<? extends ContentDecoder>> decoders = new HashMap<String, Constructor<? extends ContentDecoder>>();

    private TransferEncodingFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoder(String encoding, Class<? extends ContentDecoder> decoderClass) throws NoSuchMethodException {
        encoding = encoding.toLowerCase();
        Constructor<? extends ContentDecoder> ctor = decoderClass == null ? null : decoderClass.getConstructor(ContentDecoder.class);
        Map<String, Constructor<? extends ContentDecoder>> map = decoders;
        synchronized (map) {
            decoders.put(encoding, ctor);
        }
    }

    public static TransferReceiver create(MIME mime, IO.Writable out) throws IOException {
        String[] list;
        String transfer = "identity";
        LinkedList<String> encoding = new LinkedList<String>();
        String s = mime.getHeaderSingleValue("Transfer-Encoding");
        if (s != null) {
            list = s.split(",");
            for (String string : list) {
                String string2 = string.trim().toLowerCase();
                if (string2.isEmpty()) continue;
                encoding.add(string2);
            }
            if (!encoding.isEmpty()) {
                s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    transfer = s;
                    encoding.removeLast();
                }
            }
        }
        if ((s = mime.getHeaderSingleValue("Content-Transfer-Encoding")) != null) {
            list = s.split(",");
            for (String string : list) {
                String string3 = string.trim().toLowerCase();
                if (string3.isEmpty()) continue;
                encoding.add(string3);
            }
            if (!encoding.isEmpty()) {
                s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    transfer = s;
                    encoding.removeLast();
                }
            }
        }
        if ((s = mime.getHeaderSingleValue("Content-Encoding")) != null) {
            list = s.split(",");
            for (String string : list) {
                String string4 = string.trim().toLowerCase();
                if (string4.isEmpty()) continue;
                encoding.add(string4);
            }
        }
        ContentDecoder decoder = new IdentityDecoder(out);
        for (String string : encoding) {
            decoder = TransferEncodingFactory.createDecoder(decoder, string);
        }
        if ("chunked".equals(transfer)) {
            return new ChunkedTransfer(mime, decoder);
        }
        return new IdentityTransfer(mime, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentDecoder createDecoder(ContentDecoder next, String encoding) {
        Constructor<? extends ContentDecoder> ctor = null;
        boolean hasDecoder = false;
        String elc = encoding.toLowerCase();
        Map<String, Constructor<? extends ContentDecoder>> map = decoders;
        synchronized (map) {
            if (decoders.containsKey(elc)) {
                hasDecoder = true;
                ctor = decoders.get(elc);
            }
        }
        if (!hasDecoder && MIME.logger.isErrorEnabled()) {
            MIME.logger.error((Object)("Content encoding '" + encoding + "' not supported, data may not be readable."));
        }
        if (ctor == null) {
            return next;
        }
        try {
            return ctor.newInstance(next);
        }
        catch (Exception e) {
            if (MIME.logger.isErrorEnabled()) {
                MIME.logger.error((Object)("Content decoder " + ctor.getName() + " cannot be instantiated for encoding '" + encoding + "', data may not be readable."));
            }
            return next;
        }
    }

    public static ContentDecoder createDecoder(ContentDecoder next, MIME mime) {
        String[] list;
        LinkedList<String> encoding = new LinkedList<String>();
        String s = mime.getHeaderSingleValue("Content-Transfer-Encoding");
        if (s != null) {
            for (String e : list = s.split(",")) {
                if ((e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
            if (!encoding.isEmpty()) {
                s = (String)encoding.getLast();
                if ("identity".equals(s)) {
                    encoding.removeLast();
                } else if ("chunked".equals(s)) {
                    encoding.removeLast();
                }
            }
        }
        if ((s = mime.getHeaderSingleValue("Content-Encoding")) != null) {
            for (String e : list = s.split(",")) {
                if ((e = e.trim().toLowerCase()).isEmpty()) continue;
                encoding.add(e);
            }
        }
        for (String coding : encoding) {
            next = TransferEncodingFactory.createDecoder(next, coding);
        }
        return next;
    }

    static {
        try {
            TransferEncodingFactory.registerDecoder("7bit", null);
            TransferEncodingFactory.registerDecoder("8bit", null);
            TransferEncodingFactory.registerDecoder("identity", null);
            TransferEncodingFactory.registerDecoder("base64", Base64Decoder.class);
            TransferEncodingFactory.registerDecoder("quoted-printable", QuotedPrintableDecoder.class);
            TransferEncodingFactory.registerDecoder("gzip", GZipDecoder.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

