/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.util.production.simple.Consumer;
import net.lecousin.framework.concurrent.util.production.simple.Producer;
import net.lecousin.framework.concurrent.util.production.simple.Production;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.util.IOReaderAsProducer;
import net.lecousin.framework.network.TCPRemote;
import net.lecousin.framework.network.mime.MIME;
import net.lecousin.framework.network.mime.transfer.TransferReceiver;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.util.StringUtil;

public class ChunkedTransfer
extends TransferReceiver {
    public static final byte[] FINAL_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private boolean needSize = true;
    private boolean chunkSizeDone = false;
    private boolean chunkExtension = false;
    private long chunkSize = -1L;
    private long chunkUsed = 0L;
    private int chunkSizeChars = 0;

    public ChunkedTransfer(MIME mime, ContentDecoder decoder) {
        super(mime, decoder);
    }

    @Override
    public AsyncWork<Boolean, IOException> consume(ByteBuffer buf) {
        AsyncWork result = new AsyncWork();
        ChunkConsumer task = new ChunkConsumer(buf, result);
        task.start();
        return result;
    }

    @Override
    public boolean isExpectingData() {
        return true;
    }

    public static SynchronizationPoint<IOException> send(final TCPRemote client, IO.Readable data, int bufferSize, int maxBuffers) {
        final SynchronizationPoint result = new SynchronizationPoint();
        final Production production = new Production((Producer)new IOReaderAsProducer(data, bufferSize), maxBuffers, (Consumer)new Consumer<ByteBuffer>(){

            public AsyncWork<Void, IOException> consume(ByteBuffer product) {
                if (!product.hasRemaining()) {
                    return new AsyncWork(null, null);
                }
                int size = product.remaining();
                if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)("ChunkedTransfer.send from Readable: send chunk of " + size));
                }
                ByteBuffer header = ByteBuffer.wrap((Integer.toHexString(size) + "\r\n").getBytes(StandardCharsets.US_ASCII));
                ISynchronizationPoint sendHeader = client.send(header);
                ISynchronizationPoint sendProduct = client.send(product);
                ISynchronizationPoint sendEndOfChunk = client.send(ByteBuffer.wrap(MIME.CRLF));
                AsyncWork chunk = new AsyncWork();
                sendEndOfChunk.listenInline(() -> {
                    if (sendHeader.hasError()) {
                        chunk.error(sendHeader.getError());
                    } else if (sendHeader.isCancelled()) {
                        chunk.cancel(sendHeader.getCancelEvent());
                    } else if (sendProduct.hasError()) {
                        chunk.error(sendProduct.getError());
                    } else if (sendProduct.isCancelled()) {
                        chunk.cancel(sendProduct.getCancelEvent());
                    } else if (sendEndOfChunk.hasError()) {
                        chunk.error(sendEndOfChunk.getError());
                    } else if (sendEndOfChunk.isCancelled()) {
                        chunk.cancel(sendEndOfChunk.getCancelEvent());
                    } else {
                        chunk.unblockSuccess(null);
                    }
                });
                return chunk;
            }

            public AsyncWork<Void, IOException> endOfProduction() {
                if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)"ChunkedTransfer.send from Readable: send final chunk");
                }
                ISynchronizationPoint finalChunk = client.send(ByteBuffer.wrap(FINAL_CHUNK));
                AsyncWork end = new AsyncWork();
                finalChunk.listenInline(() -> {
                    if (finalChunk.hasError()) {
                        end.error(finalChunk.getError());
                        result.error(finalChunk.getError());
                    } else if (finalChunk.isCancelled()) {
                        end.cancel(finalChunk.getCancelEvent());
                        result.cancel(finalChunk.getCancelEvent());
                    } else {
                        end.unblockSuccess(null);
                        result.unblock();
                    }
                });
                return end;
            }

            public void error(Exception error) {
                result.error((Exception)IO.error((Throwable)error));
            }

            public void cancel(CancelException event) {
                result.cancel(event);
            }
        });
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Sending chunked body", 4){

            public Void run() {
                production.start();
                production.getSyncOnFinished().listenInline((AsyncWork.AsyncWorkListener)new AsyncWork.AsyncWorkListener<Void, Exception>(){

                    public void ready(Void r) {
                        result.unblock();
                    }

                    public void error(Exception error) {
                        result.error((Exception)IO.error((Throwable)error));
                    }

                    public void cancelled(CancelException event) {
                        result.cancel(event);
                    }
                });
                return null;
            }
        };
        task.start();
        return result;
    }

    public static SynchronizationPoint<IOException> send(TCPRemote client, IO.Readable.Buffered data) {
        SynchronizationPoint result = new SynchronizationPoint();
        byte[] chunkHeader = new byte[10];
        chunkHeader[8] = 13;
        chunkHeader[9] = 10;
        ChunkedTransfer.sendNextBuffer(client, data, (SynchronizationPoint<IOException>)result, chunkHeader);
        return result;
    }

    private static void sendNextBuffer(final TCPRemote client, final IO.Readable.Buffered data, final SynchronizationPoint<IOException> result, final byte[] chunkHeader) {
        data.readNextBufferAsync().listenInline(buffer -> {
            if (buffer == null) {
                if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)("ChunkedTransfer.send from Buffered: Send final chunk to " + client));
                }
                ISynchronizationPoint finalChunk = client.send(ByteBuffer.wrap(FINAL_CHUNK));
                finalChunk.listenInline(result);
                return;
            }
            new Task.Cpu<Void, NoException>("Send chunk of data to TCP Client", data.getPriority()){

                public Void run() {
                    int size = buffer.remaining();
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)("ChunkedTransfer.send from Buffered: Send chunk of " + size + " bytes to " + client));
                    }
                    chunkHeader[0] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF0000000) >> 28));
                    chunkHeader[1] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF000000) >> 24));
                    chunkHeader[2] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF00000) >> 20));
                    chunkHeader[3] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF0000) >> 16));
                    chunkHeader[4] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF000) >> 12));
                    chunkHeader[5] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF00) >> 8));
                    chunkHeader[6] = (byte)StringUtil.encodeHexaDigit((int)((size & 0xF0) >> 4));
                    chunkHeader[7] = (byte)StringUtil.encodeHexaDigit((int)(size & 0xF));
                    ISynchronizationPoint sendHeader = client.send(ByteBuffer.wrap(chunkHeader));
                    ISynchronizationPoint sendProduct = client.send(buffer);
                    ISynchronizationPoint sendEndOfChunk = client.send(ByteBuffer.wrap(MIME.CRLF));
                    JoinPoint.fromSynchronizationPointsSimilarError((ISynchronizationPoint[])new ISynchronizationPoint[]{sendHeader, sendProduct, sendEndOfChunk}).listenInline(() -> ChunkedTransfer.sendNextBuffer(client, data, (SynchronizationPoint<IOException>)result, chunkHeader), (ISynchronizationPoint)result);
                    return null;
                }
            }.start();
        }, result);
    }

    private class ChunkConsumer
    extends Task.Cpu<Void, NoException> {
        private ByteBuffer buf;
        private AsyncWork<Boolean, IOException> ondone;

        private ChunkConsumer(ByteBuffer buf, AsyncWork<Boolean, IOException> ondone) {
            super("Reading chunk of data", (byte)4);
            this.buf = buf;
            this.ondone = ondone;
        }

        public Void run() {
            while (true) {
                if (!this.buf.hasRemaining()) {
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)"End of chunck data consumed, wait for more data");
                    }
                    this.ondone.unblockSuccess((Object)Boolean.FALSE);
                    return null;
                }
                if (!ChunkedTransfer.this.needSize) break;
                int i = this.buf.get() & 0xFF;
                if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)("Chunk size character: " + (char)i + " (" + i + "), so far size is: " + ChunkedTransfer.this.chunkSize));
                }
                if (ChunkedTransfer.this.chunkSizeChars == 8 && i == 10) {
                    ChunkedTransfer.this.needSize = false;
                    ChunkedTransfer.this.chunkSizeDone = false;
                    ChunkedTransfer.this.chunkExtension = false;
                    if (ChunkedTransfer.this.chunkSize != 0L) continue;
                    ChunkedTransfer.this.decoder.endOfData().listenInline(() -> this.ondone.unblockSuccess((Object)Boolean.TRUE), this.ondone);
                    return null;
                }
                if (ChunkedTransfer.this.chunkSize < 0L && (i == 13 || i == 10)) continue;
                if (i == 59) {
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)"Start chunk extension");
                    }
                    ChunkedTransfer.this.chunkSizeDone = true;
                    ChunkedTransfer.this.chunkExtension = true;
                    continue;
                }
                if (i == 10) {
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)("End of chunk line, chunk size is " + ChunkedTransfer.this.chunkSize));
                    }
                    ChunkedTransfer.this.needSize = false;
                    ChunkedTransfer.this.chunkSizeDone = false;
                    ChunkedTransfer.this.chunkExtension = false;
                    if (ChunkedTransfer.this.chunkSize != 0L) continue;
                    ChunkedTransfer.this.decoder.endOfData().listenInline(() -> this.ondone.unblockSuccess((Object)Boolean.TRUE), this.ondone);
                    return null;
                }
                if (ChunkedTransfer.this.chunkExtension || ChunkedTransfer.this.chunkSizeDone) continue;
                if (i == 13 || i == 32) {
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)"end of chunk size, wait for end of line");
                    }
                    ChunkedTransfer.this.chunkSizeDone = true;
                    continue;
                }
                int isize = StringUtil.decodeHexa((char)((char)i));
                if (isize == -1) {
                    if (MIME.logger.isErrorEnabled()) {
                        MIME.logger.error((Object)("Invalid chunk size: character '" + (char)i + "' is not a valid hexadecimal character."));
                    }
                    this.ondone.unblockError((Exception)new IOException("Invalid chunk size"));
                    return null;
                }
                if (ChunkedTransfer.this.chunkSize < 0L) {
                    ChunkedTransfer.this.chunkSize = isize;
                } else {
                    ChunkedTransfer.this.chunkSize = (ChunkedTransfer.this.chunkSize << 4) + (long)isize;
                }
                ChunkedTransfer.this.chunkSizeChars++;
            }
            int l = this.buf.remaining();
            if ((long)l > ChunkedTransfer.this.chunkSize - ChunkedTransfer.this.chunkUsed) {
                int nb = (int)(ChunkedTransfer.this.chunkSize - ChunkedTransfer.this.chunkUsed);
                final int limit = this.buf.limit();
                this.buf.limit(this.buf.position() + nb);
                ChunkedTransfer.this.chunkUsed = ChunkedTransfer.this.chunkUsed + (long)nb;
                if (ChunkedTransfer.this.chunkUsed == ChunkedTransfer.this.chunkSize) {
                    ChunkedTransfer.this.needSize = true;
                    ChunkedTransfer.this.chunkSize = -1L;
                    ChunkedTransfer.this.chunkSizeChars = 0;
                    ChunkedTransfer.this.chunkUsed = 0L;
                }
                if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)("Consume end of chunk: " + nb + " bytes, data still available after"));
                }
                final ISynchronizationPoint<IOException> decode = ChunkedTransfer.this.decoder.decode(this.buf);
                decode.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        ChunkConsumer.this.buf.limit(limit);
                        if (decode.isSuccessful()) {
                            new ChunkConsumer(ChunkConsumer.this.buf, ChunkConsumer.this.ondone).start();
                        } else {
                            ChunkConsumer.this.ondone.unblockError((Exception)IO.error((Throwable)decode.getError()));
                        }
                    }
                });
            } else {
                ChunkedTransfer.this.chunkUsed = ChunkedTransfer.this.chunkUsed + (long)l;
                if (ChunkedTransfer.this.chunkUsed == ChunkedTransfer.this.chunkSize) {
                    if (MIME.logger.isTraceEnabled()) {
                        MIME.logger.trace((Object)("Consume end of chunk: " + l + " bytes, no more data available"));
                    }
                    ChunkedTransfer.this.needSize = true;
                    ChunkedTransfer.this.chunkSize = -1L;
                    ChunkedTransfer.this.chunkSizeChars = 0;
                    ChunkedTransfer.this.chunkUsed = 0L;
                } else if (MIME.logger.isTraceEnabled()) {
                    MIME.logger.trace((Object)("Consume part of chunk: " + l + " bytes, " + ChunkedTransfer.this.chunkUsed + "/" + ChunkedTransfer.this.chunkSize + " consumed so far, no more data available"));
                }
                final ISynchronizationPoint<IOException> decode = ChunkedTransfer.this.decoder.decode(this.buf);
                decode.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (decode.isSuccessful()) {
                            ChunkConsumer.this.ondone.unblockSuccess((Object)Boolean.FALSE);
                        } else {
                            ChunkConsumer.this.ondone.unblockError((Exception)IO.error((Throwable)decode.getError()));
                        }
                    }
                });
            }
            return null;
        }
    }
}

