/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.LinkedIO;
import net.lecousin.framework.io.SubIO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.network.mime.MIME;
import net.lecousin.framework.network.mime.entity.GenericMimeEntity;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.util.Pair;

public class MultipartEntity
implements MimeEntity {
    private static int counter = 0;
    private static final Random random = new Random();
    protected String subType;
    protected byte[] boundary;
    protected LinkedList<MimeEntity> parts = new LinkedList();
    protected List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MultipartEntity(byte[] boundary, String subType) {
        this.boundary = boundary;
        this.subType = subType;
    }

    public MultipartEntity(String subType) {
        this(MultipartEntity.generateBoundary(), subType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] generateBoundary() {
        long rand;
        int count;
        Random random = MultipartEntity.random;
        synchronized (random) {
            count = counter++;
            rand = MultipartEntity.random.nextLong();
        }
        long timestamp = System.currentTimeMillis();
        byte[] boundary = new byte[]{45, 45, MultipartEntity.encodeBoundary((int)(timestamp & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(timestamp >> 25 & 0x1FL)), MultipartEntity.encodeBoundary(count & 0x1F), MultipartEntity.encodeBoundary(count >> 5 & 0x1F), MultipartEntity.encodeBoundary(count >> 10 & 0x1F), MultipartEntity.encodeBoundary(count >> 15 & 0x1F), MultipartEntity.encodeBoundary((int)(rand & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 5 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 10 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 15 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 20 & 0x1FL)), MultipartEntity.encodeBoundary((int)(rand >> 25 & 0x1FL))};
        return boundary;
    }

    private static byte encodeBoundary(int value) {
        if (value < 26) {
            return (byte)(97 + value);
        }
        return (byte)(48 + (value - 26));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBoundary() {
        return this.boundary;
    }

    @Override
    public String getContentType() {
        return "multipart/" + this.subType + "; boundary=" + new String(this.boundary, StandardCharsets.US_ASCII);
    }

    @Override
    public List<Pair<String, String>> getAdditionalHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void removeHeader(String name) {
        Iterator<Pair<String, String>> it = this.headers.iterator();
        while (it.hasNext()) {
            if (!((String)it.next().getValue1()).equalsIgnoreCase(name)) continue;
            it.remove();
        }
    }

    public void add(MimeEntity part) {
        this.parts.add(part);
    }

    public List<MimeEntity> getParts() {
        return this.parts;
    }

    public <T extends MimeEntity> List<T> getPartsOfType(Class<T> type) {
        LinkedList<MimeEntity> list = new LinkedList<MimeEntity>();
        for (MimeEntity p : this.parts) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            list.add(p);
        }
        return list;
    }

    @Override
    public IO.Readable getReadableStream() {
        byte[] bound = new byte[6 + this.boundary.length];
        bound[this.boundary.length + 4] = 13;
        bound[0] = 13;
        bound[this.boundary.length + 5] = 10;
        bound[1] = 10;
        bound[2] = 45;
        bound[3] = 45;
        System.arraycopy(this.boundary, 0, bound, 4, this.boundary.length);
        ByteArrayIO boundaryIO = new ByteArrayIO(bound, "multipart boundary");
        IO.Readable[] ios = new IO.Readable[this.parts.size() * 2 + 1];
        int i = 0;
        boolean allKnownSize = true;
        for (MimeEntity p : this.parts) {
            ios[i++] = new SubIO.Readable.Seekable((IO.Readable.Seekable)boundaryIO, 0L, (long)bound.length, "Multipart boundary", false);
            IO.Readable io = p.createIOWithHeaders();
            ios[i++] = io;
            if (io instanceof IO.KnownSize) continue;
            allKnownSize = false;
        }
        byte[] finalBoundary = new byte[6 + this.boundary.length];
        finalBoundary[0] = 13;
        finalBoundary[1] = 10;
        finalBoundary[this.boundary.length + 4] = 45;
        finalBoundary[2] = 45;
        finalBoundary[this.boundary.length + 5] = 45;
        finalBoundary[3] = 45;
        System.arraycopy(this.boundary, 0, finalBoundary, 4, this.boundary.length);
        ios[i] = new ByteArrayIO(finalBoundary, finalBoundary.length, "multipart ending boundary");
        if (allKnownSize) {
            return new LinkedIO.Readable.DeterminedSize("MIME form-data", ios);
        }
        return new LinkedIO.Readable("MIME form-data", ios);
    }

    public SynchronizationPoint<IOException> parse(IO.Readable content) {
        Object bio = content instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)content : new SimpleBufferedReadable(content, 8192);
        SynchronizationPoint sp = new SynchronizationPoint();
        Parser parser = new Parser((IO.Readable.Buffered)bio, (SynchronizationPoint<IOException>)sp);
        parser.nextBuffer();
        return sp;
    }

    protected AsyncWork<MimeEntity, IOException> createPart(MIME headers, IOInMemoryOrFile body) {
        headers.setBodyToSend((IO.Readable)body);
        return new AsyncWork((Object)new GenericMimeEntity(headers), null);
    }

    private class Parser {
        private IO.Readable.Buffered io;
        private SynchronizationPoint<IOException> sp;
        private byte[] boundaryRead = null;
        private int boundaryPos = 0;
        private boolean firstBoundary = true;
        private MIME header = null;
        private StringBuilder headerLine = null;
        private IOInMemoryOrFile body = null;
        private byte[] bodyBuffer = new byte[1024];
        private int bodyBufferPos = 0;

        public Parser(IO.Readable.Buffered io, SynchronizationPoint<IOException> sp) {
            this.io = io;
            this.sp = sp;
        }

        public void nextBuffer() {
            this.io.readNextBufferAsync().listenInline(buffer -> this.parse((ByteBuffer)buffer), this.sp);
        }

        private void parse(final ByteBuffer buffer) {
            if (buffer == null) {
                this.sp.error((Exception)new EOFException("Unexpected end of multipart content"));
                return;
            }
            new Task.Cpu<Void, NoException>("Parsing multipart content", this.io.getPriority()){

                public Void run() {
                    while (buffer.hasRemaining()) {
                        byte b = buffer.get();
                        if (Parser.this.header != null && Parser.this.body == null) {
                            if (b == 10) {
                                String line = Parser.this.headerLine.toString().trim();
                                if (line.length() == 0) {
                                    Parser.this.body = new IOInMemoryOrFile(8192, Parser.this.io.getPriority(), "Multipart body");
                                    continue;
                                }
                                Parser.this.header.appendHeaderLine(line);
                                Parser.this.headerLine = new StringBuilder(128);
                                continue;
                            }
                            Parser.this.headerLine.append((char)b);
                            continue;
                        }
                        if (Parser.this.boundaryPos == 0) {
                            if (b == 13) {
                                if (Parser.this.boundaryRead == null) {
                                    Parser.access$502(Parser.this, new byte[4 + MultipartEntity.this.boundary.length + 2]);
                                }
                                ((Parser)Parser.this).boundaryRead[0] = b;
                                Parser.this.boundaryPos = 1;
                                Parser.this.firstBoundary = false;
                                continue;
                            }
                            if (Parser.this.body != null) {
                                ((Parser)Parser.this).bodyBuffer[((Parser)Parser.this).bodyBufferPos++] = b;
                                if (Parser.this.bodyBufferPos != Parser.this.bodyBuffer.length) continue;
                                Parser.this.body.writeAsync(ByteBuffer.wrap(Parser.this.bodyBuffer)).listenInline(written -> Parser.this.parse(buffer), (ISynchronizationPoint)Parser.this.sp);
                                return null;
                            }
                            if (!Parser.this.firstBoundary || b != 45) continue;
                            Parser.access$502(Parser.this, new byte[4 + MultipartEntity.this.boundary.length + 2]);
                            ((Parser)Parser.this).boundaryRead[2] = 45;
                            Parser.this.boundaryPos = 3;
                            continue;
                        }
                        if (Parser.this.boundaryPos == 1) {
                            if (b == 10) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos < 4) {
                            if (b == 45) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos < 4 + MultipartEntity.this.boundary.length) {
                            if (b == MultipartEntity.this.boundary[Parser.this.boundaryPos - 4]) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryPos == 4 + MultipartEntity.this.boundary.length) {
                            if (b == 13 || b == 45) {
                                ((Parser)Parser.this).boundaryRead[((Parser)Parser.this).boundaryPos++] = b;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (Parser.this.boundaryRead[Parser.this.boundaryPos - 1] == 13) {
                            if (b == 10) {
                                Parser.this.firstBoundary = false;
                                if (Parser.this.body != null) {
                                    Parser.this.createPart(buffer);
                                    return null;
                                }
                                Parser.this.header = new MIME();
                                Parser.this.headerLine = new StringBuilder(128);
                                Parser.this.body = null;
                                Parser.this.bodyBufferPos = 0;
                                Parser.access$502(Parser.this, null);
                                Parser.this.boundaryPos = 0;
                                continue;
                            }
                            if (Parser.this.notBoundary(buffer)) continue;
                            return null;
                        }
                        if (b == 45) {
                            if (Parser.this.body != null) {
                                Parser.this.createPart(null);
                                return null;
                            }
                            Parser.this.sp.unblock();
                            return null;
                        }
                        if (Parser.this.notBoundary(buffer)) continue;
                        return null;
                    }
                    Parser.this.nextBuffer();
                    return null;
                }
            }.start();
        }

        private boolean notBoundary(ByteBuffer buffer) {
            this.firstBoundary = false;
            if (this.body == null) {
                this.boundaryPos = 0;
                return true;
            }
            for (int i = 0; i < this.boundaryPos; ++i) {
                this.bodyBuffer[this.bodyBufferPos++] = this.boundaryRead[i];
                if (this.bodyBufferPos != this.bodyBuffer.length) continue;
                int j = i;
                this.body.writeAsync(ByteBuffer.wrap(this.bodyBuffer)).listenInline(written -> {
                    if (j < this.boundaryPos - 1) {
                        System.arraycopy(this.boundaryRead, j, this.bodyBuffer, 0, this.boundaryPos - j);
                        this.bodyBufferPos = this.boundaryPos - j;
                    } else {
                        this.bodyBufferPos = 0;
                    }
                    this.boundaryPos = 0;
                    this.parse(buffer);
                }, this.sp);
                return false;
            }
            return true;
        }

        private void createPart(ByteBuffer buffer) {
            if (this.bodyBufferPos > 0) {
                this.body.writeAsync(ByteBuffer.wrap(this.bodyBuffer, 0, this.bodyBufferPos)).listenInline(written -> {
                    this.bodyBufferPos = 0;
                    this.createPart(buffer);
                }, this.sp);
                return;
            }
            this.body.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
            MultipartEntity.this.createPart(this.header, this.body).listenInline(part -> {
                MultipartEntity.this.parts.add((MimeEntity)part);
                if (buffer != null) {
                    this.header = new MIME();
                    this.headerLine = new StringBuilder(128);
                    this.body = null;
                    this.bodyBufferPos = 0;
                    this.boundaryRead = null;
                    this.boundaryPos = 0;
                    this.parse(buffer);
                    return;
                }
                this.sp.unblock();
            }, this.sp);
        }

        static /* synthetic */ byte[] access$502(Parser x0, byte[] x1) {
            x0.boundaryRead = x1;
            return x1;
        }
    }
}

