/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.LinkedIO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.util.Pair;

public interface MimeEntity {
    public IO.Readable getReadableStream();

    public String getContentType();

    public List<Pair<String, String>> getAdditionalHeaders();

    default public IO.Readable createIOWithHeaders() {
        StringBuilder h = new StringBuilder(256);
        String s = this.getContentType();
        if (s != null) {
            h.append("Content-Type: ").append(s).append("\r\n");
        }
        for (Pair<String, String> p : this.getAdditionalHeaders()) {
            h.append((String)p.getValue1()).append(": ").append((String)p.getValue2()).append("\r\n");
        }
        h.append("\r\n");
        byte[] header = h.toString().getBytes(StandardCharsets.US_ASCII);
        return new LinkedIO.Readable.DeterminedSize("MIME", new IO.Readable[]{new ByteArrayIO(header, "MIME Headers"), this.getReadableStream()});
    }

    default public List<String> getHeaderValues(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (Pair<String, String> h : this.getAdditionalHeaders()) {
            if (!((String)h.getValue1()).equalsIgnoreCase(name)) continue;
            values.add((String)h.getValue2());
        }
        return values;
    }

    default public String getHeaderSingleValue(String name) {
        for (Pair<String, String> h : this.getAdditionalHeaders()) {
            if (!((String)h.getValue1()).equalsIgnoreCase(name)) continue;
            return (String)h.getValue2();
        }
        return null;
    }
}

