/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.network.mime.MIME;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.util.Pair;

public class GenericMimeEntity
implements MimeEntity {
    protected MIME mime;

    public GenericMimeEntity(MIME mime) {
        this.mime = mime;
    }

    @Override
    public IO.Readable getReadableStream() {
        IO.Readable body = this.mime.getBodyInput();
        if (body != null) {
            return body;
        }
        body = this.mime.getBodyOutputAsInput();
        return body;
    }

    @Override
    public String getContentType() {
        return this.mime.getContentType();
    }

    @Override
    public List<Pair<String, String>> getAdditionalHeaders() {
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        for (Map.Entry<String, List<String>> e : this.mime.getHeaders().entrySet()) {
            for (String value : e.getValue()) {
                headers.add((Pair<String, String>)new Pair((Object)e.getKey(), (Object)value));
            }
        }
        return headers;
    }

    public MIME getMIME() {
        return this.mime;
    }
}

