/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.util.Pair;

public class FormUrlEncodedEntity
implements MimeEntity {
    protected List<Pair<String, String>> parameters = new LinkedList<Pair<String, String>>();

    public void add(String name, String value) {
        this.parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getParameter(String name) {
        for (Pair<String, String> p : this.parameters) {
            if (!((String)p.getValue1()).equals(name)) continue;
            return (String)p.getValue2();
        }
        return null;
    }

    public SynchronizationPoint<IOException> parse(IO.Readable source, Charset charset) {
        final BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream(source, charset, 512, 8);
        final SynchronizationPoint result = new SynchronizationPoint();
        new Task.Cpu<Void, NoException>("Parsing www-form-urlencoded", source.getPriority(), res -> stream.closeAsync()){

            public Void run() {
                StringBuilder name = new StringBuilder();
                StringBuilder value = new StringBuilder();
                boolean inValue = false;
                while (true) {
                    char c;
                    try {
                        c = stream.read();
                    }
                    catch (EOFException eof) {
                        if (name.length() <= 0 && value.length() <= 0) break;
                        try {
                            FormUrlEncodedEntity.this.parameters.add((Pair<String, String>)new Pair((Object)URLDecoder.decode(name.toString(), "UTF-8"), (Object)URLDecoder.decode(value.toString(), "UTF-8")));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        break;
                    }
                    catch (IOException error) {
                        result.error((Exception)error);
                        return null;
                    }
                    if (c == '&') {
                        if (name.length() > 0 || value.length() > 0) {
                            try {
                                FormUrlEncodedEntity.this.parameters.add((Pair<String, String>)new Pair((Object)URLDecoder.decode(name.toString(), "UTF-8"), (Object)URLDecoder.decode(value.toString(), "UTF-8")));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        name = new StringBuilder();
                        value = new StringBuilder();
                        inValue = false;
                        continue;
                    }
                    if (!inValue && c == '=') {
                        inValue = true;
                        continue;
                    }
                    if (inValue) {
                        value.append(c);
                        continue;
                    }
                    name.append(c);
                }
                result.unblock();
                return null;
            }
        }.startOn((ISynchronizationPoint)stream.canStartReading(), true);
        return result;
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded; charset=utf-8";
    }

    @Override
    public List<Pair<String, String>> getAdditionalHeaders() {
        return new ArrayList<Pair<String, String>>(0);
    }

    @Override
    public IO.Readable getReadableStream() {
        StringBuilder s = new StringBuilder(1024);
        for (Pair<String, String> param : this.parameters) {
            if (s.length() > 0) {
                s.append('&');
            }
            try {
                s.append(URLEncoder.encode((String)param.getValue1(), "UTF-8"));
                s.append('=');
                s.append(URLEncoder.encode((String)param.getValue2(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        byte[] content = s.toString().getBytes(StandardCharsets.UTF_8);
        return new ByteArrayIO(content, "form urlencoded");
    }
}

