/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFileTask;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.ByteBuffersIO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.encoding.QuotedPrintable;
import net.lecousin.framework.network.mime.MIME;
import net.lecousin.framework.network.mime.MIMEUtil;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.network.mime.entity.MultipartEntity;
import net.lecousin.framework.network.mime.transfer.TransferEncodingFactory;
import net.lecousin.framework.network.mime.transfer.encoding.ContentDecoder;
import net.lecousin.framework.network.mime.transfer.encoding.IdentityDecoder;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class FormDataEntity
extends MultipartEntity
implements Closeable,
AsyncCloseable<IOException> {
    public FormDataEntity() {
        super("form-data");
    }

    public FormDataEntity(byte[] boundary) {
        super(boundary, "form-data");
    }

    public void addField(String name, String value, Charset charset) {
        this.add(new PartField(name, value, charset));
    }

    public void addFile(String fieldName, String filename, String contentType, IO.Readable content, String ... headers) {
        this.add(new PartFile(fieldName, filename, contentType, content, headers));
    }

    public List<Pair<String, String>> getFields() {
        LinkedList<Pair<String, String>> list = new LinkedList<Pair<String, String>>();
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartField)) continue;
            list.add((Pair<String, String>)new Pair((Object)((PartField)p).getName(), (Object)((PartField)p).getValue()));
        }
        return list;
    }

    public String getFieldValue(String name) {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartField) || !((PartField)p).getName().equals(name)) continue;
            return ((PartField)p).getValue();
        }
        return null;
    }

    public PartFile getFile(String name) {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile) || !((PartFile)p).getName().equals(name)) continue;
            return (PartFile)p;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            try {
                ((PartFile)p).getReadableStream().close();
            }
            catch (Exception e) {
                throw IO.error((Throwable)e);
            }
        }
    }

    public ISynchronizationPoint<IOException> closeAsync() {
        JoinPoint jp = new JoinPoint();
        for (MimeEntity p : this.parts) {
            if (!(p instanceof PartFile)) continue;
            jp.addToJoin(((PartFile)p).getReadableStream().closeAsync());
        }
        jp.start();
        SynchronizationPoint result = new SynchronizationPoint();
        jp.listenInline(() -> {
            if (jp.hasError()) {
                result.error((Exception)IO.error((Throwable)jp.getError()));
            } else {
                result.unblock();
            }
        });
        return result;
    }

    @Override
    protected AsyncWork<MimeEntity, IOException> createPart(MIME headers, IOInMemoryOrFile body) {
        try {
            Pair<String, Map<String, String>> dispo = headers.parseParameterizedHeaderSingleValue("Content-Disposition");
            if (dispo == null) {
                throw new IOException("Missing header Content-Disposition for a form-data entity");
            }
            if (!"form-data".equals(dispo.getValue1())) {
                throw new IOException("Invalid Content-Disposition: " + (String)dispo.getValue1() + ", expected is form-data");
            }
            String fieldName = (String)((Map)dispo.getValue2()).get("name");
            if (fieldName == null) {
                throw new IOException("Missing parameter 'name' in Content-Disposition");
            }
            String filename = (String)((Map)dispo.getValue2()).get("filename");
            Pair<String, Map<String, String>> type = headers.parseContentType();
            if ((type == null || "text/plain".equals(type.getValue1())) && body.getSizeSync() < 65536L && filename == null) {
                String s;
                Charset charset = type == null ? StandardCharsets.US_ASCII : ((s = (String)((Map)type.getValue2()).get("charset")) == null ? StandardCharsets.US_ASCII : Charset.forName(s));
                ByteBuffersIO out = new ByteBuffersIO(false, "form-data field value", 4);
                ContentDecoder decoder = new IdentityDecoder((IO.Writable)out);
                decoder = TransferEncodingFactory.createDecoder(decoder, headers);
                AsyncWork result = new AsyncWork();
                if (decoder instanceof IdentityDecoder) {
                    FormDataEntity.readField(fieldName, (IO.Readable)body, charset, (AsyncWork<MimeEntity, IOException>)result);
                    out.closeAsync();
                    return result;
                }
                FormDataEntity.decodeField(fieldName, decoder, body, out, charset, (AsyncWork<MimeEntity, IOException>)result);
                return result;
            }
            File tmp = File.createTempFile("formData", "file");
            tmp.deleteOnExit();
            FileIO.ReadWrite io = new FileIO.ReadWrite(tmp, 4);
            ContentDecoder decoder = new IdentityDecoder((IO.Writable)io);
            decoder = TransferEncodingFactory.createDecoder(decoder, headers);
            if (decoder instanceof IdentityDecoder) {
                io.closeAsync().listenInline(() -> new RemoveFileTask(tmp, 6).start());
                return new AsyncWork((Object)new PartFile(fieldName, filename, headers.getContentType(), (IO.Readable)body, new String[0]), null);
            }
            AsyncWork result = new AsyncWork();
            FormDataEntity.decodeFile(fieldName, filename, headers.getContentType(), (IO.Readable)body, decoder, io, (AsyncWork<MimeEntity, IOException>)result);
            io.addCloseListener(() -> new RemoveFileTask(tmp, 6).start());
            return result;
        }
        catch (IOException e) {
            return new AsyncWork(null, (Exception)e);
        }
    }

    private static void readField(String fieldName, IO.Readable content, Charset charset, AsyncWork<MimeEntity, IOException> result) {
        Task.Output read = IOUtil.readFullyAsString((IO.Readable)content, (Charset)charset, (byte)4).getOutput();
        read.listenInline(() -> FormDataEntity.lambda$readField$3((AsyncWork)read, result, fieldName, charset));
    }

    private static void decodeField(String fieldName, ContentDecoder decoder, IOInMemoryOrFile encoded, ByteBuffersIO decoded, Charset charset, AsyncWork<MimeEntity, IOException> result) {
        ByteBuffer buf = ByteBuffer.allocate((int)encoded.getSizeSync());
        AsyncWork read = encoded.readFullyAsync(buf);
        read.listenInline(() -> {
            if (read.hasError()) {
                result.error((Exception)new IOException("Error reading value of form-data field " + fieldName, read.getError()));
                return;
            }
            buf.flip();
            ISynchronizationPoint<IOException> decode = decoder.decode(buf);
            decode.listenInline(() -> {
                if (decode.hasError()) {
                    result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, decode.getError()));
                    return;
                }
                ISynchronizationPoint<IOException> end = decoder.endOfData();
                end.listenInline(() -> {
                    if (end.hasError()) {
                        result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, end.getError()));
                        return;
                    }
                    decoded.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
                    FormDataEntity.readField(fieldName, (IO.Readable)decoded, charset, result);
                });
            });
        });
    }

    private static void decodeFile(String fieldName, String filename, String contentType, IO.Readable encoded, ContentDecoder decoder, FileIO.ReadWrite file, AsyncWork<MimeEntity, IOException> result) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        AsyncWork read = encoded.readFullyAsync(buf);
        read.listenAsync((Task)new Task.Cpu.FromRunnable("Reading form-data file", 4, () -> {
            if (read.hasError()) {
                result.error((Exception)new IOException("Error reading value of form-data field " + fieldName, read.getError()));
                file.closeAsync();
                return;
            }
            buf.flip();
            ISynchronizationPoint<IOException> decode = decoder.decode(buf);
            decode.listenInline(() -> {
                if (decode.hasError()) {
                    result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, decode.getError()));
                    file.closeAsync();
                    return;
                }
                if ((Integer)read.getResult() < 65536) {
                    ISynchronizationPoint<IOException> end = decoder.endOfData();
                    end.listenInline(() -> {
                        if (end.hasError()) {
                            result.error((Exception)new IOException("Error decoding value of form-data field " + fieldName, end.getError()));
                            file.closeAsync();
                            return;
                        }
                        AsyncWork seek = file.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
                        seek.listenInline(() -> {
                            if (seek.hasError()) {
                                result.error(seek.getError());
                                file.closeAsync();
                                return;
                            }
                            result.unblockSuccess((Object)new PartFile(fieldName, filename, contentType, (IO.Readable)file, new String[0]));
                        });
                    });
                    return;
                }
                FormDataEntity.decodeFile(fieldName, filename, contentType, encoded, decoder, file, result);
            });
        }), true);
    }

    private static /* synthetic */ void lambda$readField$3(AsyncWork read, AsyncWork result, String fieldName, Charset charset) {
        if (read.hasError()) {
            result.error(read.getError());
            return;
        }
        result.unblockSuccess((Object)new PartField(fieldName, ((UnprotectedStringBuffer)read.getResult()).asString(), charset));
    }

    public static class PartFile
    implements MimeEntity {
        protected String fieldName;
        protected String filename;
        protected String contentType;
        protected IO.Readable content;
        protected List<Pair<String, String>> headers = new LinkedList<Pair<String, String>>();

        public PartFile(String fieldName, String filename, String contentType, IO.Readable content, String ... headers) {
            this.fieldName = fieldName;
            this.filename = filename;
            this.contentType = contentType;
            this.content = content;
            for (int i = 0; i < headers.length - 1; i += 2) {
                this.headers.add((Pair<String, String>)new Pair((Object)headers[i], (Object)headers[i + 1]));
            }
        }

        public String getName() {
            return this.fieldName;
        }

        public String getFilename() {
            return this.filename;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public List<Pair<String, String>> getAdditionalHeaders() {
            ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>(1);
            StringBuilder dispo = new StringBuilder(128);
            dispo.append("form-data; name=");
            dispo.append(MIMEUtil.encodeUTF8HeaderParameterValue(this.fieldName));
            if (this.filename != null) {
                dispo.append("; filename=");
                dispo.append(MIMEUtil.encodeUTF8HeaderParameterValue(this.filename));
            }
            headers.add(new Pair((Object)"Content-Disposition", (Object)dispo.toString()));
            headers.addAll(this.headers);
            return headers;
        }

        @Override
        public IO.Readable getReadableStream() {
            return this.content;
        }
    }

    public static class PartField
    implements MimeEntity {
        protected String name;
        protected String value;
        protected Charset charset;

        public PartField(String name, String value, Charset charset) {
            this.name = name;
            this.value = value;
            this.charset = charset;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public List<Pair<String, String>> getAdditionalHeaders() {
            ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>(2);
            headers.add(new Pair((Object)"Content-Disposition", (Object)("form-data; name=" + MIMEUtil.encodeHeaderParameterValue(this.name, this.charset))));
            headers.add(new Pair((Object)"Content-Transfer-Encoding", (Object)"quoted-printable"));
            headers.add(new Pair((Object)"Content-Type", (Object)("text/plain; charset=" + this.charset.name())));
            return headers;
        }

        @Override
        public IO.Readable getReadableStream() {
            ByteBuffer content = QuotedPrintable.encode((String)this.value, (Charset)this.charset);
            return new ByteArrayIO(content.array(), content.remaining(), "form-data field content");
        }
    }
}

