/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.entity;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.network.mime.entity.MimeEntity;
import net.lecousin.framework.util.Pair;

public class BinaryMimeEntity
implements MimeEntity {
    protected IO.Readable content;
    protected String contentType;
    protected List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();

    public BinaryMimeEntity(String contentType, IO.Readable content) {
        this.contentType = contentType;
        this.content = content;
    }

    @Override
    public IO.Readable getReadableStream() {
        return this.content;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public List<Pair<String, String>> getAdditionalHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.add((Pair<String, String>)new Pair((Object)name, (Object)value));
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void removeHeader(String name) {
        Iterator<Pair<String, String>> it = this.headers.iterator();
        while (it.hasNext()) {
            if (!((String)it.next().getValue1()).equalsIgnoreCase(name)) continue;
            it.remove();
        }
    }

    public static BinaryMimeEntity fromString(String content, Charset charset, String contentType) {
        return new BinaryMimeEntity(contentType + ";charset=" + charset.name(), (IO.Readable)new ByteArrayIO(content.getBytes(charset), "MimeEntity from string"));
    }
}

