/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.io.encoding.Base64;
import net.lecousin.framework.io.encoding.QuotedPrintable;
import net.lecousin.framework.util.Pair;

public final class MIMEUtil {
    public static Pair<String, Map<String, String>> parseParameterizedHeader(String headerContent) throws IOException {
        if (headerContent == null) {
            return null;
        }
        int i = headerContent.indexOf(59);
        if (i < 0) {
            return new Pair((Object)headerContent.trim(), new HashMap());
        }
        String firstValue = headerContent.substring(0, i).trim();
        firstValue = MIMEUtil.decodeHeaderRFC2047(firstValue);
        headerContent = headerContent.substring(i + 1);
        boolean inQuote = false;
        boolean inValue = false;
        HashMap<String, String> values = new HashMap<String, String>();
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (i = 0; i < headerContent.length(); ++i) {
            char c = headerContent.charAt(i);
            if (inQuote) {
                if (c == '\\') {
                    if (i < headerContent.length() - 1) {
                        c = headerContent.charAt(++i);
                    }
                } else if (c == '\"') {
                    inQuote = false;
                    continue;
                }
            } else {
                if (!inValue && c == '=') {
                    inValue = true;
                    continue;
                }
                if (c == ';') {
                    values.put(name.toString(), MIMEUtil.decodeHeaderRFC2047(value.toString()));
                    name = new StringBuilder();
                    value = new StringBuilder();
                    inValue = false;
                    continue;
                }
                if (c == ' ' && !inValue && name.length() == 0) continue;
                if (c == '\"') {
                    inQuote = true;
                    continue;
                }
            }
            if (inValue) {
                value.append(c);
                continue;
            }
            name.append(c);
        }
        if (name.length() > 0 || value.length() > 0) {
            values.put(name.toString(), MIMEUtil.decodeHeaderRFC2047(value.toString()));
        }
        return new Pair((Object)firstValue, values);
    }

    public static String decodeHeaderRFC2047(String value) throws IOException {
        int pos = 0;
        while (pos < value.length()) {
            int j;
            int i = value.indexOf("=?", pos);
            int i2 = value.indexOf(34, pos);
            if (i2 >= 0 && (i < 0 || i > i2) && (j = value.indexOf(34, i2 + 1)) > 0) {
                value = value.substring(0, i2) + value.substring(i2 + 1, j) + value.substring(j + 1);
                continue;
            }
            if (i < 0 || (j = value.indexOf("?=", i + 2)) < 0) break;
            String decoded = MIMEUtil.decodeRFC2047Word(value.substring(i + 2, j));
            value = value.substring(0, i) + decoded + value.substring(j + 2);
            pos = i + decoded.length();
        }
        return value;
    }

    public static String decodeRFC2047Word(String encodedWord) throws UnsupportedEncodingException, IOException {
        int i = encodedWord.indexOf(63);
        if (i < 0) {
            return encodedWord;
        }
        String charsetName = encodedWord.substring(0, i);
        if ((i = (encodedWord = encodedWord.substring(i + 1)).indexOf(63)) < 0) {
            return encodedWord;
        }
        String encoding = encodedWord.substring(0, i);
        encodedWord = encodedWord.substring(i + 1);
        if ("B".equals(encoding = encoding.trim().toUpperCase())) {
            byte[] decoded = Base64.decode((String)encodedWord);
            return new String(decoded, charsetName);
        }
        if ("Q".equals(encoding)) {
            ByteBuffer decoded = QuotedPrintable.decode((String)encodedWord);
            return new String(decoded.array(), 0, decoded.remaining(), charsetName);
        }
        throw new UnsupportedEncodingException("RFC 2047 encoding " + encoding);
    }

    public static String encodeHeaderParameterValue(String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        boolean hasSpecialChars = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 32 && bytes[i] <= 126) continue;
            hasSpecialChars = true;
            break;
        }
        if (!hasSpecialChars) {
            return "\"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }
        StringBuilder s = new StringBuilder(value.length() + 64);
        s.append("=?UTF-8?B?");
        s.append(new String(Base64.encodeBase64((byte[])bytes)));
        s.append("?=");
        return s.toString();
    }

    public static String encodeUTF8HeaderParameterValue(String value) {
        return MIMEUtil.encodeHeaderParameterValue(value, StandardCharsets.UTF_8);
    }
}

