/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.network.TCPRemote;
import net.lecousin.framework.network.client.TCPClient;
import net.lecousin.framework.network.mime.MIMEUtil;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.network.mime.transfer.IdentityTransfer;
import net.lecousin.framework.network.mime.transfer.TransferEncodingFactory;
import net.lecousin.framework.network.mime.transfer.TransferReceiver;
import net.lecousin.framework.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MIME {
    public static final Log logger = LogFactory.getLog(MIME.class);
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONNECTION = "Connection";
    private HashMap<String, List<String>> header = new HashMap(10);
    private String lastFieldName = null;
    private IO.Writable bodyOut = null;
    private TransferReceiver bodyTransfer = null;
    private IO.Readable bodyIn = null;

    public void appendHeaderLine(String line) {
        if (line.isEmpty()) {
            return;
        }
        char c = line.charAt(0);
        if (c == ' ' || c == '\t') {
            if (this.lastFieldName == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Invalid MIME Header line (start with space, but no previous field): " + line));
                }
                return;
            }
            List<String> list = this.header.get(this.lastFieldName);
            String lastValue = list.get(list.size() - 1);
            lastValue = lastValue + line.trim();
            list.set(list.size() - 1, lastValue);
            return;
        }
        int i = line.indexOf(58);
        if (i < 0) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Invalid MIME Header line: " + line));
            }
            return;
        }
        String name = line.substring(0, i).trim().toLowerCase();
        String value = line.substring(i + 1).trim();
        List<String> list = this.header.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.header.put(name, list);
        }
        list.add(value);
    }

    public List<String> getHeaderValues(String field) {
        return this.header.get(field.toLowerCase());
    }

    public String getHeaderSingleValue(String field) {
        List<String> list = this.header.get(field.toLowerCase());
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public Long getHeaderSingleValueLong(String field) {
        String s = this.getHeaderSingleValue(field);
        if (s == null) {
            return null;
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String[] getHeaderCommaSeparatedValues(String header) {
        String h = this.getHeaderSingleValue(header);
        if (h == null) {
            return null;
        }
        if ((h = h.trim()).length() == 0) {
            return new String[0];
        }
        String[] list = h.split(",");
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].trim();
        }
        return list;
    }

    public boolean isHeaderCommaSeparatedContainingValue(String header, String value) {
        String[] values = this.getHeaderCommaSeparatedValues(header);
        if (values == null) {
            return false;
        }
        for (String v : values) {
            if (!v.toLowerCase().equals(value.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Pair<String, Map<String, String>> parseParameterizedHeaderSingleValue(String headerName) throws IOException {
        return MIMEUtil.parseParameterizedHeader(this.getHeaderSingleValue(headerName));
    }

    public Long getContentLength() {
        return this.getHeaderSingleValueLong(CONTENT_LENGTH);
    }

    public void setContentLength(long length) {
        this.setHeader(CONTENT_LENGTH, Long.toString(length));
    }

    public String getContentType() {
        return this.getHeaderSingleValue(CONTENT_TYPE);
    }

    public Pair<String, Map<String, String>> parseContentType() throws IOException {
        return this.parseParameterizedHeaderSingleValue(CONTENT_TYPE);
    }

    public boolean hasHeader(String name) {
        List<String> list = this.header.get(name.toLowerCase());
        return list != null && !list.isEmpty();
    }

    public void setHeader(String name, String value) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(value);
        this.header.put(name.toLowerCase(), list);
    }

    public void addHeaderValue(String name, String value) {
        List<String> list = this.header.get(name = name.toLowerCase());
        if (list == null) {
            list = new ArrayList<String>(5);
            this.header.put(name, list);
        }
        list.add(value);
    }

    public Map<String, List<String>> getHeaders() {
        return this.header;
    }

    public List<Pair<String, String>> getHeadersList() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(this.header.size());
        for (Map.Entry<String, List<String>> h : this.header.entrySet()) {
            for (String value : h.getValue()) {
                list.add((Pair<String, String>)new Pair((Object)h.getKey(), (Object)value));
            }
        }
        return list;
    }

    public String generateHeaders() {
        return this.generateHeaders(false);
    }

    public String generateHeaders(boolean addFinalCRLF) {
        StringBuilder s = new StringBuilder();
        this.generateHeaders(s, addFinalCRLF);
        return s.toString();
    }

    public void generateHeaders(StringBuilder s, boolean addFinalCRLF) {
        for (Map.Entry<String, List<String>> h : this.header.entrySet()) {
            String name = h.getKey();
            int pos = -1;
            while ((pos = (name = name.substring(0, pos + 1) + Character.toUpperCase(name.charAt(pos + 1)) + name.substring(pos + 2)).indexOf(45, pos + 1)) > 0 && pos < name.length()) {
            }
            for (String value : h.getValue()) {
                s.append(name).append(": ").append(value).append("\r\n");
            }
        }
        if (addFinalCRLF) {
            s.append("\r\n");
        }
    }

    public <T extends IO.Writable & IO.Readable> boolean initBodyTransfer(T output) throws IOException {
        this.bodyOut = output;
        this.bodyTransfer = TransferEncodingFactory.create(this, output);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Body transfer initialized with " + this.bodyTransfer + ", something to read: " + this.bodyTransfer.isExpectingData()));
        }
        return !this.bodyTransfer.isExpectingData();
    }

    public AsyncWork<Boolean, IOException> bodyDataReady(ByteBuffer data) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Body data ready, consume it: " + data.remaining() + " bytes"));
        }
        return this.bodyTransfer.consume(data);
    }

    public IO.Writable getBodyOutput() {
        return this.bodyOut;
    }

    public IO.Readable getBodyOutputAsInput() {
        return (IO.Readable)this.bodyOut;
    }

    public IO.Readable getBodyInput() {
        return this.bodyIn;
    }

    public void setBodyToSend(IO.Readable body) {
        this.bodyIn = body;
    }

    public SynchronizationPoint<IOException> readHeader(final TCPClient client, final int timeout) {
        final SynchronizationPoint result = new SynchronizationPoint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Receiving header lines...");
        }
        AsyncWork line = client.getReceiver().readUntil((byte)10, 1024, timeout);
        line.listenInline((AsyncWork.AsyncWorkListener)new AsyncWork.AsyncWorkListener<ByteArrayIO, IOException>(){

            public void ready(ByteArrayIO line) {
                int i;
                String s = line.getAsString(StandardCharsets.US_ASCII);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Header line received: " + s));
                }
                if ((i = s.indexOf(13)) >= 0) {
                    s = s.substring(0, i);
                }
                if ((i = s.indexOf(10)) >= 0) {
                    s = s.substring(0, i);
                }
                if (s.length() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"End of header lines");
                    }
                    result.unblock();
                    return;
                }
                MIME.this.appendHeaderLine(s);
                client.getReceiver().readUntil((byte)10, 1024, timeout).listenInline((AsyncWork.AsyncWorkListener)this);
            }

            public void error(IOException error) {
                result.error((Exception)error);
            }

            public void cancelled(CancelException event) {
                result.cancel(event);
            }
        });
        return result;
    }

    public ISynchronizationPoint<IOException> send(TCPRemote remote) {
        if (this.bodyIn == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending headers without body to " + remote));
            }
            this.setContentLength(0L);
            byte[] headers = this.generateHeaders(true).getBytes(StandardCharsets.US_ASCII);
            return remote.send(ByteBuffer.wrap(headers));
        }
        if (this.bodyIn instanceof IO.KnownSize && !"chunked".equals(this.getHeaderSingleValue(TRANSFER_ENCODING))) {
            SynchronizationPoint sp = new SynchronizationPoint();
            ((IO.KnownSize)this.bodyIn).getSizeAsync().listenInline(size -> new Task.Cpu.FromRunnable("Send MIME to " + remote, this.bodyIn.getPriority(), () -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending headers with body of " + size + " to " + remote));
                }
                this.setContentLength((long)size);
                byte[] headers = this.generateHeaders(true).getBytes(StandardCharsets.US_ASCII);
                ISynchronizationPoint sendHeaders = remote.send(ByteBuffer.wrap(headers));
                sendHeaders.listenInline(() -> {
                    if (this.bodyIn instanceof IO.Readable.Buffered) {
                        IdentityTransfer.send(remote, (IO.Readable.Buffered)this.bodyIn).listenInline(sp);
                    } else {
                        IdentityTransfer.send(remote, this.bodyIn, 65536, 3).listenInline(sp);
                    }
                }, (ISynchronizationPoint)sp);
            }).start(), (ISynchronizationPoint)sp);
            return sp;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending headers with chunked body to " + remote));
        }
        this.setHeader(TRANSFER_ENCODING, "chunked");
        byte[] headers = this.generateHeaders(true).getBytes(StandardCharsets.US_ASCII);
        ISynchronizationPoint sendHeaders = remote.send(ByteBuffer.wrap(headers));
        SynchronizationPoint sp = new SynchronizationPoint();
        sendHeaders.listenInline(() -> {
            if (this.bodyIn instanceof IO.Readable.Buffered) {
                ChunkedTransfer.send(remote, (IO.Readable.Buffered)this.bodyIn).listenInline(sp);
            } else {
                ChunkedTransfer.send(remote, this.bodyIn, 65536, 3).listenInline(sp);
            }
        }, (ISynchronizationPoint)sp);
        return sp;
    }
}

