/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.CharacterStreamWritePool;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.StringUtil;

public class JSONWriter {
    private boolean pretty;
    private int indent = 0;
    private ICharacterStream.Writable.Buffered output;
    private CharacterStreamWritePool writer;
    private LinkedList<Boolean> first = new LinkedList();
    private static final char[] NULL = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'f', 'a', 'l', 's', 'e'};
    private static final String ERROR_OBJECT_NOT_OPEN = "Object not open";

    public JSONWriter(IO.Writable.Buffered output, boolean pretty) {
        this(output, null, pretty);
    }

    public JSONWriter(IO.Writable.Buffered output, Charset encoding, boolean pretty) {
        this((ICharacterStream.Writable.Buffered)new BufferedWritableCharacterStream((IO.Writable)output, encoding != null ? encoding : StandardCharsets.UTF_8, 4096), pretty);
    }

    public JSONWriter(ICharacterStream.Writable.Buffered output, boolean pretty) {
        this.output = output;
        this.pretty = pretty;
        this.writer = new CharacterStreamWritePool((ICharacterStream.Writable)output);
    }

    public static String escape(CharSequence s) {
        int len = s.length();
        StringBuilder str = new StringBuilder(len);
        char c2 = '\u0000';
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    c2 = 'b';
                    break;
                }
                case '\r': {
                    c2 = 'r';
                    break;
                }
                case '\n': {
                    c2 = 'n';
                    break;
                }
                case '\f': {
                    c2 = 'f';
                    break;
                }
                case '\t': {
                    c2 = 't';
                    break;
                }
                case '\\': {
                    c2 = c;
                    break;
                }
                case '\"': {
                    c2 = c;
                    break;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        str.append("\\u").append(StringUtil.encodeHexaDigit((int)((c & 0xF000) >> 12))).append(StringUtil.encodeHexaDigit((int)((c & 0xF00) >> 8))).append(StringUtil.encodeHexaDigit((int)((c & 0xF0) >> 4))).append(StringUtil.encodeHexaDigit((int)(c & 0xF)));
                        continue block9;
                    }
                    str.append(c);
                    continue block9;
                }
            }
            str.append('\\');
            str.append(c2);
        }
        return str.toString();
    }

    public IAsync<IOException> flush() {
        Async sp = new Async();
        this.writer.flush().onDone(() -> this.output.flush().onDone(sp), (IAsync)sp);
        return sp;
    }

    private IAsync<IOException> indent(IAsync<IOException> last) {
        if (last == null) {
            last = new Async(true);
        }
        for (int i = 0; i < this.indent; ++i) {
            last = this.writer.write('\t');
        }
        return last;
    }

    public IAsync<IOException> openObject() {
        this.first.addFirst(Boolean.TRUE);
        if (this.pretty) {
            this.writer.write('{');
            ++this.indent;
            return this.indent((IAsync<IOException>)this.writer.write('\n'));
        }
        return this.writer.write('{');
    }

    public IAsync<IOException> closeObject() {
        if (this.first.pollFirst() == null) {
            return new Async((Exception)new IOException(ERROR_OBJECT_NOT_OPEN));
        }
        if (this.pretty) {
            this.writer.write('\n');
            --this.indent;
            this.indent(null);
        }
        return this.writer.write('}');
    }

    public IAsync<IOException> addObjectAttribute(String name) {
        Boolean b = this.first.peekFirst();
        if (b == null) {
            return new Async((Exception)new IOException(ERROR_OBJECT_NOT_OPEN));
        }
        if (b.booleanValue()) {
            this.first.set(0, Boolean.FALSE);
        } else {
            this.writer.write(',');
        }
        if (this.pretty) {
            this.writer.write('\n');
            this.indent(null);
        }
        this.writer.write('\"');
        this.writer.write(JSONWriter.escape(name));
        this.writer.write('\"');
        return this.writer.write(':');
    }

    public IAsync<IOException> addObjectAttribute(String name, boolean value) {
        this.addObjectAttribute(name);
        return this.writeBoolean(value);
    }

    public IAsync<IOException> addObjectAttribute(String name, Number value) {
        this.addObjectAttribute(name);
        return this.writeNumber(value);
    }

    public IAsync<IOException> addObjectAttribute(String name, String value) {
        this.addObjectAttribute(name);
        return this.writeString(value);
    }

    public IAsync<IOException> openArray() {
        this.first.addFirst(Boolean.TRUE);
        if (this.pretty) {
            this.writer.write('[');
            ++this.indent;
            return this.indent((IAsync<IOException>)this.writer.write('\n'));
        }
        return this.writer.write('[');
    }

    public IAsync<IOException> closeArray() {
        if (this.first.pollFirst() == null) {
            return new Async((Exception)new IOException("Array not open"));
        }
        if (this.pretty) {
            --this.indent;
            this.writer.write('\n');
            this.indent(null);
            return this.writer.write(']');
        }
        return this.writer.write(']');
    }

    public IAsync<IOException> startNextArrayElement() {
        Boolean b = this.first.peekFirst();
        if (b == null) {
            return new Async((Exception)new IOException(ERROR_OBJECT_NOT_OPEN));
        }
        if (b.booleanValue()) {
            this.first.set(0, Boolean.FALSE);
            return new Async(true);
        }
        if (this.pretty) {
            this.writer.write(',');
            return this.indent((IAsync<IOException>)this.writer.write('\n'));
        }
        return this.writer.write(',');
    }

    public IAsync<IOException> writeNull() {
        return this.writer.write(NULL);
    }

    public IAsync<IOException> writeString(CharSequence s) {
        this.writer.write('\"');
        this.writer.write(JSONWriter.escape(s));
        return this.writer.write('\"');
    }

    public IAsync<IOException> startString() {
        return this.writer.write('\"');
    }

    public IAsync<IOException> writeStringContent(CharSequence s) {
        return this.writer.write(JSONWriter.escape(s));
    }

    public IAsync<IOException> endString() {
        return this.writer.write('\"');
    }

    public IAsync<IOException> writeNumber(Number n) {
        return this.writer.write(n.toString());
    }

    public IAsync<IOException> writeBoolean(boolean b) {
        return this.writer.write(b ? TRUE : FALSE);
    }
}

