/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.serialization.AbstractSerializationSpecWriter;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.json.JSONWriter;

public class JSONSpecWriter
extends AbstractSerializationSpecWriter {
    protected Charset encoding;
    protected int bufferSize;
    protected boolean pretty;
    protected IO.Writable.Buffered bout;
    protected JSONWriter output;
    private static final Function<IOException, SerializationException> ioErrorConverter = e -> new SerializationException("Error writing JSON schema", (Throwable)e);
    private static final String TYPE_NULL = "null";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_NUMBER = "number";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_ARRAY = "array";
    private static final String TYPE_OBJECT = "object";

    public JSONSpecWriter() {
        this(false);
    }

    public JSONSpecWriter(boolean pretty) {
        this(null, pretty);
    }

    public JSONSpecWriter(Charset encoding) {
        this(encoding, 4096, false);
    }

    public JSONSpecWriter(Charset encoding, boolean pretty) {
        this(encoding, 4096, pretty);
    }

    public JSONSpecWriter(Charset encoding, int bufferSize) {
        this(encoding, bufferSize, false);
    }

    public JSONSpecWriter(Charset encoding, int bufferSize, boolean pretty) {
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.pretty = pretty;
    }

    public JSONSpecWriter(JSONWriter output) {
        this.output = output;
    }

    protected IAsync<SerializationException> initializeSpecWriter(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new JSONWriter(this.bout, this.encoding, this.pretty);
        return new Async(this.output.openObject(), ioErrorConverter);
    }

    protected IAsync<SerializationException> finalizeSpecWriter() {
        Async sp = new Async();
        this.output.closeObject().onDone(() -> this.output.flush().onDone(() -> this.bout.flush().onDone(sp), (IAsync)sp), (IAsync)sp);
        return new Async((IAsync)sp, ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyBooleanValue(SerializationContext context, boolean nullable) {
        this.output.addObjectAttribute("type");
        if (!nullable) {
            return new Async(this.output.writeString(TYPE_BOOLEAN), ioErrorConverter);
        }
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_BOOLEAN);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        return new Async(this.output.closeArray(), ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyNumericValue(SerializationContext context, Class<?> type, boolean nullable, Number min, Number max) {
        IAsync<IOException> result;
        this.output.addObjectAttribute("type");
        if (!nullable) {
            result = this.output.writeString(TYPE_NUMBER);
        } else {
            this.output.openArray();
            this.output.startNextArrayElement();
            this.output.writeString(TYPE_NUMBER);
            this.output.startNextArrayElement();
            this.output.writeString(TYPE_NULL);
            result = this.output.closeArray();
        }
        if (min != null) {
            this.output.addObjectAttribute("minimum");
            result = this.output.writeNumber(min);
        }
        if (max != null) {
            this.output.addObjectAttribute("maximum");
            result = this.output.writeNumber(max);
        }
        return new Async(result, ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyCharacterValue(SerializationContext context, boolean nullable) {
        this.output.addObjectAttribute("type");
        if (!nullable) {
            this.output.writeString(TYPE_STRING);
        } else {
            this.output.openArray();
            this.output.startNextArrayElement();
            this.output.writeString(TYPE_STRING);
            this.output.startNextArrayElement();
            this.output.writeString(TYPE_NULL);
            this.output.closeArray();
        }
        this.output.addObjectAttribute("minLength");
        this.output.writeNumber(nullable ? 0 : 1);
        this.output.addObjectAttribute("maxLength");
        return new Async(this.output.writeNumber(1), ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyStringValue(SerializationContext context, TypeDefinition type) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_STRING);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        return new Async(this.output.closeArray(), ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyEnumValue(SerializationContext context, TypeDefinition type) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_STRING);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        this.output.closeArray();
        this.output.addObjectAttribute("enum");
        this.output.openArray();
        try {
            this.output.startNextArrayElement();
            this.output.writeNull();
            Enum[] values = (Enum[])type.getBase().getMethod("values", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < values.length; ++i) {
                this.output.startNextArrayElement();
                this.output.writeString(values[i].name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Async(this.output.closeArray(), ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyCollectionValue(SerializationContext.CollectionContext context, List<SerializationRule> rules) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_ARRAY);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        this.output.closeArray();
        this.output.addObjectAttribute("items");
        this.output.openObject();
        IAsync element = this.specifyValue((SerializationContext)context, context.getElementType(), rules);
        if (element.isDone()) {
            if (element.hasError()) {
                return element;
            }
            return new Async(this.output.closeObject(), ioErrorConverter);
        }
        Async sp = new Async();
        element.thenStart((Task)new AbstractSerializationSpecWriter.SpecTask((AbstractSerializationSpecWriter)this, () -> this.output.closeObject().onDone(sp, ioErrorConverter)), (IAsync)sp);
        return sp;
    }

    protected IAsync<SerializationException> specifyTypedValue(SerializationContext.ObjectContext context, List<SerializationRule> rules) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_OBJECT);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        this.output.closeArray();
        this.output.addObjectAttribute("properties");
        this.output.openObject();
        IAsync content = this.specifyTypeContent(context, rules);
        if (content.isDone()) {
            if (content.hasError()) {
                return content;
            }
            return new Async(this.output.closeObject(), ioErrorConverter);
        }
        Async sp = new Async();
        content.thenStart((Task)new AbstractSerializationSpecWriter.SpecTask((AbstractSerializationSpecWriter)this, () -> this.output.closeObject().onDone(sp, ioErrorConverter)), (IAsync)sp);
        return sp;
    }

    protected IAsync<SerializationException> specifyTypeAttribute(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        this.output.openObject();
        IAsync spec = this.specifyValue((SerializationContext)context, context.getAttribute().getType(), rules);
        if (spec.isDone()) {
            if (spec.hasError()) {
                return spec;
            }
            return new Async(this.output.closeObject(), ioErrorConverter);
        }
        Async sp = new Async();
        spec.thenStart((Task)new AbstractSerializationSpecWriter.SpecTask((AbstractSerializationSpecWriter)this, () -> this.output.closeObject().onDone(sp, ioErrorConverter)), (IAsync)sp);
        return sp;
    }

    protected IAsync<SerializationException> specifyIOReadableValue(SerializationContext context, List<SerializationRule> rules) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_ARRAY);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        this.output.closeArray();
        this.output.addObjectAttribute("items");
        this.output.openObject();
        this.output.addObjectAttribute("type", TYPE_STRING);
        return new Async(this.output.closeObject(), ioErrorConverter);
    }

    protected IAsync<SerializationException> specifyAnyValue(SerializationContext context) {
        this.output.addObjectAttribute("type");
        this.output.openArray();
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NULL);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_BOOLEAN);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_OBJECT);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_ARRAY);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_NUMBER);
        this.output.startNextArrayElement();
        this.output.writeString(TYPE_STRING);
        return new Async(this.output.closeArray(), ioErrorConverter);
    }
}

