/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedWritable;
import net.lecousin.framework.io.encoding.Base64;
import net.lecousin.framework.io.serialization.AbstractSerializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.json.JSONWriter;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.xml.serialization.XMLDeserializer;

public class JSONSerializer
extends AbstractSerializer {
    protected Charset encoding;
    protected int bufferSize;
    protected boolean pretty;
    protected IO.Writable.Buffered bout;
    protected JSONWriter output;
    private static final Function<IOException, SerializationException> ioErrorConverter = e -> new SerializationException("Error writing JSON", (Throwable)e);

    public JSONSerializer() {
        this(StandardCharsets.UTF_8, 4096, false);
    }

    public JSONSerializer(Charset encoding, boolean pretty) {
        this(encoding, 4096, pretty);
    }

    public JSONSerializer(Charset encoding, int bufferSize, boolean pretty) {
        this.encoding = encoding;
        this.bufferSize = bufferSize;
        this.pretty = pretty;
    }

    protected IAsync<SerializationException> initializeSerialization(IO.Writable output) {
        this.bout = output instanceof IO.Writable.Buffered ? (IO.Writable.Buffered)output : new SimpleBufferedWritable(output, this.bufferSize);
        this.output = new JSONWriter(this.bout, this.encoding, this.pretty);
        return new Async(this.bout.canStartWriting(), ioErrorConverter);
    }

    protected IAsync<SerializationException> finalizeSerialization() {
        Async sp = new Async();
        this.output.flush().onDone(() -> this.bout.flush().onDone(sp, ioErrorConverter), (IAsync)sp, ioErrorConverter);
        return sp;
    }

    protected IAsync<SerializationException> serializeBooleanValue(boolean value) {
        return new Async(this.output.writeBoolean(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeNullValue() {
        return new Async(this.output.writeNull(), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeCharacterValue(char value) {
        return new Async(this.output.writeString(new String(new char[]{value})), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeNumericValue(Number value) {
        return new Async(this.output.writeNumber(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeStringValue(CharSequence value) {
        return new Async(this.output.writeString(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> startCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return new Async(this.output.openArray(), ioErrorConverter);
    }

    protected IAsync<SerializationException> startCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return new Async(this.output.startNextArrayElement(), ioErrorConverter);
    }

    protected IAsync<SerializationException> endCollectionValueElement(SerializationContext.CollectionContext context, Object element, int elementIndex, String elementPath, List<SerializationRule> rules) {
        return new Async(true);
    }

    protected IAsync<SerializationException> endCollectionValue(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        return new Async(this.output.closeArray(), ioErrorConverter);
    }

    protected IAsync<SerializationException> startObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        Object instance = context.getInstance();
        if (instance != null) {
            Class type;
            boolean customInstantiator = false;
            for (SerializationRule rule : rules) {
                if (!rule.canInstantiate(context.getOriginalType(), (SerializationContext)context)) continue;
                customInstantiator = true;
                break;
            }
            if (!(customInstantiator || context.getParent() instanceof SerializationContext.AttributeContext && ((SerializationContext.AttributeContext)context.getParent()).getAttribute().hasCustomInstantiation() || (type = context.getOriginalType().getBase()).equals(instance.getClass()))) {
                String attrName = "class";
                while (XMLDeserializer.hasAttribute((Class)type, (String)attrName)) {
                    attrName = "_" + attrName;
                }
                this.output.openObject();
                this.output.addObjectAttribute(attrName);
                return new Async(this.output.writeString(instance.getClass().getName()), ioErrorConverter);
            }
        }
        return new Async(this.output.openObject(), ioErrorConverter);
    }

    protected IAsync<SerializationException> endObjectValue(SerializationContext.ObjectContext context, String path, List<SerializationRule> rules) {
        return new Async(this.output.closeObject(), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeNullAttribute(SerializationContext.AttributeContext context, String path) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return new Async(this.output.writeNull(), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeBooleanAttribute(SerializationContext.AttributeContext context, boolean value, String path) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return new Async(this.output.writeBoolean(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeNumericAttribute(SerializationContext.AttributeContext context, Number value, String path) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return new Async(this.output.writeNumber(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeCharacterAttribute(SerializationContext.AttributeContext context, char value, String path) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return new Async(this.output.writeString((CharSequence)new UnprotectedString(value)), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeStringAttribute(SerializationContext.AttributeContext context, CharSequence value, String path) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return new Async(this.output.writeString(value), ioErrorConverter);
    }

    protected IAsync<SerializationException> serializeObjectAttribute(SerializationContext.AttributeContext context, Object value, String path, List<SerializationRule> rules) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return this.serializeObjectValue((SerializationContext)context, value, context.getAttribute().getType(), path + '.' + context.getAttribute().getName(), rules);
    }

    protected IAsync<SerializationException> serializeCollectionAttribute(SerializationContext.CollectionContext context, String path, List<SerializationRule> rules) {
        SerializationClass.Attribute colAttr = ((SerializationContext.AttributeContext)context.getParent()).getAttribute();
        this.output.addObjectAttribute(colAttr.getName());
        return this.serializeCollectionValue(context, path + '.' + colAttr.getName(), rules);
    }

    protected IAsync<SerializationException> serializeIOReadableValue(SerializationContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        this.output.openArray();
        IAsync encode = Base64.encodeAsync((IO.Readable)io, (c, offset, length) -> {
            this.output.startNextArrayElement();
            return this.output.writeString((CharSequence)new UnprotectedString(c, offset, length, c.length));
        });
        Async result = new Async();
        encode.thenStart((Task)new AbstractSerializer.SerializationTask((AbstractSerializer)this, () -> this.output.closeArray().onDone(result, ioErrorConverter)), (IAsync)result, ioErrorConverter);
        return result;
    }

    protected IAsync<SerializationException> serializeIOReadableAttribute(SerializationContext.AttributeContext context, IO.Readable io, String path, List<SerializationRule> rules) {
        this.output.addObjectAttribute(context.getAttribute().getName());
        return this.serializeIOReadableValue((SerializationContext)context, io, path, rules);
    }
}

