/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.BufferedReadableCharacterStreamLocation;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.json.JSONParsingException;
import net.lecousin.framework.util.StringUtil;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class JSONReaderAsync {
    private BufferedReadableCharacterStreamLocation input;
    private int maxTextSize = -1;
    public EventType event = null;
    public Number number = null;
    public Boolean bool = null;
    public UnprotectedStringBuffer string = null;
    private State state = State.START;
    private int statePos = 0;
    private LinkedList<ContextType> context = new LinkedList();
    private static final char[] ull = new char[]{'u', 'l', 'l'};
    private static final char[] rue = new char[]{'r', 'u', 'e'};
    private static final char[] alse = new char[]{'a', 'l', 's', 'e'};
    private static final String VALID_JSON_VALUE_EXPECTED = "a valid JSON value is expected";

    public JSONReaderAsync(IO.Readable input, Charset encoding) {
        this((IO.Readable.Buffered)(input instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)input : new PreBufferedReadable(input, 4096, input.getPriority(), 8192, input.getPriority(), 16)), encoding);
    }

    public JSONReaderAsync(IO.Readable.Buffered input, Charset encoding) {
        this((ICharacterStream.Readable.Buffered)new BufferedReadableCharacterStream((IO.Readable)input, encoding == null ? StandardCharsets.UTF_8 : encoding, 2048, 32));
    }

    public JSONReaderAsync(ICharacterStream.Readable.Buffered input) {
        this(input instanceof BufferedReadableCharacterStreamLocation ? (BufferedReadableCharacterStreamLocation)input : new BufferedReadableCharacterStreamLocation(input));
    }

    public JSONReaderAsync(BufferedReadableCharacterStreamLocation input) {
        this.input = input;
    }

    public int getMaximumTextSize() {
        return this.maxTextSize;
    }

    public void setMaximumTextSize(int max) {
        this.maxTextSize = max;
    }

    public Async<Exception> next() {
        this.event = null;
        this.number = null;
        this.bool = null;
        this.string = null;
        Async sp = new Async();
        this.nextChar((Async<Exception>)sp);
        return sp;
    }

    private void nextChar(Async<Exception> sp) {
        boolean continu;
        do {
            int c;
            if (State.END.equals((Object)this.state)) {
                sp.error((Exception)new EOFException());
                return;
            }
            try {
                c = this.input.readAsync();
            }
            catch (IOException e) {
                sp.error((Exception)e);
                return;
            }
            if (c == -2) {
                new Task.Cpu.FromRunnable("JSON Parsing", this.input.getPriority(), () -> this.nextChar(sp)).startOn(this.input.canStartReading(), true);
                return;
            }
            block1 : switch (this.state) {
                case START: {
                    if (c == -1) {
                        sp.error((Exception)new EOFException());
                        return;
                    }
                    if (JSONReaderAsync.isSpaceChar((char)c)) {
                        continu = true;
                        break;
                    }
                    switch (c) {
                        case 123: {
                            this.event = EventType.START_OBJECT;
                            this.context.addFirst(ContextType.OBJECT);
                            this.state = State.FIRST_OBJECT_ATTRIBUTE;
                            sp.unblock();
                            return;
                        }
                        case 91: {
                            this.event = EventType.START_ARRAY;
                            this.context.addFirst(ContextType.ARRAY);
                            this.state = State.FIRST_ARRAY_VALUE;
                            sp.unblock();
                            return;
                        }
                        case 34: {
                            this.state = State.STRING;
                            this.statePos = 0;
                            this.string = new UnprotectedStringBuffer();
                            continu = true;
                            break block1;
                        }
                        case 110: {
                            this.state = State.NULL;
                            this.statePos = 1;
                            continu = true;
                            break block1;
                        }
                        case 116: {
                            this.state = State.TRUE;
                            this.statePos = 1;
                            continu = true;
                            break block1;
                        }
                        case 102: {
                            this.state = State.FALSE;
                            this.statePos = 1;
                            continu = true;
                            break block1;
                        }
                    }
                    if (c == 45 || c >= 48 && c <= 57) {
                        this.state = State.NUMERIC;
                        this.statePos = 0;
                        this.string = new UnprotectedStringBuffer();
                        this.string.append((char)c);
                        continu = true;
                        break;
                    }
                    sp.error((Exception)this.unexpected(c, "expected is a valid JSON value (object, array, string, ...)"));
                    return;
                }
                case NULL: {
                    continu = this.readNull(c, sp);
                    break;
                }
                case TRUE: {
                    continu = this.readTrue(c, sp);
                    break;
                }
                case FALSE: {
                    continu = this.readFalse(c, sp);
                    break;
                }
                case STRING: {
                    continu = this.readString(c, sp);
                    break;
                }
                case NUMERIC: {
                    continu = this.readNumeric(c, sp);
                    break;
                }
                case FIRST_OBJECT_ATTRIBUTE: {
                    continu = this.readFirstObjectAttribute(c, sp);
                    break;
                }
                case OBJECT_ATTRIBUTE_NAME: {
                    continu = this.readObjectAttributeName(c, sp);
                    break;
                }
                case END_OBJECT_ATTRIBUTE_NAME: {
                    continu = this.readEndObjectAttributeName(c, sp);
                    break;
                }
                case NEXT_OBJECT_ATTRIBUTE: {
                    continu = this.readNextObjectAttribute(c, sp);
                    break;
                }
                case NEXT_OBJECT_ATTRIBUTE_NAME: {
                    continu = this.readNextObjectAttributeName(c, sp);
                    break;
                }
                case FIRST_ARRAY_VALUE: {
                    continu = this.readFirstArrayValue(c, sp);
                    break;
                }
                case NEXT_ARRAY_VALUE: {
                    continu = this.readNextArrayValue(c, sp);
                    break;
                }
                default: {
                    sp.error((Exception)this.error("Unexpected parser state " + (Object)((Object)this.state)));
                    return;
                }
            }
        } while (continu);
    }

    private void setNextState() {
        ContextType ctx = this.context.peekFirst();
        this.state = this.context.isEmpty() ? State.END : (ContextType.OBJECT.equals((Object)ctx) ? State.NEXT_OBJECT_ATTRIBUTE : State.NEXT_ARRAY_VALUE);
    }

    private boolean readNull(int c, Async<Exception> sp) {
        boolean r = this.expect(ull, c, sp);
        if (!r && !sp.hasError()) {
            this.event = EventType.NULL;
            this.setNextState();
            sp.unblock();
            return false;
        }
        return r;
    }

    private boolean readTrue(int c, Async<Exception> sp) {
        boolean r = this.expect(rue, c, sp);
        if (!r && !sp.hasError()) {
            this.event = EventType.BOOLEAN;
            this.bool = Boolean.TRUE;
            this.setNextState();
            sp.unblock();
            return false;
        }
        return r;
    }

    private boolean readFalse(int c, Async<Exception> sp) {
        boolean r = this.expect(alse, c, sp);
        if (!r && !sp.hasError()) {
            this.event = EventType.BOOLEAN;
            this.bool = Boolean.FALSE;
            this.setNextState();
            sp.unblock();
            return false;
        }
        return r;
    }

    private boolean expect(char[] expected, int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, VALID_JSON_VALUE_EXPECTED);
        }
        if (c != expected[this.statePos - 1]) {
            return this.unexpected(sp, c, VALID_JSON_VALUE_EXPECTED);
        }
        if (this.statePos == expected.length) {
            return false;
        }
        ++this.statePos;
        return true;
    }

    private boolean readString(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "end of string expected");
        }
        if (!this.handleString((char)c) && this.statePos == 0 && c == 34) {
            this.event = EventType.STRING;
            this.setNextState();
            sp.unblock();
            return false;
        }
        return true;
    }

    private boolean handleString(char c) {
        if (this.statePos == 1) {
            this.statePos = 0;
            switch (c) {
                case 'b': {
                    c = (char)8;
                    break;
                }
                case 'r': {
                    c = (char)13;
                    break;
                }
                case 'n': {
                    c = (char)10;
                    break;
                }
                case 't': {
                    c = (char)9;
                    break;
                }
                case 'f': {
                    c = (char)12;
                    break;
                }
                case 'u': {
                    this.statePos = 2;
                    this.number = 0L;
                    return true;
                }
            }
            if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
                this.string.append(c);
            }
            return true;
        }
        if (this.statePos > 1) {
            long l;
            int i = StringUtil.decodeHexa((char)c);
            if (i != -1) {
                l = (Long)this.number;
                l = l << 4 | (long)i;
                this.number = l;
                if (++this.statePos <= 5) {
                    return true;
                }
            }
            if (this.statePos > 2) {
                l = (Long)this.number;
                this.number = null;
                if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
                    this.string.append((char)l);
                }
                this.statePos = 0;
                return true;
            }
            this.statePos = 0;
        }
        if (c == '\"') {
            return false;
        }
        if (c == '\\') {
            this.statePos = 1;
            return true;
        }
        if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
            this.string.append(c);
        }
        return true;
    }

    private boolean readNumeric(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.endNumeric(sp);
        }
        switch (this.statePos) {
            case 0: {
                if (c == 46) {
                    this.string.append('.');
                    this.statePos = 1;
                    return true;
                }
                if (c >= 48 && c <= 57) {
                    if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
                        this.string.append((char)c);
                    }
                    return true;
                }
                this.input.back((char)c);
                return this.endNumeric(sp);
            }
            case 1: {
                if (c >= 48 && c <= 57) {
                    if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
                        this.string.append((char)c);
                    }
                    return true;
                }
                if (c == 101 || c == 69) {
                    this.string.append('e');
                    this.statePos = 2;
                    return true;
                }
                this.input.back((char)c);
                return this.endNumeric(sp);
            }
            case 2: {
                if (c != 43 && c != 45) break;
                this.string.append((char)c);
                this.statePos = 3;
                return true;
            }
        }
        if (c >= 48 && c <= 57) {
            if (this.maxTextSize <= 0 || this.string.length() < this.maxTextSize) {
                this.string.append((char)c);
            }
            return true;
        }
        this.input.back((char)c);
        return this.endNumeric(sp);
    }

    private boolean endNumeric(Async<Exception> sp) {
        if (this.statePos == 0) {
            try {
                this.number = new BigInteger(this.string.asString());
            }
            catch (Exception t) {
                sp.error((Exception)this.error("Invalid integer value: " + this.string.asString()));
                return false;
            }
            this.event = EventType.NUMBER;
            this.setNextState();
            sp.unblock();
            return false;
        }
        try {
            this.number = new BigDecimal(this.string.asString());
        }
        catch (Exception t) {
            sp.error((Exception)this.error("Invalid decimal value: " + this.string.asString()));
            return false;
        }
        this.event = EventType.NUMBER;
        this.setNextState();
        sp.unblock();
        return false;
    }

    private boolean readFirstObjectAttribute(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "object attribute expected or character } to close the object");
        }
        if (c == 125) {
            this.context.removeFirst();
            this.event = EventType.END_OBJECT;
            sp.unblock();
            return false;
        }
        if (c == 34) {
            this.state = State.OBJECT_ATTRIBUTE_NAME;
            this.string = new UnprotectedStringBuffer();
            this.statePos = 0;
            return true;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        return this.unexpected(sp, c, "object attribute expected or character } to close the object");
    }

    private boolean readObjectAttributeName(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "object attribute name expected");
        }
        if (!this.handleString((char)c) && this.statePos == 0 && c == 34) {
            this.state = State.END_OBJECT_ATTRIBUTE_NAME;
            return true;
        }
        return true;
    }

    private boolean readEndObjectAttributeName(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "character ':' expected after object attribute name");
        }
        if (c == 58) {
            this.event = EventType.START_ATTRIBUTE;
            this.state = State.START;
            sp.unblock();
            return false;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        return this.unexpected(sp, c, "character ':' expected after object attribute name");
    }

    private boolean readNextObjectAttribute(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "expected is character , for a new attribute or } to close the object");
        }
        if (c == 125) {
            this.context.removeFirst();
            this.event = EventType.END_OBJECT;
            this.setNextState();
            sp.unblock();
            return false;
        }
        if (c == 44) {
            this.state = State.NEXT_OBJECT_ATTRIBUTE_NAME;
            return true;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        return this.unexpected(sp, c, "expected is character , for a new attribute or } to close the object");
    }

    private boolean readNextObjectAttributeName(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "object attribute expected");
        }
        if (c == 34) {
            this.state = State.OBJECT_ATTRIBUTE_NAME;
            this.string = new UnprotectedStringBuffer();
            this.statePos = 0;
            return true;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        return this.unexpected(sp, c, "object attribute expected");
    }

    private boolean readFirstArrayValue(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "expected a value or ] to close the array");
        }
        if (c == 93) {
            this.context.removeFirst();
            this.event = EventType.END_ARRAY;
            this.setNextState();
            sp.unblock();
            return false;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        this.state = State.START;
        this.input.back((char)c);
        return true;
    }

    private boolean readNextArrayValue(int c, Async<Exception> sp) {
        if (c == -1) {
            return this.unexpectedEnd(sp, "expected is character , for a new value or ] to close the array");
        }
        if (c == 93) {
            this.context.removeFirst();
            this.event = EventType.END_ARRAY;
            this.setNextState();
            sp.unblock();
            return false;
        }
        if (c == 44) {
            this.state = State.START;
            return true;
        }
        if (JSONReaderAsync.isSpaceChar((char)c)) {
            return true;
        }
        return this.unexpected(sp, c, "expected is character , for a new value or ] to close the array");
    }

    private static boolean isSpaceChar(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public JSONParsingException error(String message) {
        String loc = this.input.getDescription();
        StringBuilder s = new StringBuilder(loc.length() + message.length() + 10);
        s.append(loc).append(':').append(this.input.getLine()).append(',').append(this.input.getPositionInLine()).append(':').append(message);
        return new JSONParsingException(s.toString());
    }

    private JSONParsingException unexpected(int c, String message) {
        return this.error("Unexpected character '" + (char)c + "', " + message);
    }

    private boolean unexpected(Async<Exception> sp, int c, String message) {
        sp.error((Exception)this.unexpected(c, message));
        return false;
    }

    private JSONParsingException unexpectedEnd(String context) {
        return this.error("Unexpected end, " + context);
    }

    private boolean unexpectedEnd(Async<Exception> sp, String context) {
        sp.error((Exception)this.unexpectedEnd(context));
        return false;
    }

    private static enum ContextType {
        OBJECT,
        ARRAY;

    }

    private static enum State {
        START,
        TRUE,
        FALSE,
        NULL,
        STRING,
        NUMERIC,
        FIRST_OBJECT_ATTRIBUTE,
        OBJECT_ATTRIBUTE_NAME,
        END_OBJECT_ATTRIBUTE_NAME,
        NEXT_OBJECT_ATTRIBUTE,
        NEXT_OBJECT_ATTRIBUTE_NAME,
        FIRST_ARRAY_VALUE,
        NEXT_ARRAY_VALUE,
        END;

    }

    public static enum EventType {
        START_OBJECT,
        START_ATTRIBUTE,
        END_OBJECT,
        START_ARRAY,
        END_ARRAY,
        NULL,
        NUMBER,
        BOOLEAN,
        STRING;

    }
}

