/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.io.encoding.HexadecimalNumber;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.json.JSONParsingException;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;

public class JSONParser
extends Task.Cpu<Object, Exception> {
    private ICharacterStream.Readable.Buffered io;
    private static final String CTX_JSON = "JSON";
    private static final String CTX_ARRAY = "JSON array";
    private static final String CTX_OBJECT = "JSON object";
    private char[] c4 = new char[4];

    public static AsyncSupplier<Object, Exception> parse(ICharacterStream.Readable.Buffered io, byte priority) {
        JSONParser p = new JSONParser(io, priority);
        p.startOn(io.canStartReading(), false);
        return p.getOutput();
    }

    public JSONParser(ICharacterStream.Readable.Buffered io, byte priority) {
        super("JSON Parser", priority);
        this.io = io;
    }

    public Object run() throws Exception {
        return this.read(CTX_JSON);
    }

    private Object read(String context) throws IOException, JSONParsingException {
        char c = this.skipSpaces();
        switch (c) {
            case '{': {
                return this.readObject();
            }
            case '[': {
                return this.readArray();
            }
            case '\"': {
                return this.readString();
            }
            case '-': {
                return this.readNumber(true, 0L);
            }
            case 't': {
                if (!this.readTrue()) {
                    throw JSONParsingException.unexpectedCharacter(c, context);
                }
                return Boolean.TRUE;
            }
            case 'f': {
                if (!this.readFalse()) {
                    throw JSONParsingException.unexpectedCharacter(c, context);
                }
                return Boolean.FALSE;
            }
            case 'n': {
                if (!this.readNull()) {
                    throw JSONParsingException.unexpectedCharacter(c, context);
                }
                return null;
            }
        }
        if (c >= '0' && c <= '9') {
            return this.readNumber(false, (long)c - 48L);
        }
        throw JSONParsingException.unexpectedCharacter(c, context);
    }

    private char skipSpaces() throws IOException {
        char c;
        while (XMLStreamEvents.isSpaceChar((char)(c = this.io.read()))) {
        }
        return c;
    }

    private List<Object> readArray() throws IOException, JSONParsingException {
        char c;
        LinkedArrayList array = new LinkedArrayList(10);
        do {
            array.add(this.read(CTX_ARRAY));
        } while ((c = this.skipSpaces()) == ',');
        if (c == ']') {
            return array;
        }
        throw JSONParsingException.unexpectedCharacter(c, CTX_ARRAY);
    }

    private Map<String, Object> readObject() throws IOException, JSONParsingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean first = true;
        char c;
        while ((c = this.skipSpaces()) != '}') {
            if (!first) {
                if (c != ',') {
                    throw JSONParsingException.unexpectedCharacter(c, CTX_OBJECT);
                }
                c = this.skipSpaces();
            }
            if (c != '\"') {
                throw JSONParsingException.unexpectedCharacter(c, CTX_OBJECT);
            }
            String name = this.readString();
            c = this.skipSpaces();
            if (c != ':') {
                throw JSONParsingException.unexpectedCharacter(c, CTX_OBJECT);
            }
            Object val = this.read(CTX_OBJECT);
            map.put(name, val);
            first = false;
        }
        return map;
    }

    private String readString() throws IOException, JSONParsingException {
        UnprotectedStringBuffer s = new UnprotectedStringBuffer(new UnprotectedString(16));
        block4: while (true) {
            char c = this.io.read();
            switch (c) {
                case '\"': {
                    return s.toString();
                }
                case '\\': {
                    c = this.io.read();
                    if (c == '\"' || c == '\\' || c == '/') {
                        s.append(c);
                        continue block4;
                    }
                    if (c == 'b') {
                        s.append('\b');
                        continue block4;
                    }
                    if (c == 'f') {
                        s.append('\f');
                        continue block4;
                    }
                    if (c == 'n') {
                        s.append('\n');
                        continue block4;
                    }
                    if (c == 'r') {
                        s.append('\r');
                        continue block4;
                    }
                    if (c == 't') {
                        s.append('\t');
                        continue block4;
                    }
                    if (c == 'u') {
                        HexadecimalNumber h = new HexadecimalNumber();
                        for (int i = 0; i < 4; ++i) {
                            if (h.addChar(this.io.read())) continue;
                            throw new JSONParsingException("Invalid hexadecimal character");
                        }
                        s.append((char)h.getNumber());
                        continue block4;
                    }
                    s.append(c);
                    continue block4;
                }
            }
            s.append(c);
        }
    }

    private Number readNumber(boolean negative, long value) throws IOException {
        StringBuilder s;
        block8: {
            char c;
            while ((c = this.io.read()) >= '0' && c <= '9') {
                value *= 10L;
                value += (long)(c - 48);
            }
            if (c != '.') {
                if (c == 'e' || c == 'E') {
                    return this.readNumberExp(negative, value, c);
                }
                this.io.back(c);
                return negative ? -value : value;
            }
            s = new StringBuilder();
            if (negative) {
                s.append('-');
            }
            s.append(value);
            s.append('.');
            boolean e = false;
            while (true) {
                try {
                    c = this.io.read();
                }
                catch (EOFException ex) {
                    break block8;
                }
                if (c >= '0' && c <= '9') {
                    s.append(c);
                    continue;
                }
                if (e || c != 'e' && c != 'E') break;
                e = true;
                s.append(c);
                c = this.io.read();
                s.append(c);
                if (c != '+' && c != '-') continue;
                c = this.io.read();
                s.append(c);
            }
            this.io.back(c);
        }
        return new Double(s.toString());
    }

    private Double readNumberExp(boolean negative, long value, char c) throws IOException {
        StringBuilder s;
        block5: {
            s = new StringBuilder();
            if (negative) {
                s.append('-');
            }
            s.append(value);
            s.append(c);
            c = this.io.read();
            s.append(c);
            if (c == '+' || c == '-') {
                c = this.io.read();
                s.append(c);
            }
            while (true) {
                try {
                    c = this.io.read();
                }
                catch (EOFException e) {
                    break block5;
                }
                if (c < '0' || c > '9') break;
                s.append(c);
            }
            this.io.back(c);
        }
        return new Double(s.toString());
    }

    private boolean readTrue() throws IOException {
        if (this.io.readFullySync(this.c4, 0, 3) != 3) {
            return false;
        }
        return this.c4[0] == 'r' && this.c4[1] == 'u' && this.c4[2] == 'e';
    }

    private boolean readFalse() throws IOException {
        if (this.io.readFullySync(this.c4, 0, 4) != 4) {
            return false;
        }
        return this.c4[0] == 'a' && this.c4[1] == 'l' && this.c4[2] == 's' && this.c4[3] == 'e';
    }

    private boolean readNull() throws IOException {
        if (this.io.readFullySync(this.c4, 0, 3) != 3) {
            return false;
        }
        return this.c4[0] == 'u' && this.c4[1] == 'l' && this.c4[2] == 'l';
    }
}

